/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.modifiers.tools;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.library.tools.ToolMod;
import tconstruct.util.config.PHConstruct;

public class ModDurability
extends ToolMod {
    String tooltipName;
    String color;
    int durability;
    float modifier;
    int miningLevel;

    public ModDurability(ItemStack[] items, int effect, int dur, float mod, int level, String k, String tip, String c) {
        super(items, effect, k);
        this.durability = dur;
        this.modifier = mod;
        this.miningLevel = level;
        this.tooltipName = tip;
        this.color = c;
    }

    @Override
    protected boolean canModify(ItemStack tool, ItemStack[] input) {
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        if (tags.func_74764_b(this.key)) {
            return false;
        }
        return super.canModify(tool, input);
    }

    @Override
    public void modify(ItemStack[] input, ItemStack tool) {
        int mLevel;
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        int base = tags.func_74762_e("BaseDurability");
        int bonus = tags.func_74762_e("BonusDurability");
        float modDur = tags.func_74760_g("ModDurability");
        int total = (int)((float)(base + (bonus += this.durability)) * ((modDur += this.modifier) + 1.0f));
        if (total <= 0) {
            total = 1;
        }
        tags.func_74768_a("TotalDurability", total);
        tags.func_74768_a("BonusDurability", bonus);
        tags.func_74776_a("ModDurability", modDur);
        if (PHConstruct.miningLevelIncrease && (mLevel = tags.func_74762_e("HarvestLevel")) < this.miningLevel) {
            tags.func_74768_a("HarvestLevel", this.miningLevel);
        }
        int modifiers = tags.func_74762_e("Modifiers");
        tags.func_74768_a("Modifiers", --modifiers);
        tags.func_74757_a(this.key, true);
        String modTip = this.color + this.key;
        this.addToolTip(tool, this.tooltipName, modTip);
    }
}

