/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.miccore;

import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import cpw.mods.fml.relauncher.FMLInjectionData;
import cpw.mods.fml.relauncher.IFMLCallHook;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import java.awt.Desktop;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import micdoodle8.mods.miccore.MicdoodleAccessTransformer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

@IFMLLoadingPlugin.TransformerExclusions(value={"micdoodle8.mods.miccore"})
public class MicdoodlePlugin
implements IFMLLoadingPlugin,
IFMLCallHook {
    private static String transformerMain = "micdoodle8.mods.miccore.MicdoodleTransformer";
    public static boolean hasRegistered = false;
    public static final String mcVersion = "[1.6.4]";
    public static File mcDir;
    private static Constructor<?> sleepCancelledConstructor;
    private static Constructor<?> orientCameraConstructor;
    private static String galacticraftCoreClass;

    public String[] getLibraryRequestClass() {
        return null;
    }

    public static void versionCheck(String reqVersion, String mod) {
        String mcVersion = (String)FMLInjectionData.data()[4];
        if (!VersionParser.parseRange((String)reqVersion).containsVersion((ArtifactVersion)new DefaultArtifactVersion(mcVersion))) {
            String err = "This version of " + mod + " does not support minecraft version " + mcVersion;
            System.err.println(err);
            JEditorPane ep = new JEditorPane("text/html", "<html>" + err + "<br>Remove it from your mods folder and check <a href=\"http://micdoodle8.com\">here</a> for updates" + "</html>");
            ep.setEditable(false);
            ep.setOpaque(false);
            ep.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent event) {
                    try {
                        if (event.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                            Desktop.getDesktop().browse(event.getURL().toURI());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            JOptionPane.showMessageDialog(null, ep, "Fatal error", 0);
            System.exit(1);
        }
    }

    public String[] getASMTransformerClass() {
        MicdoodlePlugin.versionCheck(mcVersion, "MicdoodleCore");
        String[] asmStrings = new String[]{transformerMain};
        if (!hasRegistered) {
            List<String> asm = Arrays.asList(asmStrings);
            for (String s : asm) {
                try {
                    Class<?> c = Class.forName(s);
                    if (c == null) continue;
                    System.out.println("Successfully Registered Transformer");
                }
                catch (Exception ex) {
                    System.out.println("Error while running transformer " + s);
                    return null;
                }
            }
            hasRegistered = true;
        }
        return asmStrings;
    }

    public String getModContainerClass() {
        return "micdoodle8.mods.miccore.MicdoodleModContainer";
    }

    public String getSetupClass() {
        return "micdoodle8.mods.miccore.MicdoodlePlugin";
    }

    public void injectData(Map<String, Object> data) {
        if (data.containsKey("mcLocation")) {
            mcDir = (File)data.get("mcLocation");
        }
        System.out.println("[Micdoodle8Core]: Patching game...");
    }

    public Void call() throws Exception {
        MicdoodleAccessTransformer.addTransformerMap("micdoodlecore_at.cfg");
        return null;
    }

    public static void onSleepCancelled() {
        try {
            if (sleepCancelledConstructor == null) {
                sleepCancelledConstructor = Class.forName(galacticraftCoreClass + "$SleepCancelledEvent").getConstructor(new Class[0]);
            }
            MinecraftForge.EVENT_BUS.post((Event)sleepCancelledConstructor.newInstance(new Object[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void orientCamera() {
        try {
            if (orientCameraConstructor == null) {
                orientCameraConstructor = Class.forName(galacticraftCoreClass + "$OrientCameraEvent").getConstructor(new Class[0]);
            }
            MinecraftForge.EVENT_BUS.post((Event)orientCameraConstructor.newInstance(new Object[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        galacticraftCoreClass = "micdoodle8.mods.galacticraft.core.GalacticraftCore";
    }
}

