/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.configuration;

import biomesoplenty.api.Fluids;
import biomesoplenty.configuration.BOPBlocks;
import biomesoplenty.configuration.BOPItems;
import biomesoplenty.configuration.configfile.BOPConfigurationIDs;
import biomesoplenty.fluids.BlockFluidHoney;
import biomesoplenty.fluids.BlockFluidLiquidPoison;
import biomesoplenty.fluids.BlockFluidSpringWater;
import biomesoplenty.fluids.HoneyFluid;
import biomesoplenty.fluids.LiquidPoisonFluid;
import biomesoplenty.fluids.SpringWaterFluid;
import biomesoplenty.items.ItemBOPBucket;
import com.google.common.base.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;

public class BOPFluids {
    public static void init() {
        BOPFluids.registerFluids();
        BOPFluids.initializeLiquids();
        BOPFluids.initializeContainers();
        BOPFluids.registerBlocks();
        BOPFluids.registerItems();
    }

    private static void registerFluids() {
        Fluids.liquidPoisonFluid = Optional.of((Object)new LiquidPoisonFluid("bop.liquidPoison").setBlockID(BOPConfigurationIDs.liquidPoisonStillID));
        FluidRegistry.registerFluid((Fluid)((Fluid)Fluids.liquidPoisonFluid.get()));
        Fluids.springWaterFluid = Optional.of((Object)new SpringWaterFluid("bop.springWater").setBlockID(BOPConfigurationIDs.springWaterStillID));
        FluidRegistry.registerFluid((Fluid)((Fluid)Fluids.springWaterFluid.get()));
        Fluids.honeyFluid = Optional.of((Object)new HoneyFluid("bop.honey").setBlockID(BOPConfigurationIDs.honeyStillID));
        FluidRegistry.registerFluid((Fluid)((Fluid)Fluids.honeyFluid.get()));
    }

    private static void initializeLiquids() {
        Fluids.liquidPoison = Optional.of((Object)new BlockFluidLiquidPoison(BOPConfigurationIDs.liquidPoisonStillID, (Fluid)Fluids.liquidPoisonFluid.get(), Material.field_76244_g).func_71864_b("bop.liquidPoison"));
        Fluids.springWater = Optional.of((Object)new BlockFluidSpringWater(BOPConfigurationIDs.springWaterStillID, (Fluid)Fluids.springWaterFluid.get(), Material.field_76244_g).func_71864_b("bop.springWater"));
        Fluids.honey = Optional.of((Object)new BlockFluidHoney(BOPConfigurationIDs.honeyStillID, (Fluid)Fluids.honeyFluid.get(), Material.field_76244_g).func_71864_b("bop.honey"));
    }

    private static void initializeContainers() {
        Fluids.bopBucket = Optional.of((Object)new ItemBOPBucket(BOPConfigurationIDs.bopBucketID).func_77625_d(1).func_77655_b("bop.bopBucket"));
        FluidContainerRegistry.registerFluidContainer((Fluid)((Fluid)Fluids.liquidPoisonFluid.get()), (ItemStack)new ItemStack((Item)Fluids.bopBucket.get(), 1, 1), (ItemStack)new ItemStack(Item.field_77788_aw));
        FluidContainerRegistry.registerFluidContainer((Fluid)((Fluid)Fluids.honeyFluid.get()), (ItemStack)new ItemStack((Item)Fluids.bopBucket.get(), 1, 3), (ItemStack)new ItemStack(Item.field_77788_aw));
        FluidContainerRegistry.registerFluidContainer((Fluid)((Fluid)Fluids.springWaterFluid.get()), (ItemStack)new ItemStack((Item)Fluids.bopBucket.get(), 1, 2), (ItemStack)new ItemStack((Item)Fluids.bopBucket.get(), 1, 0));
    }

    private static void registerBlocks() {
        BOPBlocks.registerBlock((Block)Fluids.liquidPoison.get());
        BOPBlocks.registerBlock((Block)Fluids.springWater.get());
        BOPBlocks.registerBlock((Block)Fluids.honey.get());
    }

    private static void registerItems() {
        BOPItems.registerItem((Item)Fluids.bopBucket.get());
    }
}

