/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.integration;

import biomesoplenty.api.Blocks;
import biomesoplenty.api.Items;
import biomesoplenty.configuration.configfile.BOPConfigurationIDs;
import forestry.api.apiculture.FlowerManager;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.GlobalManager;
import forestry.api.core.ItemInterface;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.BackpackManager;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class ForestryIntegration {
    private static final int MINER = 0;
    private static final int DIGGER = 1;
    private static final int FORESTER = 2;

    protected static void init() {
        ForestryIntegration.addClimateInfo();
        ForestryIntegration.addFermenterRecipes();
        ForestryIntegration.addFlowers();
        ForestryIntegration.addBlocksToManager();
        ForestryIntegration.addBlocksToBackpacks();
    }

    private static void addClimateInfo() {
        EnumTemperature.hellishBiomeIds.add(BOPConfigurationIDs.netherBaseID);
        EnumTemperature.hellishBiomeIds.add(BOPConfigurationIDs.netherBoneID);
        EnumTemperature.hellishBiomeIds.add(BOPConfigurationIDs.netherDesertID);
        EnumTemperature.hellishBiomeIds.add(BOPConfigurationIDs.netherGardenID);
        EnumTemperature.hellishBiomeIds.add(BOPConfigurationIDs.netherLavaID);
        EnumHumidity.aridBiomeIds.add(BOPConfigurationIDs.netherBaseID);
        EnumHumidity.aridBiomeIds.add(BOPConfigurationIDs.netherBoneID);
        EnumHumidity.aridBiomeIds.add(BOPConfigurationIDs.netherDesertID);
        EnumHumidity.aridBiomeIds.add(BOPConfigurationIDs.netherGardenID);
        EnumHumidity.aridBiomeIds.add(BOPConfigurationIDs.netherLavaID);
        EnumTemperature.hotBiomeIds.add(BOPConfigurationIDs.badlandsID);
        EnumTemperature.hotBiomeIds.add(BOPConfigurationIDs.beachGravelID);
        EnumTemperature.hotBiomeIds.add(BOPConfigurationIDs.beachOvergrownID);
        EnumTemperature.hotBiomeIds.add(BOPConfigurationIDs.brushlandID);
        EnumTemperature.hotBiomeIds.add(BOPConfigurationIDs.deadlandsID);
        EnumTemperature.hotBiomeIds.add(BOPConfigurationIDs.dunesID);
        EnumTemperature.hotBiomeIds.add(BOPConfigurationIDs.mesaID);
        EnumTemperature.hotBiomeIds.add(BOPConfigurationIDs.steppeID);
        EnumTemperature.hotBiomeIds.add(BOPConfigurationIDs.volcanoID);
        EnumTemperature.hotBiomeIds.add(BOPConfigurationIDs.wastelandID);
        EnumTemperature.hotBiomeIds.add(BOPConfigurationIDs.promisedLandPlainsID);
        EnumTemperature.hotBiomeIds.add(BOPConfigurationIDs.promisedLandShrubID);
        EnumTemperature.hotBiomeIds.add(BOPConfigurationIDs.deadForestID);
        EnumTemperature.hotBiomeIds.add(BOPConfigurationIDs.desertNewID);
        EnumHumidity.aridBiomeIds.add(BOPConfigurationIDs.badlandsID);
        EnumHumidity.aridBiomeIds.add(BOPConfigurationIDs.brushlandID);
        EnumHumidity.aridBiomeIds.add(BOPConfigurationIDs.deadlandsID);
        EnumHumidity.aridBiomeIds.add(BOPConfigurationIDs.dunesID);
        EnumHumidity.aridBiomeIds.add(BOPConfigurationIDs.mesaID);
        EnumHumidity.aridBiomeIds.add(BOPConfigurationIDs.steppeID);
        EnumHumidity.aridBiomeIds.add(BOPConfigurationIDs.volcanoID);
        EnumHumidity.aridBiomeIds.add(BOPConfigurationIDs.wastelandID);
        EnumHumidity.aridBiomeIds.add(BOPConfigurationIDs.promisedLandPlainsID);
        EnumHumidity.aridBiomeIds.add(BOPConfigurationIDs.promisedLandShrubID);
        EnumHumidity.aridBiomeIds.add(BOPConfigurationIDs.deadForestID);
        EnumHumidity.aridBiomeIds.add(BOPConfigurationIDs.desertNewID);
        EnumTemperature.warmBiomeIds.add(BOPConfigurationIDs.bambooForestID);
        EnumTemperature.warmBiomeIds.add(BOPConfigurationIDs.hotSpringsID);
        EnumTemperature.warmBiomeIds.add(BOPConfigurationIDs.sacredSpringsID);
        EnumTemperature.warmBiomeIds.add(BOPConfigurationIDs.tropicalRainforestID);
        EnumTemperature.warmBiomeIds.add(BOPConfigurationIDs.promisedLandSwampID);
        EnumTemperature.warmBiomeIds.add(BOPConfigurationIDs.oasisID);
        EnumTemperature.warmBiomeIds.add(BOPConfigurationIDs.rainforestID);
        EnumTemperature.warmBiomeIds.add(BOPConfigurationIDs.tropicsID);
        EnumTemperature.warmBiomeIds.add(BOPConfigurationIDs.tropicsMountainID);
        EnumTemperature.warmBiomeIds.add(BOPConfigurationIDs.woodlandID);
        EnumTemperature.warmBiomeIds.add(BOPConfigurationIDs.jungleNewID);
        EnumTemperature.warmBiomeIds.add(BOPConfigurationIDs.jungleHillsNewID);
        EnumTemperature.warmBiomeIds.add(BOPConfigurationIDs.overgrownGreensID);
        EnumHumidity.dampBiomeIds.add(BOPConfigurationIDs.bambooForestID);
        EnumHumidity.dampBiomeIds.add(BOPConfigurationIDs.hotSpringsID);
        EnumHumidity.dampBiomeIds.add(BOPConfigurationIDs.sacredSpringsID);
        EnumHumidity.dampBiomeIds.add(BOPConfigurationIDs.tropicalRainforestID);
        EnumHumidity.dampBiomeIds.add(BOPConfigurationIDs.promisedLandSwampID);
        EnumHumidity.dampBiomeIds.add(BOPConfigurationIDs.oasisID);
        EnumHumidity.dampBiomeIds.add(BOPConfigurationIDs.rainforestID);
        EnumHumidity.dampBiomeIds.add(BOPConfigurationIDs.tropicsID);
        EnumHumidity.dampBiomeIds.add(BOPConfigurationIDs.tropicsMountainID);
        EnumHumidity.dampBiomeIds.add(BOPConfigurationIDs.woodlandID);
        EnumHumidity.dampBiomeIds.add(BOPConfigurationIDs.jungleNewID);
        EnumHumidity.dampBiomeIds.add(BOPConfigurationIDs.jungleHillsNewID);
        EnumHumidity.dampBiomeIds.add(BOPConfigurationIDs.overgrownGreensID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.bayouID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.bogID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.deadSwampID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.fungiForestID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.lushSwampID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.mangroveID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.marshID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.moorID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.mysticGroveID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.ominousWoodsID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.quagmireID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.sludgepitID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.wetlandID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.fenID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.swamplandNewID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.silkgladesID);
        EnumHumidity.dampBiomeIds.add(BOPConfigurationIDs.bayouID);
        EnumHumidity.dampBiomeIds.add(BOPConfigurationIDs.bogID);
        EnumHumidity.dampBiomeIds.add(BOPConfigurationIDs.deadSwampID);
        EnumHumidity.dampBiomeIds.add(BOPConfigurationIDs.fungiForestID);
        EnumHumidity.dampBiomeIds.add(BOPConfigurationIDs.lushSwampID);
        EnumHumidity.dampBiomeIds.add(BOPConfigurationIDs.mangroveID);
        EnumHumidity.dampBiomeIds.add(BOPConfigurationIDs.marshID);
        EnumHumidity.dampBiomeIds.add(BOPConfigurationIDs.moorID);
        EnumHumidity.dampBiomeIds.add(BOPConfigurationIDs.mysticGroveID);
        EnumHumidity.dampBiomeIds.add(BOPConfigurationIDs.ominousWoodsID);
        EnumHumidity.dampBiomeIds.add(BOPConfigurationIDs.quagmireID);
        EnumHumidity.dampBiomeIds.add(BOPConfigurationIDs.sludgepitID);
        EnumHumidity.dampBiomeIds.add(BOPConfigurationIDs.wetlandID);
        EnumHumidity.dampBiomeIds.add(BOPConfigurationIDs.fenID);
        EnumHumidity.dampBiomeIds.add(BOPConfigurationIDs.swamplandNewID);
        EnumHumidity.dampBiomeIds.add(BOPConfigurationIDs.silkgladesID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.birchForestID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.borealForestID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.canyonID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.chaparralID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.cherryBlossomGroveID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.coniferousForestID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.deciduousForestID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.fieldID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.gardenID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.grasslandID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.groveID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.highlandID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.lushDesertID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.mapleWoodsID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.meadowID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.orchardID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.originValleyID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.pastureID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.prairieID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.redwoodForestID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.seasonalForestID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.shieldID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.shoreID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.spruceWoodsID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.temperateRainforestID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.heathlandID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.promisedLandForestID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.savannaID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.scrublandID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.cragID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.jadeCliffsID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.outbackID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.shrublandID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.thicketID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.timberID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.plainsNewID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.extremeHillsNewID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.forestNewID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.forestHillsNewID);
        EnumTemperature.normalBiomeIds.add(BOPConfigurationIDs.autumnHillsID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.beachGravelID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.beachOvergrownID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.birchForestID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.borealForestID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.canyonID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.chaparralID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.cherryBlossomGroveID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.coniferousForestID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.deciduousForestID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.fieldID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.gardenID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.grasslandID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.groveID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.highlandID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.lushDesertID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.mapleWoodsID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.meadowID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.orchardID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.originValleyID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.pastureID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.prairieID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.redwoodForestID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.seasonalForestID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.shieldID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.shoreID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.spruceWoodsID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.temperateRainforestID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.heathlandID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.promisedLandForestID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.savannaID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.scrublandID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.cragID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.jadeCliffsID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.outbackID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.shrublandID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.thicketID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.timberID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.plainsNewID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.extremeHillsNewID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.forestNewID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.forestHillsNewID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.autumnHillsID);
        EnumTemperature.coldBiomeIds.add(BOPConfigurationIDs.tundraID);
        EnumTemperature.coldBiomeIds.add(BOPConfigurationIDs.arcticID);
        EnumTemperature.coldBiomeIds.add(BOPConfigurationIDs.deadForestSnowID);
        EnumTemperature.coldBiomeIds.add(BOPConfigurationIDs.mountainID);
        EnumTemperature.coldBiomeIds.add(BOPConfigurationIDs.taigaNewID);
        EnumTemperature.coldBiomeIds.add(BOPConfigurationIDs.taigaHillsNewID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.arcticID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.tundraID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.deadForestSnowID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.mountainID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.taigaNewID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.taigaHillsNewID);
        EnumTemperature.icyBiomeIds.add(BOPConfigurationIDs.alpsID);
        EnumTemperature.icyBiomeIds.add(BOPConfigurationIDs.coniferousForestSnowID);
        EnumTemperature.icyBiomeIds.add(BOPConfigurationIDs.frostForestID);
        EnumTemperature.icyBiomeIds.add(BOPConfigurationIDs.glacierID);
        EnumTemperature.icyBiomeIds.add(BOPConfigurationIDs.icyHillsID);
        EnumTemperature.icyBiomeIds.add(BOPConfigurationIDs.polarID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.alpsID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.coniferousForestSnowID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.frostForestID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.glacierID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.icyHillsID);
        EnumHumidity.normalBiomeIds.add(BOPConfigurationIDs.polarID);
    }

    private static void addFermenterRecipes() {
        ForestryIntegration.addFermenterRecipeSapling(new ItemStack((Block)Blocks.saplings.get(), 1, Short.MAX_VALUE));
        ForestryIntegration.addFermenterRecipeSapling(new ItemStack((Block)Blocks.colorizedSaplings.get(), 1, Short.MAX_VALUE));
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack((Item)Items.food.get(), 0)}, new FluidStack(FluidRegistry.getFluid((String)"juice"), 50), ItemInterface.getItem((String)"mulch"), 5);
    }

    private static void addFermenterRecipeSapling(ItemStack resource) {
        RecipeManagers.fermenterManager.addRecipe(resource, 250, 1.0f, FluidRegistry.getFluidStack((String)"biomass", (int)1), new FluidStack(FluidRegistry.getFluid((String)"water"), 1));
        RecipeManagers.fermenterManager.addRecipe(resource, 250, 1.0f, FluidRegistry.getFluidStack((String)"biomass", (int)1), FluidRegistry.getFluidStack((String)"juice", (int)1));
        RecipeManagers.fermenterManager.addRecipe(resource, 250, 1.0f, FluidRegistry.getFluidStack((String)"biomass", (int)1), FluidRegistry.getFluidStack((String)"honey", (int)1));
    }

    private static void addFlowers() {
        for (int i = 0; i < 10; ++i) {
            if (i == 2) continue;
            FlowerManager.plainFlowers.add(new ItemStack((Block)Blocks.flowers.get(), 1, i));
        }
    }

    private static void addBlocksToManager() {
        GlobalManager.leafBlockIds.add(((Block)Blocks.leaves1.get()).field_71990_ca);
        GlobalManager.leafBlockIds.add(((Block)Blocks.leaves2.get()).field_71990_ca);
        GlobalManager.leafBlockIds.add(((Block)Blocks.leaves3.get()).field_71990_ca);
        GlobalManager.leafBlockIds.add(((Block)Blocks.leaves4.get()).field_71990_ca);
        GlobalManager.leafBlockIds.add(((Block)Blocks.leavesColorized1.get()).field_71990_ca);
        GlobalManager.leafBlockIds.add(((Block)Blocks.leavesColorized2.get()).field_71990_ca);
        GlobalManager.leafBlockIds.add(((Block)Blocks.leavesFruit.get()).field_71990_ca);
        GlobalManager.leafBlockIds.add(((Block)Blocks.leavesFruit2.get()).field_71990_ca);
        GlobalManager.dirtBlockIds.add(((Block)Blocks.ash.get()).field_71990_ca);
        GlobalManager.dirtBlockIds.add(((Block)Blocks.hardDirt.get()).field_71990_ca);
        GlobalManager.dirtBlockIds.add(((Block)Blocks.holyGrass.get()).field_71990_ca);
        GlobalManager.dirtBlockIds.add(((Block)Blocks.mud.get()).field_71990_ca);
        GlobalManager.dirtBlockIds.add(((Block)Blocks.originGrass.get()).field_71990_ca);
        GlobalManager.dirtBlockIds.add(((Block)Blocks.redRock.get()).field_71990_ca);
        GlobalManager.sandBlockIds.add(((Block)Blocks.hardSand.get()).field_71990_ca);
        GlobalManager.snowBlockIds.add(((Block)Blocks.hardIce.get()).field_71990_ca);
    }

    private static void addBlocksToBackpacks() {
        BackpackManager.backpackItems[0].add(new ItemStack((Block)Blocks.amethystOre.get(), 1, 0));
        BackpackManager.backpackItems[0].add(new ItemStack((Block)Blocks.holyDirt.get(), 1, 0));
        BackpackManager.backpackItems[0].add(new ItemStack((Block)Blocks.holyStone.get(), 1, 0));
        BackpackManager.backpackItems[0].add(new ItemStack((Block)Blocks.redRock.get(), 1, Short.MAX_VALUE));
        BackpackManager.backpackItems[0].add(new ItemStack((Block)Blocks.driedDirt.get(), 1, 0));
        BackpackManager.backpackItems[0].add(new ItemStack((Block)Blocks.holyGrass.get(), 1, 0));
        BackpackManager.backpackItems[0].add(new ItemStack((Block)Blocks.cragRock.get(), 1, 0));
        BackpackManager.backpackItems[0].add(new ItemStack((Block)Blocks.ashStone.get(), 1, 0));
        BackpackManager.backpackItems[0].add(new ItemStack((Item)Items.miscItems.get(), 1, 2));
        BackpackManager.backpackItems[1].add(new ItemStack((Block)Blocks.holyGrass.get(), 1, 1));
        BackpackManager.backpackItems[1].add(new ItemStack((Block)Blocks.mud.get(), 1, Short.MAX_VALUE));
        BackpackManager.backpackItems[1].add(new ItemStack((Block)Blocks.hardDirt.get(), 1, 0));
        BackpackManager.backpackItems[1].add(new ItemStack((Block)Blocks.hardSand.get(), 1, 0));
        BackpackManager.backpackItems[1].add(new ItemStack((Block)Blocks.originGrass.get(), 1, 0));
        BackpackManager.backpackItems[1].add(new ItemStack((Block)Blocks.ash.get(), 1, 0));
        BackpackManager.backpackItems[2].add(new ItemStack((Block)Blocks.logs1.get(), 1, Short.MAX_VALUE));
        BackpackManager.backpackItems[2].add(new ItemStack((Block)Blocks.logs2.get(), 1, Short.MAX_VALUE));
        BackpackManager.backpackItems[2].add(new ItemStack((Block)Blocks.logs3.get(), 1, Short.MAX_VALUE));
        BackpackManager.backpackItems[2].add(new ItemStack((Block)Blocks.logs4.get(), 1, Short.MAX_VALUE));
        BackpackManager.backpackItems[2].add(new ItemStack((Block)Blocks.colorizedSaplings.get(), 1, Short.MAX_VALUE));
        BackpackManager.backpackItems[2].add(new ItemStack((Block)Blocks.saplings.get(), 1, Short.MAX_VALUE));
        BackpackManager.backpackItems[2].add(new ItemStack((Block)Blocks.leaves1.get(), 1, Short.MAX_VALUE));
        BackpackManager.backpackItems[2].add(new ItemStack((Block)Blocks.leaves2.get(), 1, Short.MAX_VALUE));
        BackpackManager.backpackItems[2].add(new ItemStack((Block)Blocks.leaves3.get(), 1, Short.MAX_VALUE));
        BackpackManager.backpackItems[2].add(new ItemStack((Block)Blocks.leaves4.get(), 1, Short.MAX_VALUE));
        BackpackManager.backpackItems[2].add(new ItemStack((Block)Blocks.leavesColorized1.get(), 1, Short.MAX_VALUE));
        BackpackManager.backpackItems[2].add(new ItemStack((Block)Blocks.leavesColorized2.get(), 1, Short.MAX_VALUE));
        BackpackManager.backpackItems[2].add(new ItemStack((Block)Blocks.leavesFruit.get(), 1, Short.MAX_VALUE));
        BackpackManager.backpackItems[2].add(new ItemStack((Block)Blocks.leavesFruit2.get(), 1, Short.MAX_VALUE));
        BackpackManager.backpackItems[2].add(new ItemStack((Block)Blocks.bamboo.get(), 1, 0));
        BackpackManager.backpackItems[2].add(new ItemStack((Block)Blocks.petals.get(), 1, Short.MAX_VALUE));
    }
}

