/*
 * Decompiled with CFR 0.152.
 */
package backpack.gui.parts;

import backpack.gui.GuiAdvanced;
import backpack.inventory.container.ContainerAdvanced;
import backpack.misc.ConfigurationBackpack;
import backpack.misc.Constants;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import org.lwjgl.opengl.GL11;

public abstract class GuiPart<C extends ContainerAdvanced> {
    protected int LEFTSPACING = 8;
    protected int SLOT = 18;
    protected C container;
    protected IInventory inventory;
    protected GuiAdvanced gui;
    protected int guiLeft;
    protected int guiTop;
    protected int offsetY;
    protected int textOffset;
    protected TEXTPOSITION textPosition = TEXTPOSITION.LEFT;
    protected int topSpacing;
    protected int bottomSpacing;
    public int inventoryRows;
    public int inventoryCols;
    public int firstSlot;
    public int lastSlot;
    public int ySize;
    public int xSize = 176;

    public GuiPart(ContainerAdvanced container, IInventory inventory, int inventoryRows) {
        this(container, inventory, inventoryRows, 9, false);
    }

    public GuiPart(ContainerAdvanced container, IInventory inventory, int inventoryRows, int inventoryCols, boolean big) {
        this.container = container;
        this.inventory = inventory;
        this.inventoryRows = big ? (inventoryRows > ConfigurationBackpack.DISPLAY_ROWS_L ? ConfigurationBackpack.DISPLAY_ROWS_L : inventoryRows) : (inventoryRows > ConfigurationBackpack.DISPLAY_ROWS_S ? ConfigurationBackpack.DISPLAY_ROWS_S : inventoryRows);
        this.inventoryCols = inventoryCols;
        this.ySize = this.inventoryRows * this.SLOT;
    }

    public void setGui(GuiAdvanced gui) {
        this.gui = gui;
    }

    public void initGui(int guiLeft, int guiTop) {
        this.guiLeft = guiLeft;
        this.guiTop = guiTop;
    }

    public void setOffsetY(int offsetY) {
        this.offsetY = offsetY;
    }

    public void setTextOffset(int offset) {
        this.textOffset = offset;
    }

    public void setTextPosition(TEXTPOSITION position) {
        this.textPosition = position;
    }

    public void setSpacings(int topSpacing, int bottomSpacing) {
        this.topSpacing = topSpacing;
        this.bottomSpacing = bottomSpacing;
        if (this.ySize != 0) {
            this.ySize += topSpacing + bottomSpacing;
        }
    }

    public void drawForegroundLayer(FontRenderer fontRenderer, int x, int y) {
        int xOffset;
        String text = this.inventory.func_94042_c() ? this.inventory.func_70303_b() : I18n.func_135053_a((String)this.inventory.func_70303_b());
        switch (this.textPosition) {
            case LEFT: {
                xOffset = 8;
                break;
            }
            case MIDDLE: {
                xOffset = this.xSize / 2 - fontRenderer.func_78256_a(text) / 2;
                break;
            }
            case RIGHT: {
                xOffset = this.xSize - fontRenderer.func_78256_a(text) - 6;
                break;
            }
            default: {
                xOffset = 0;
            }
        }
        fontRenderer.func_78276_b(text, xOffset, this.textOffset, 0x404040);
    }

    public void drawBackgroundLayer(float f, int x, int y) {
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Constants.guiCombined);
        if (this.ySize <= 138) {
            this.drawTexturedModalRect(this.guiLeft, this.guiTop + this.offsetY, 0, 4, this.xSize, this.ySize);
        } else {
            int drawn = 0;
            int i = 0;
            while ((double)i < Math.ceil((double)this.ySize / 138.0)) {
                int toDraw = this.ySize - drawn > 138 ? 138 : this.ySize - drawn;
                this.drawTexturedModalRect(this.guiLeft, this.guiTop + this.offsetY + drawn, 0, 4, this.xSize, toDraw);
                drawn += toDraw;
                ++i;
            }
        }
        GL11.glPopMatrix();
    }

    public void actionPerformed(GuiButton guiButton) {
    }

    public void addCraftingToCrafters(ICrafting player) {
    }

    public void detectAndSendChanges() {
    }

    @SideOnly(value=Side.CLIENT)
    public void updateProgressBar(int id, int value) {
    }

    public boolean isInRactangle(int mouseX, int mouseY) {
        int x = this.guiLeft;
        int y = this.guiTop + this.offsetY + this.topSpacing;
        int width = this.xSize;
        int height = this.ySize - this.topSpacing - this.bottomSpacing;
        return x <= mouseX && mouseX <= x + width && y <= mouseY && mouseY <= y + height;
    }

    public abstract void addSlots();

    protected void drawTexturedModalRect(int par1, int par2, int par3, int par4, int par5, int par6) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(par1 + 0), (double)(par2 + par6), 0.0, (double)((float)(par3 + 0) * f), (double)((float)(par4 + par6) * f1));
        tessellator.func_78374_a((double)(par1 + par5), (double)(par2 + par6), 0.0, (double)((float)(par3 + par5) * f), (double)((float)(par4 + par6) * f1));
        tessellator.func_78374_a((double)(par1 + par5), (double)(par2 + 0), 0.0, (double)((float)(par3 + par5) * f), (double)((float)(par4 + 0) * f1));
        tessellator.func_78374_a((double)(par1 + 0), (double)(par2 + 0), 0.0, (double)((float)(par3 + 0) * f), (double)((float)(par4 + 0) * f1));
        tessellator.func_78381_a();
    }

    public static enum TEXTPOSITION {
        LEFT,
        MIDDLE,
        RIGHT;

    }
}

