/*
 * Decompiled with CFR 0.152.
 */
package backpack.gui.parts;

import backpack.gui.parts.GuiPart;
import backpack.inventory.container.ContainerAdvanced;
import backpack.inventory.slot.SlotBrewingStandIngredient;
import backpack.inventory.slot.SlotBrewingStandPotion;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntityBrewingStand;

public class GuiPartBrewing
extends GuiPart {
    private int brewTime;
    private TileEntityBrewingStand brewingStand;

    public GuiPartBrewing(ContainerAdvanced container, IInventory inventory, int inventoryRows) {
        super(container, inventory, inventoryRows);
        this.ySize = 54;
        this.brewingStand = (TileEntityBrewingStand)inventory;
    }

    @Override
    public void addSlots() {
        int offset = this.offsetY + this.topSpacing + 1;
        this.container.addSlot(new SlotBrewingStandPotion(this.inventory, 0, 56, offset + 29));
        this.container.addSlot(new SlotBrewingStandPotion(this.inventory, 1, 79, offset + 36));
        this.container.addSlot(new SlotBrewingStandPotion(this.inventory, 2, 102, offset + 29));
        this.container.addSlot(new SlotBrewingStandIngredient(this.inventory, 3, 79, offset));
    }

    @Override
    public void drawBackgroundLayer(float f, int x, int y) {
        super.drawBackgroundLayer(f, x, y);
        this.drawTexturedModalRect(this.guiLeft + 55, this.guiTop + this.offsetY - 1, 0, 167, 64, 55);
        int brewTime = ((TileEntityBrewingStand)this.inventory).func_70355_t_();
        if (brewTime > 0) {
            int barHeight = (int)(28.0f * (1.0f - (float)brewTime / 400.0f));
            if (barHeight > 0) {
                this.drawTexturedModalRect(this.guiLeft + 98, this.guiTop + 17, 75, 167, 7, barHeight);
            }
            int workingState = brewTime / 2 % 7;
            switch (workingState) {
                case 0: {
                    barHeight = 28;
                    break;
                }
                case 1: {
                    barHeight = 24;
                    break;
                }
                case 2: {
                    barHeight = 20;
                    break;
                }
                case 3: {
                    barHeight = 16;
                    break;
                }
                case 4: {
                    barHeight = 11;
                    break;
                }
                case 5: {
                    barHeight = 6;
                    break;
                }
                case 6: {
                    barHeight = 0;
                }
            }
            if (barHeight > 0) {
                this.drawTexturedModalRect(this.guiLeft + 65, this.guiTop + 14 + 29 - barHeight, 64, 195 - barHeight, 11, barHeight);
            }
        }
    }

    @Override
    public void addCraftingToCrafters(ICrafting player) {
        player.func_71112_a((Container)this.container, 0, this.brewingStand.func_70355_t_());
    }

    @Override
    public void detectAndSendChanges() {
        for (int i = 0; i < this.container.getCrafters().size(); ++i) {
            ICrafting icrafting = this.container.getCrafters().get(i);
            if (this.brewTime == this.brewingStand.func_70355_t_()) continue;
            icrafting.func_71112_a((Container)this.container, 0, this.brewingStand.func_70355_t_());
        }
        this.brewTime = this.brewingStand.func_70355_t_();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateProgressBar(int id, int value) {
        if (id == 0) {
            this.brewingStand.func_70354_c(value);
        }
    }
}

