/*
 * Decompiled with CFR 0.152.
 */
package backpack.gui.parts;

import backpack.gui.helper.GuiIconButton;
import backpack.gui.parts.GuiPart;
import backpack.handler.PacketHandlerBackpack;
import backpack.inventory.InventoryWorkbenchBackpack;
import backpack.inventory.container.ContainerAdvanced;
import backpack.inventory.container.ContainerWorkbenchBackpack;
import backpack.inventory.slot.SlotCraftingAdvanced;
import backpack.inventory.slot.SlotPhantom;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.util.StatCollector;

public class GuiPartWorkbench
extends GuiPart<ContainerWorkbenchBackpack> {
    protected InventoryPlayer playerInventory;

    public GuiPartWorkbench(ContainerAdvanced container, IInventory inventory, InventoryPlayer playerInventory) {
        super(container, inventory, 3);
        this.playerInventory = playerInventory;
        if (!((ContainerWorkbenchBackpack)this.container).intelligent) {
            this.LEFTSPACING = 30;
        }
    }

    @Override
    public void addSlots() {
        int col;
        int row;
        int offset = this.offsetY + this.topSpacing + 1;
        this.firstSlot = ((ContainerWorkbenchBackpack)this.container).field_75151_b.size();
        int x = this.LEFTSPACING;
        x = ((ContainerWorkbenchBackpack)this.container).intelligent ? (x += 72) : (x += 95);
        ((ContainerWorkbenchBackpack)this.container).addSlot((Slot)new SlotCraftingAdvanced(this.playerInventory.field_70458_d, (ContainerWorkbenchBackpack)this.container, (InventoryWorkbenchBackpack)this.inventory, 0, x, offset + 18));
        x = this.LEFTSPACING;
        int y = offset;
        for (row = 0; row < this.inventoryRows; ++row) {
            for (col = 0; col < 3; ++col) {
                ((ContainerWorkbenchBackpack)this.container).addSlot(new SlotPhantom((IInventory)((ContainerWorkbenchBackpack)this.container).craftMatrix, col + row * 3, x, y));
                x += this.SLOT;
            }
            y += this.SLOT;
            x = this.LEFTSPACING;
        }
        if (((ContainerWorkbenchBackpack)this.container).intelligent) {
            y = offset;
            x += 108;
            for (row = 0; row < 3; ++row) {
                for (col = 0; col < 3; ++col) {
                    ((ContainerWorkbenchBackpack)this.container).addSlot(new SlotPhantom((IInventory)((ContainerWorkbenchBackpack)this.container).recipes, col + row * 3, x, y));
                    x += this.SLOT;
                }
                y += this.SLOT;
                x = this.LEFTSPACING + 108;
            }
        }
        this.lastSlot = ((ContainerWorkbenchBackpack)this.container).field_75151_b.size();
    }

    @Override
    public void initGui(int guiLeft, int guiTop) {
        super.initGui(guiLeft, guiTop);
        List<GuiButton> guiButtons = this.gui.getButtonList();
        guiButtons.clear();
        int offsetX = 88;
        if (((ContainerWorkbenchBackpack)this.container).intelligent) {
            offsetX -= 22;
        }
        GuiIconButton clearButton = new GuiIconButton(0, guiLeft + offsetX, guiTop + 16, 11, 11, "c");
        guiButtons.add(clearButton);
        if (((ContainerWorkbenchBackpack)this.container).intelligent) {
            GuiIconButton saveButton = new GuiIconButton(1, guiLeft + offsetX + 15, guiTop + 16, 11, 11, "s");
            guiButtons.add(saveButton);
        }
    }

    @Override
    public void actionPerformed(GuiButton guiButton) {
        switch (guiButton.field_73741_f) {
            case 0: {
                PacketHandlerBackpack.sendGuiCommandToServer("clear");
                break;
            }
            case 1: {
                PacketHandlerBackpack.sendGuiCommandToServer("save");
            }
        }
    }

    @Override
    public void drawForegroundLayer(FontRenderer fontRenderer, int x, int y) {
        String text = StatCollector.func_74838_a((String)"container.crafting");
        int xOffset = 28;
        if (((ContainerWorkbenchBackpack)this.container).intelligent) {
            xOffset = this.xSize / 2 - fontRenderer.func_78256_a(text) / 2;
        }
        fontRenderer.func_78276_b(text, xOffset, this.textOffset, 0x404040);
    }

    @Override
    public void drawBackgroundLayer(float f, int x, int y) {
        super.drawBackgroundLayer(f, x, y);
        if (!((ContainerWorkbenchBackpack)this.container).intelligent) {
            this.drawTexturedModalRect(this.guiLeft + 90, this.guiTop + 35, 0, 238, 22, 15);
        }
        for (int i = this.firstSlot; i < this.lastSlot; ++i) {
            Slot slot = (Slot)((ContainerWorkbenchBackpack)this.container).field_75151_b.get(i);
            if (slot instanceof SlotCraftingAdvanced) {
                this.drawTexturedModalRect(this.guiLeft + slot.field_75223_e - 5, this.guiTop + slot.field_75221_f - 5, 201, 18, 26, 26);
                continue;
            }
            this.drawTexturedModalRect(this.guiLeft + slot.field_75223_e - 1, this.guiTop + slot.field_75221_f - 1, 201, 0, 18, 18);
        }
    }
}

