/*
 * Decompiled with CFR 0.152.
 */
package backpack.inventory;

import backpack.inventory.IInventoryBackpack;
import backpack.inventory.InventoryBackpack;
import backpack.util.InventoryUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class InventoryWorkbenchBackpack
extends InventoryBackpack
implements IInventoryBackpack {
    protected ItemStack[] craftMatrix = new ItemStack[9];
    protected ItemStack[] recipes = new ItemStack[9];
    protected ItemStack[][] recipesIngredients = new ItemStack[9][9];

    public InventoryWorkbenchBackpack(EntityPlayer player, ItemStack is) {
        super(player, is);
    }

    public ItemStack getStackInCraftingSlot(int pos) {
        return this.craftMatrix[pos];
    }

    public void setCraftingSlotContent(int pos, ItemStack ist) {
        this.craftMatrix[pos] = ist;
        this.func_70296_d();
    }

    public ItemStack getStackInRecipeSlot(int pos) {
        return this.recipes[pos];
    }

    public void setRecipeSlotContent(int pos, ItemStack ist) {
        this.recipes[pos] = ist;
        for (int i = 0; i < this.craftMatrix.length; ++i) {
            this.recipesIngredients[pos][i] = this.craftMatrix[i] == null ? null : this.craftMatrix[i].func_77946_l();
        }
        this.func_70296_d();
    }

    public boolean hasRecipe(int recipe) {
        return this.recipes[recipe] != null;
    }

    public void loadRecipe(int recipe) {
        InventoryUtil.readInventory(this.craftMatrix, "Recipe-" + recipe, this.originalIS);
        this.func_70296_d();
    }

    @Override
    protected void writeToNBT() {
        super.writeToNBT();
        if (this.craftMatrix == null) {
            this.craftMatrix = new ItemStack[9];
        }
        if (this.recipes == null) {
            this.recipes = new ItemStack[9];
        }
        if (this.recipesIngredients == null) {
            this.recipesIngredients = new ItemStack[9][9];
        }
        InventoryUtil.writeInventory(this.craftMatrix, "Crafting", this.originalIS);
        InventoryUtil.writeInventory(this.recipes, "Recipes", this.originalIS);
        for (int i = 0; i < this.recipesIngredients.length; ++i) {
            InventoryUtil.writeInventory(this.recipesIngredients[i], "Recipe-" + i, this.originalIS);
        }
    }

    @Override
    protected void readFromNBT() {
        super.readFromNBT();
        if (this.craftMatrix == null) {
            this.craftMatrix = new ItemStack[9];
        }
        if (this.recipes == null) {
            this.recipes = new ItemStack[9];
        }
        if (this.recipesIngredients == null) {
            this.recipesIngredients = new ItemStack[9][9];
        }
        InventoryUtil.readInventory(this.craftMatrix, "Crafting", this.originalIS);
        InventoryUtil.readInventory(this.recipes, "Recipes", this.originalIS);
        for (int i = 0; i < this.recipesIngredients.length; ++i) {
            InventoryUtil.readInventory(this.recipesIngredients[i], "Recipe-" + i, this.originalIS);
        }
    }
}

