/*
 * Decompiled with CFR 0.152.
 */
package backpack.util;

import backpack.util.NBTUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class InventoryUtil {
    public static void readInventory(ItemStack[] inventory, String name, ItemStack backpack) {
        InventoryUtil.readInventory(inventory, name, backpack, true);
    }

    public static void readInventory(ItemStack[] inventory, String name, ItemStack backpack, boolean clearInventory) {
        if (clearInventory) {
            for (int i = 0; i < inventory.length; ++i) {
                inventory[i] = null;
            }
        }
        NBTTagList itemList = NBTUtil.getCompoundTag(backpack, name).func_74761_m("Items");
        for (int i = 0; i < itemList.func_74745_c(); ++i) {
            NBTTagCompound slotEntry = (NBTTagCompound)itemList.func_74743_b(i);
            int slot = slotEntry.func_74771_c("Slot") & 0xFF;
            if (slot < 0 || slot >= inventory.length) continue;
            inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)slotEntry);
        }
    }

    public static void writeInventory(ItemStack[] inventory, String name, ItemStack backpack) {
        InventoryUtil.writeInventory(inventory, name, backpack, 0, inventory.length);
    }

    public static void writeInventory(ItemStack[] inventory, String name, ItemStack backpack, int from) {
        InventoryUtil.writeInventory(inventory, name, backpack, from, inventory.length);
    }

    public static void writeInventory(ItemStack[] inventory, String name, ItemStack backpack, int from, int to) {
        NBTTagList itemList = new NBTTagList();
        for (int i = from; i < to; ++i) {
            if (inventory[i] == null) continue;
            NBTTagCompound slotEntry = new NBTTagCompound();
            slotEntry.func_74774_a("Slot", (byte)i);
            inventory[i].func_77955_b(slotEntry);
            itemList.func_74742_a((NBTBase)slotEntry);
        }
        NBTTagCompound craftingInventory = new NBTTagCompound();
        craftingInventory.func_74782_a("Items", (NBTBase)itemList);
        NBTUtil.setCompoundTag(backpack, name, craftingInventory);
    }

    public static boolean canStack(ItemStack stack1, ItemStack stack2) {
        return stack1 == null || stack2 == null || stack1.field_77993_c == stack2.field_77993_c && (!stack2.func_77981_g() || stack2.func_77960_j() == stack1.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack2, (ItemStack)stack1) && stack1.func_77985_e();
    }
}

