/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.integration.jei;

import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.api.capacitor.ICapacitorData;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.capacitor.DefaultCapacitorData;
import crazypants.enderio.base.fluid.IFluidCoolant;
import crazypants.enderio.base.fluid.IFluidFuel;
import crazypants.enderio.base.integration.jei.energy.EnergyIngredient;
import crazypants.enderio.base.integration.jei.energy.EnergyIngredientRenderer;
import crazypants.enderio.base.lang.LangFluid;
import crazypants.enderio.machines.capacitor.CapacitorKey;
import crazypants.enderio.machines.config.config.PersonalConfig;
import crazypants.enderio.machines.init.MachineObject;
import crazypants.enderio.machines.integration.jei.MachinesPlugin;
import crazypants.enderio.machines.lang.Lang;
import crazypants.enderio.machines.machine.generator.combustion.CombustionMath;
import crazypants.enderio.machines.machine.generator.combustion.GuiCombustionGenerator;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class CombustionRecipeCategory
extends BlankRecipeCategory<CombustionRecipeWrapper> {
    @Nonnull
    public static final String UID = "CombustionGenerator";
    static int xOff = 28;
    static int yOff = 7;
    static int xSize = 133;
    @Nonnull
    private final IDrawable background;

    public static void register() {
        if (!((Boolean)PersonalConfig.enableCombustionGenJEIRecipes.get()).booleanValue()) {
            return;
        }
        MachinesPlugin.iModRegistry.addRecipeCategories(new IRecipeCategory[]{new CombustionRecipeCategory(MachinesPlugin.iGuiHelper)});
        MachinesPlugin.iModRegistry.addRecipeCategoryCraftingItem(new ItemStack(MachineObject.block_combustion_generator.getBlockNN(), 1, 0), new String[]{UID});
        MachinesPlugin.iModRegistry.addRecipeCategoryCraftingItem(new ItemStack(MachineObject.block_enhanced_combustion_generator.getBlockNN(), 1, 0), new String[]{UID});
        MachinesPlugin.iModRegistry.addRecipeClickArea(GuiCombustionGenerator.class, 155, 42, 16, 16, new String[]{UID});
        long start = System.nanoTime();
        Map fluids = FluidRegistry.getRegisteredFluids();
        ArrayList<CombustionRecipeWrapper> result = new ArrayList<CombustionRecipeWrapper>();
        for (Fluid fluid1 : fluids.values()) {
            IFluidCoolant coolant = CombustionMath.toCoolant(fluid1);
            if (coolant == null) continue;
            for (Fluid fluid2 : fluids.values()) {
                IFluidFuel fuel = CombustionMath.toFuel(fluid2);
                if (fuel == null) continue;
                CombustionMath mathMin = new CombustionMath(coolant, fuel, CapacitorKey.COMBUSTION_POWER_GEN.getFloat((ICapacitorData)DefaultCapacitorData.BASIC_CAPACITOR), (float)CapacitorKey.COMBUSTION_POWER_EFFICIENCY.get((ICapacitorData)DefaultCapacitorData.BASIC_CAPACITOR));
                CombustionMath mathmax = new CombustionMath(coolant, fuel, CapacitorKey.COMBUSTION_POWER_GEN.getFloat((ICapacitorData)DefaultCapacitorData.ENDER_CAPACITOR), (float)CapacitorKey.ENHANCED_COMBUSTION_POWER_EFFICIENCY.get((ICapacitorData)DefaultCapacitorData.ENDER_CAPACITOR));
                result.add(new CombustionRecipeWrapper(new FluidStack(fluid1, 1000), new FluidStack(fluid2, 1000), mathMin, mathmax));
            }
        }
        long end = System.nanoTime();
        MachinesPlugin.iModRegistry.addRecipes(result, UID);
        Log.info((Object[])new Object[]{String.format("CombustionRecipeCategory: Added %d combustion generator recipes to JEI in %.3f seconds.", result.size(), (double)(end - start) / 1.0E9)});
    }

    public CombustionRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation backgroundLocation = EnderIO.proxy.getGuiTexture("combustion_gen");
        this.background = guiHelper.createDrawable(backgroundLocation, xOff, yOff, xSize, 70);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return MachineObject.block_combustion_generator.getBlock().func_149732_F();
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull CombustionRecipeWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
        fluidStacks.init(0, true, 114 - xOff, 21 - yOff, 15, 47, 1000, false, null);
        fluidStacks.init(1, true, 48 - xOff, 21 - yOff, 15, 47, 1000, false, null);
        fluidStacks.set(ingredients);
        IGuiIngredientGroup group = recipeLayout.getIngredientsGroup(EnergyIngredient.class);
        group.init(2, false, (IIngredientRenderer)EnergyIngredientRenderer.INSTANCE, 37 - xOff, 9 - yOff, 40, 10, 0, 0);
        group.init(3, false, (IIngredientRenderer)EnergyIngredientRenderer.INSTANCE, 101 - xOff, 9 - yOff, 40, 10, 0, 0);
        group.set(ingredients);
    }

    @Nonnull
    public String getModName() {
        return "enderiomachines";
    }

    public static class CombustionRecipeWrapper
    extends BlankRecipeWrapper {
        private final FluidStack fluidCoolant;
        private final FluidStack fluidFuel;
        private final CombustionMath mathMin;
        private final CombustionMath mathMax;

        private CombustionRecipeWrapper(FluidStack fluidCoolant, FluidStack fluidFuel, CombustionMath mathMin, CombustionMath mathMax) {
            this.fluidCoolant = fluidCoolant;
            this.fluidFuel = fluidFuel;
            this.mathMin = mathMin;
            this.mathMax = mathMax;
        }

        public void setInfoData(Map<Integer, ? extends IGuiIngredient<ItemStack>> ings) {
        }

        public void getIngredients(@Nonnull IIngredients ingredients) {
            ingredients.setInputs(FluidStack.class, Arrays.asList(this.fluidCoolant, this.fluidFuel));
            ingredients.setOutputs(EnergyIngredient.class, (List)new NNList((Object[])new EnergyIngredient[]{new EnergyIngredient(this.mathMin.getEnergyPerTick(), true), new EnergyIngredient(this.mathMax.getEnergyPerTick(), true)}));
        }

        public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            FontRenderer fr = minecraft.field_71466_p;
            String txt = Lang.GUI_COMBGEN_OUTPUT.get(new Object[]{""});
            int sw = fr.func_78256_a(txt);
            fr.func_175063_a(txt, (float)(89 - sw / 2 - xOff), (float)(0 - yOff), ColorUtil.getRGB((Color)Color.WHITE));
            txt = "-";
            sw = fr.func_78256_a(txt);
            fr.func_175063_a("-", (float)(89 - sw / 2 - xOff), (float)(10 - yOff), ColorUtil.getRGB((Color)Color.WHITE));
            int y = 21 - yOff - 2;
            int x = 114 - xOff;
            txt = this.mathMax.getTicksPerCoolant() + "-" + LangFluid.tMB((int)this.mathMin.getTicksPerCoolant());
            sw = fr.func_78256_a(txt);
            fr.func_175063_a(txt, (float)(x - sw / 2 + 7), (float)(y + fr.field_78288_b / 2 + 47), ColorUtil.getRGB((Color)Color.WHITE));
            x = 48 - xOff;
            txt = this.mathMax.getTicksPerFuel() + "-" + LangFluid.tMB((int)this.mathMin.getTicksPerFuel());
            sw = fr.func_78256_a(txt);
            fr.func_175063_a(txt, (float)(x - sw / 2 + 7), (float)(y + fr.field_78288_b / 2 + 47), ColorUtil.getRGB((Color)Color.WHITE));
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        @Nonnull
        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            if (mouseY < 20 - yOff || mouseY > 21 - yOff + 47 + 1) {
                return Lang.JEI_COMBGEN_RANGE.getLines(new Object[0]);
            }
            return super.getTooltipStrings(mouseX, mouseY);
        }
    }
}

