/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.integration.jei;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.integration.jei.RecipeWrapperBase;
import crazypants.enderio.base.integration.jei.RecipeWrapperIMachineRecipe;
import crazypants.enderio.base.recipe.IMachineRecipe;
import crazypants.enderio.base.recipe.MachineRecipeInput;
import crazypants.enderio.base.recipe.MachineRecipeRegistry;
import crazypants.enderio.base.recipe.enchanter.EnchanterRecipe;
import crazypants.enderio.machines.config.config.PersonalConfig;
import crazypants.enderio.machines.init.MachineObject;
import crazypants.enderio.machines.integration.jei.MachinesPlugin;
import crazypants.enderio.machines.lang.Lang;
import crazypants.enderio.machines.machine.enchanter.ContainerEnchanter;
import crazypants.enderio.machines.machine.enchanter.GuiEnchanter;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class EnchanterRecipeCategory
extends BlankRecipeCategory<EnchanterRecipeWrapper> {
    @Nonnull
    public static final String UID = "Enchanter";
    private static final int xOff = 16;
    private static final int yOff = 24;
    @Nonnull
    private final IDrawable background;

    public static void register() {
        if (!((Boolean)PersonalConfig.enableEnchanterJEIRecipes.get()).booleanValue()) {
            return;
        }
        RecipeWrapperBase.setLevelData(EnchanterRecipeWrapper.class, (IGuiHelper)MachinesPlugin.iGuiHelper, (int)123, (int)37, null, null);
        MachinesPlugin.iModRegistry.addRecipeCategories(new IRecipeCategory[]{new EnchanterRecipeCategory(MachinesPlugin.iGuiHelper)});
        MachinesPlugin.iModRegistry.addRecipeClickArea(GuiEnchanter.class, 155, 8, 16, 16, new String[]{UID});
        MachinesPlugin.iModRegistry.addRecipeCatalyst((Object)new ItemStack(MachineObject.block_enchanter.getBlockNN()), new String[]{UID});
        MachinesPlugin.iModRegistry.addRecipes((Collection)NullHelper.notnullJ(MachineRecipeRegistry.instance.getRecipesForMachine("enchanter").values().stream().map(EnchanterRecipeWrapper::create).flatMap(Collection::stream).collect(Collectors.toList()), (String)"Stream::collect"), UID);
        MachinesPlugin.iModRegistry.getRecipeTransferRegistry().addRecipeTransferHandler(ContainerEnchanter.class, UID, ContainerEnchanter.FIRST_RECIPE_SLOT, ContainerEnchanter.NUM_RECIPE_SLOT, ContainerEnchanter.FIRST_INVENTORY_SLOT, ContainerEnchanter.NUM_INVENTORY_SLOT);
    }

    public EnchanterRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation backgroundLocation = EnderIO.proxy.getGuiTexture("enchanter");
        this.background = guiHelper.drawableBuilder(backgroundLocation, 15, 24, 146, 48).build();
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return MachineObject.block_enchanter.getBlock().func_149732_F();
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull EnchanterRecipeWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 0, 10);
        guiItemStacks.init(1, true, 49, 10);
        guiItemStacks.init(2, true, 69, 10);
        guiItemStacks.init(3, false, 128, 10);
        guiItemStacks.set(ingredients);
    }

    @Nonnull
    public String getModName() {
        return "enderiomachines";
    }

    public static class EnchanterRecipeWrapper
    extends RecipeWrapperIMachineRecipe<EnchanterRecipe> {
        @Nonnull
        private static final ResourceLocation XP_ORB_TEXTURE = new ResourceLocation("textures/entity/experience_orb.png");
        @Nonnull
        private final NNList<ItemStack> bookInputs;
        @Nonnull
        private final NNList<ItemStack> itemInputs;
        @Nonnull
        private final NNList<ItemStack> lapisInputs;
        private final int level;

        @Nonnull
        protected static List<EnchanterRecipeWrapper> create(IMachineRecipe imr) {
            if (!(imr instanceof EnchanterRecipe)) {
                return NNList.emptyList();
            }
            EnchanterRecipe rec = (EnchanterRecipe)imr;
            NNList result = new NNList();
            Enchantment enchantment = rec.getEnchantment();
            block0: for (int level = 1; level <= enchantment.func_77325_b(); ++level) {
                ItemStack book2;
                NNList bookInputs = new NNList();
                for (ItemStack book2 : rec.getBook().getItemStacks()) {
                    bookInputs.add((Object)book2.func_77946_l());
                }
                NNList lapisInputs = new NNList();
                book2 = rec.getLapis().getItemStacks().iterator();
                while (book2.hasNext()) {
                    ItemStack lapis = (ItemStack)book2.next();
                    lapis = lapis.func_77946_l();
                    lapis.func_190920_e(rec.getLapizForLevel(level));
                    if (lapis.func_190916_E() > lapis.func_77976_d()) continue;
                    lapisInputs.add((Object)lapis);
                }
                if (lapisInputs.isEmpty()) break;
                NNList itemInputs = new NNList();
                for (ItemStack item : rec.getInput().getItemStacks()) {
                    item = item.func_77946_l();
                    item.func_190920_e(rec.getItemsPerLevel() * level);
                    if (item.func_190916_E() <= item.func_77976_d()) {
                        itemInputs.add((Object)item);
                    }
                    if (!itemInputs.isEmpty()) continue;
                    break block0;
                }
                result.add(new EnchanterRecipeWrapper(rec, level, (NNList<ItemStack>)bookInputs, (NNList<ItemStack>)lapisInputs, (NNList<ItemStack>)itemInputs));
            }
            return (List)NullHelper.notnullJ((Object)result, (String)"Eclipse is stupid");
        }

        private EnchanterRecipeWrapper(@Nonnull EnchanterRecipe rec, int level, @Nonnull NNList<ItemStack> bookInputs, @Nonnull NNList<ItemStack> lapisInputs, @Nonnull NNList<ItemStack> itemInputs) {
            super((IMachineRecipe)rec);
            this.level = level;
            this.bookInputs = bookInputs;
            this.lapisInputs = lapisInputs;
            this.itemInputs = itemInputs;
        }

        public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            Enchantment enchantment = ((EnchanterRecipe)this.recipe).getEnchantment();
            String name = enchantment.func_77316_c(this.level);
            minecraft.field_71466_p.func_78276_b(name, 147 - minecraft.field_71466_p.func_78256_a(name), 0, 0x8B8B8B);
            int xpCost = ((EnchanterRecipe)this.recipe).getXPCost(this.getMachineInputs());
            minecraft.func_110434_K().func_110577_a(XP_ORB_TEXTURE);
            GlStateManager.func_179124_c((float)0.5019608f, (float)1.0f, (float)0.1254902f);
            Gui.func_152125_a((int)0, (int)29, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16, (float)64.0f, (float)64.0f);
            minecraft.field_71466_p.func_175063_a("  " + Lang.GUI_VANILLA_REPAIR_COST.get(new Object[]{xpCost}), 9.0f, 33.0f, 8453920);
            super.drawInfo(minecraft, recipeWidth, recipeHeight, mouseX, mouseY);
        }

        @Nonnull
        private NNList<MachineRecipeInput> getMachineInputs() {
            return new NNList((Object[])new MachineRecipeInput[]{new MachineRecipeInput(0, (ItemStack)this.bookInputs.get(0)), new MachineRecipeInput(1, (ItemStack)this.itemInputs.get(0)), new MachineRecipeInput(1, (ItemStack)this.lapisInputs.get(0))});
        }

        public void getIngredients(@Nonnull IIngredients ingredients) {
            ingredients.setInputLists(VanillaTypes.ITEM, (List)new NNList((Object[])new List[]{this.bookInputs, this.itemInputs, this.lapisInputs}));
            ingredients.setOutput(VanillaTypes.ITEM, (Object)((EnchanterRecipe)this.recipe).getCompletedResult((long)0L, (float)1.0f, this.getMachineInputs())[0].item);
        }
    }
}

