/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.integration.jei;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.fluid.Fluids;
import crazypants.enderio.base.integration.jei.RecipeWrapperBase;
import crazypants.enderio.base.integration.jei.RecipeWrapperIMachineRecipe;
import crazypants.enderio.base.recipe.IMachineRecipe;
import crazypants.enderio.base.recipe.MachineRecipeRegistry;
import crazypants.enderio.base.recipe.RecipeLevel;
import crazypants.enderio.base.recipe.tank.TankMachineRecipe;
import crazypants.enderio.base.xp.XpUtil;
import crazypants.enderio.machines.config.config.PersonalConfig;
import crazypants.enderio.machines.config.config.TankConfig;
import crazypants.enderio.machines.init.MachineObject;
import crazypants.enderio.machines.integration.jei.MachinesPlugin;
import crazypants.enderio.machines.lang.Lang;
import crazypants.enderio.machines.machine.tank.ContainerTank;
import crazypants.enderio.machines.machine.tank.GuiTank;
import crazypants.enderio.machines.machine.tank.TileTank;
import crazypants.enderio.util.Prep;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class TankRecipeCategory
extends BlankRecipeCategory<TankRecipeWrapper> {
    @Nonnull
    public static final String UID = "EIOTank";
    private static int xOff = 15;
    private static int yOff = 20;
    @Nonnull
    private final IDrawable background;

    public static void register() {
        if (!((Boolean)PersonalConfig.enableTankFluidInOutJEIRecipes.get()).booleanValue() && !((Boolean)PersonalConfig.enableTankMendingJEIRecipes.get()).booleanValue()) {
            return;
        }
        RecipeWrapperBase.setLevelData(TankRecipeWrapperSimple.class, (IGuiHelper)MachinesPlugin.iGuiHelper, (int)(140 - xOff), (int)(40 - yOff - 5), (String)"textures/blocks/block_tank.png", (String)"textures/blocks/block_tank.png");
        RecipeWrapperBase.setLevelData(TankRecipeWrapperRecipe.class, (IGuiHelper)MachinesPlugin.iGuiHelper, (int)(140 - xOff), (int)(40 - yOff - 5), (String)"textures/blocks/block_tank.png", (String)"textures/blocks/block_tank.png");
        MachinesPlugin.iModRegistry.addRecipeCategories(new IRecipeCategory[]{new TankRecipeCategory(MachinesPlugin.iGuiHelper)});
        MachinesPlugin.iModRegistry.addRecipeCategoryCraftingItem(new ItemStack(MachineObject.block_tank.getBlockNN(), 1, 0), new String[]{UID});
        MachinesPlugin.iModRegistry.addRecipeCategoryCraftingItem(new ItemStack(MachineObject.block_tank.getBlockNN(), 1, 1), new String[]{UID});
        MachinesPlugin.iModRegistry.addRecipeClickArea(GuiTank.class, 155, 42, 16, 16, new String[]{UID});
        long start = System.nanoTime();
        List validItems = MachinesPlugin.iModRegistry.getIngredientRegistry().getIngredients(ItemStack.class);
        ArrayList<TankRecipeWrapper> result = new ArrayList<TankRecipeWrapper>();
        for (Object recipe : MachineRecipeRegistry.instance.getRecipesForMachine("tankempty").values()) {
            if (!(recipe instanceof TankMachineRecipe)) continue;
            result.add(new TankRecipeWrapperRecipe((TankMachineRecipe)recipe));
        }
        for (Object recipe : MachineRecipeRegistry.instance.getRecipesForMachine("tankfill").values()) {
            if (!(recipe instanceof TankMachineRecipe)) continue;
            result.add(new TankRecipeWrapperRecipe((TankMachineRecipe)recipe));
        }
        if (((Boolean)PersonalConfig.enableTankFluidInOutJEIRecipes.get()).booleanValue()) {
            Map fluids = FluidRegistry.getRegisteredFluids();
            for (ItemStack stack : validItems) {
                ItemStack drainedStack = stack.func_77946_l();
                IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)drainedStack);
                if (fluidHandler == null) continue;
                FluidStack drain = fluidHandler.drain(16000, true);
                drainedStack = fluidHandler.getContainer();
                if (drain != null && drain.amount > 0) {
                    result.add(new TankRecipeWrapperSimple(null, drain, stack.func_77946_l(), drainedStack));
                    continue;
                }
                for (Fluid fluid : fluids.values()) {
                    ItemStack filledStack = stack.func_77946_l();
                    fluidHandler = FluidUtil.getFluidHandler((ItemStack)filledStack);
                    if (fluidHandler == null) continue;
                    int filled = fluidHandler.fill(new FluidStack(fluid, 16000), true);
                    filledStack = fluidHandler.getContainer();
                    if (filled <= 0) continue;
                    result.add(new TankRecipeWrapperSimple(new FluidStack(fluid, filled), null, stack.func_77946_l(), filledStack));
                }
            }
        }
        if (((Boolean)TankConfig.allowMending.get()).booleanValue() && ((Boolean)PersonalConfig.enableTankMendingJEIRecipes.get()).booleanValue()) {
            Map<Enchantment, Integer> enchMap = Collections.singletonMap(Enchantments.field_185296_A, 1);
            int maxMendable = TileTank.xpToDurability(XpUtil.liquidToExperience((int)16000));
            for (ItemStack stack : validItems) {
                ItemStack enchantedStack;
                if (!stack.func_77984_f()) continue;
                if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185296_A, (ItemStack)stack) > 0) {
                    enchantedStack = stack.func_77946_l();
                } else {
                    if (!Enchantments.field_185296_A.func_92089_a(stack)) continue;
                    enchantedStack = stack.func_77946_l();
                    EnchantmentHelper.func_82782_a(enchMap, (ItemStack)enchantedStack);
                }
                ItemStack damagedStack = enchantedStack.func_77946_l();
                damagedStack.func_77964_b(damagedStack.func_77958_k() * 3 / 4);
                int damageMendable = Math.min(maxMendable, damagedStack.func_77952_i());
                enchantedStack.func_77964_b(damagedStack.func_77952_i() - damageMendable);
                if (damagedStack.func_77952_i() == enchantedStack.func_77952_i() || !Prep.isValid((ItemStack)damagedStack) || !Prep.isValid((ItemStack)enchantedStack)) continue;
                result.add(new TankRecipeWrapperSimple(new FluidStack(Fluids.XP_JUICE.getFluid(), XpUtil.experienceToLiquid((int)TileTank.durabilityToXp(damageMendable))), null, damagedStack, enchantedStack));
            }
        }
        long end = System.nanoTime();
        MachinesPlugin.iModRegistry.addRecipes(result, UID);
        MachinesPlugin.iModRegistry.getRecipeTransferRegistry().addRecipeTransferHandler(ContainerTank.class, UID, 0, 2, 3, 36);
        Log.info((Object[])new Object[]{String.format("TankRecipeCategory: Added %d tank recipes to JEI in %.3f seconds.", result.size(), (double)(end - start) / 1.0E9)});
    }

    private static String fluidString(FluidStack stack) {
        return stack == null ? "nothing" : stack.amount + "x" + stack.getUnlocalizedName();
    }

    public TankRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation backgroundLocation = EnderIO.proxy.getGuiTexture("tank");
        this.background = guiHelper.createDrawable(backgroundLocation, xOff, yOff, 146, 49);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return MachineObject.block_tank.getBlock().func_149732_F();
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, final @Nonnull TankRecipeWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        List outputIngredient;
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
        guiItemStacks.init(0, true, 44 - xOff - 1, 21 - yOff - 1);
        guiItemStacks.init(1, true, 116 - xOff - 1, 21 - yOff - 1);
        guiItemStacks.init(2, false, 44 - xOff - 1, 52 - yOff - 1);
        guiItemStacks.init(3, false, 116 - xOff - 1, 52 - yOff - 1);
        fluidStacks.init(0, false, 80 - xOff, 21 - yOff, 16, 47, 16000, true, null);
        List itemInputs = ingredients.getInputs(ItemStack.class);
        List itemOutputs = ingredients.getOutputs(ItemStack.class);
        List fluidInputs = ingredients.getInputs(FluidStack.class);
        List fluidOutputs = ingredients.getOutputs(FluidStack.class);
        List inputIngredient = itemInputs.isEmpty() ? null : (List)itemInputs.get(0);
        List list = outputIngredient = itemOutputs.isEmpty() ? null : (List)itemOutputs.get(0);
        if (fluidInputs.isEmpty()) {
            guiItemStacks.set(0, inputIngredient);
            guiItemStacks.set(2, outputIngredient);
            fluidStacks.set(0, (List)fluidOutputs.get(0));
        } else {
            guiItemStacks.set(1, inputIngredient);
            guiItemStacks.set(3, outputIngredient);
            fluidStacks.set(0, (List)fluidInputs.get(0));
        }
        fluidStacks.addTooltipCallback((ITooltipCallback)new ITooltipCallback<FluidStack>(){

            public void onTooltip(int slotIndex, boolean input, FluidStack ingredient, List<String> tooltip) {
                String uuid = recipeWrapper.getUUID();
                if (uuid != null) {
                    tooltip.add(Lang.JEI_RECIPE.get(new Object[]{uuid}));
                }
            }
        });
    }

    @Nonnull
    public String getModName() {
        return "enderiomachines";
    }

    public static class TankRecipeWrapperRecipe
    extends TankRecipeWrapper<TankMachineRecipe> {
        public TankRecipeWrapperRecipe(@Nonnull TankMachineRecipe recipe) {
            super(recipe);
        }

        public void getIngredients(@Nonnull IIngredients ingredients) {
            ingredients.setInput(ItemStack.class, (Object)((TankMachineRecipe)this.recipe).getInput().getItemStacksRaw());
            FluidStack fluid = ((TankMachineRecipe)this.recipe).getFluid();
            NNList fluids = new NNList();
            if (((TankMachineRecipe)this.recipe).getLogic() == TankMachineRecipe.Logic.XPBOTTLE) {
                for (int i = 3; i <= 11; ++i) {
                    FluidStack copy = fluid.copy();
                    copy.amount *= XpUtil.experienceToLiquid((int)i);
                    fluids.add((Object)copy);
                }
            } else {
                fluids.add((Object)((TankMachineRecipe)this.recipe).getLogic().convertFluidResult(((TankMachineRecipe)this.recipe).isFilling(), ((TankMachineRecipe)this.recipe).getInput().getItemStack(), fluid, fluid, ((TankMachineRecipe)this.recipe).getOutput().getItemStack()));
            }
            if (((TankMachineRecipe)this.recipe).isFilling()) {
                ingredients.setInputLists(FluidStack.class, (List)new NNList((Object[])new List[]{fluids}));
            } else {
                ingredients.setOutputLists(FluidStack.class, (List)new NNList((Object[])new List[]{fluids}));
            }
            ingredients.setOutput(ItemStack.class, (Object)((TankMachineRecipe)this.recipe).getLogic().convertItemResult(((TankMachineRecipe)this.recipe).isFilling(), ((TankMachineRecipe)this.recipe).getInput().getItemStack(), fluid, fluid, ((TankMachineRecipe)this.recipe).getOutput().getItemStack()));
        }

        @Override
        public String getUUID() {
            return ((TankMachineRecipe)this.recipe).getRecipeName();
        }
    }

    public static class TankRecipeWrapperSimple
    extends TankRecipeWrapper<IMachineRecipe> {
        private final FluidStack fluidInput;
        private final FluidStack fluidOutput;
        private final ItemStack itemInput;
        private final ItemStack itemOutput;

        public TankRecipeWrapperSimple(FluidStack fluidInput, FluidStack fluidOutput, ItemStack itemInput, ItemStack itemOutput) {
            super(null);
            this.fluidInput = fluidInput;
            this.fluidOutput = fluidOutput;
            this.itemInput = itemInput;
            this.itemOutput = itemOutput;
        }

        public void setInfoData(Map<Integer, ? extends IGuiIngredient<ItemStack>> ings) {
        }

        public void getIngredients(@Nonnull IIngredients ingredients) {
            if (this.itemInput != null) {
                ingredients.setInputs(ItemStack.class, Collections.singletonList(this.itemInput));
            }
            if (this.fluidInput != null) {
                ingredients.setInputs(FluidStack.class, Collections.singletonList(this.fluidInput));
            }
            if (this.itemOutput != null) {
                ingredients.setOutput(ItemStack.class, (Object)this.itemOutput);
            }
            if (this.fluidOutput != null) {
                ingredients.setOutput(FluidStack.class, (Object)this.fluidOutput);
            }
        }

        @Override
        public String getUUID() {
            return null;
        }

        protected RecipeLevel getRecipeLevel() {
            return RecipeLevel.IGNORE;
        }
    }

    public static abstract class TankRecipeWrapper<E extends IMachineRecipe>
    extends RecipeWrapperIMachineRecipe<E> {
        public TankRecipeWrapper(E recipe) {
            super(recipe);
        }

        public abstract String getUUID();
    }
}

