/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.integration.jei;

import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.api.capacitor.ICapacitorData;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.capacitor.DefaultCapacitorData;
import crazypants.enderio.base.fluid.Fluids;
import crazypants.enderio.base.integration.jei.energy.EnergyIngredient;
import crazypants.enderio.base.integration.jei.energy.EnergyIngredientRenderer;
import crazypants.enderio.base.lang.LangFluid;
import crazypants.enderio.machines.capacitor.CapacitorKey;
import crazypants.enderio.machines.config.config.PersonalConfig;
import crazypants.enderio.machines.config.config.ZombieGenConfig;
import crazypants.enderio.machines.init.MachineObject;
import crazypants.enderio.machines.integration.jei.MachinesPlugin;
import crazypants.enderio.machines.lang.Lang;
import crazypants.enderio.machines.machine.generator.zombie.GuiZombieGenerator;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class ZombieGeneratorRecipeCategory
extends BlankRecipeCategory<ZombieGeneratorRecipeWrapper> {
    @Nonnull
    public static final String UID = "ZombieGenerator";
    public static final int tankCapacity = 2000;
    static int xOff = 28;
    static int yOff = 7;
    static int xSize = 133;
    @Nonnull
    private final IDrawable background;

    public static void register() {
        if (!((Boolean)PersonalConfig.enableZombieGenJEIRecipes.get()).booleanValue()) {
            return;
        }
        MachinesPlugin.iModRegistry.addRecipeCategories(new IRecipeCategory[]{new ZombieGeneratorRecipeCategory(MachinesPlugin.iGuiHelper)});
        MachinesPlugin.iModRegistry.addRecipeCategoryCraftingItem(new ItemStack(MachineObject.block_zombie_generator.getBlockNN(), 1, 0), new String[]{UID});
        MachinesPlugin.iModRegistry.addRecipeCategoryCraftingItem(new ItemStack(MachineObject.block_franken_zombie_generator.getBlockNN(), 1, 0), new String[]{UID});
        MachinesPlugin.iModRegistry.addRecipeClickArea(GuiZombieGenerator.class, 155, 42, 16, 16, new String[]{UID});
        MachinesPlugin.iModRegistry.addRecipes(Collections.singletonList(new ZombieGeneratorRecipeWrapper()), UID);
    }

    public ZombieGeneratorRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation backgroundLocation = EnderIO.proxy.getGuiTexture("zombie_generator");
        this.background = guiHelper.createDrawable(backgroundLocation, xOff, yOff, xSize, 70);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return MachineObject.block_zombie_generator.getBlock().func_149732_F();
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull ZombieGeneratorRecipeWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        IGuiIngredientGroup group = recipeLayout.getIngredientsGroup(EnergyIngredient.class);
        guiFluidStacks.init(0, true, 80 - xOff, 21 - yOff, 16, 47, 2000, true, null);
        guiFluidStacks.addTooltipCallback((ITooltipCallback)new ITooltipCallback<FluidStack>(){

            public void onTooltip(int slotIndex, boolean input, @Nonnull FluidStack ingredient, @Nonnull List<String> tooltip) {
                if (slotIndex != 0) {
                    return;
                }
                tooltip.add(Lang.GUI_ZOMBGEN_MINREQ.get(new Object[]{LangFluid.MB((int)Math.round(((Float)ZombieGenConfig.minimumTankLevel.get()).floatValue() * 2000.0f))}));
            }
        });
        group.init(1, false, (IIngredientRenderer)EnergyIngredientRenderer.INSTANCE, 37 - xOff, 11 - yOff, 40, 10, 0, 0);
        group.init(2, false, (IIngredientRenderer)EnergyIngredientRenderer.INSTANCE, 101 - xOff, 11 - yOff, 40, 10, 0, 0);
        guiFluidStacks.set(ingredients);
        group.set(ingredients);
    }

    @Nonnull
    public String getModName() {
        return "enderiomachines";
    }

    public static class ZombieGeneratorRecipeWrapper
    extends BlankRecipeWrapper {
        public void getIngredients(@Nonnull IIngredients ingredients) {
            ingredients.setInput(FluidStack.class, (Object)new FluidStack(Fluids.NUTRIENT_DISTILLATION.getFluid(), Math.round(((Float)ZombieGenConfig.minimumTankLevel.get()).floatValue() * 2000.0f)));
            ingredients.setOutputs(EnergyIngredient.class, (List)new NNList((Object[])new EnergyIngredient[]{new EnergyIngredient(Math.round(CapacitorKey.ZOMBIE_POWER_GEN.getDefaultFloat()), true), new EnergyIngredient(Math.round(CapacitorKey.ZOMBIE_POWER_GEN.get((ICapacitorData)DefaultCapacitorData.ENDER_CAPACITOR)), true)}));
        }

        public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            FontRenderer fr = minecraft.field_71466_p;
            String txt = Lang.GUI_ZOMBGEN_OUTPUT.get(new Object[]{""});
            int sw = fr.func_78256_a(txt);
            fr.func_175063_a(txt, (float)(89 - sw / 2 - xOff), (float)(0 - yOff), ColorUtil.getRGB((Color)Color.WHITE));
            txt = "-";
            sw = fr.func_78256_a(txt);
            fr.func_175063_a("-", (float)(89 - sw / 2 - xOff), (float)(10 - yOff), ColorUtil.getRGB((Color)Color.WHITE));
            txt = LangFluid.tMB((int)((Integer)ZombieGenConfig.ticksPerBucketOfFuel.get() / 1000));
            sw = fr.func_78256_a(txt);
            fr.func_175063_a(txt, (float)(recipeWidth / 2 - sw / 2), (float)(61 + fr.field_78288_b / 2), ColorUtil.getRGB((Color)Color.WHITE));
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

