/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.integration.jei.sagmill;

import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.gui.tooltip.TooltipHandlerGrinding;
import crazypants.enderio.base.integration.jei.RecipeWrapperIRecipe;
import crazypants.enderio.base.integration.jei.energy.EnergyIngredient;
import crazypants.enderio.base.integration.jei.energy.EnergyIngredientRenderer;
import crazypants.enderio.base.recipe.IRecipe;
import crazypants.enderio.base.recipe.RecipeOutput;
import crazypants.enderio.base.recipe.sagmill.SagMillRecipeManager;
import crazypants.enderio.machines.init.MachineObject;
import crazypants.enderio.machines.integration.jei.MachinesPlugin;
import crazypants.enderio.machines.integration.jei.sagmill.SagMillRecipeTransferHandler;
import crazypants.enderio.machines.integration.jei.sagmill.SagRecipe;
import crazypants.enderio.machines.integration.jei.sagmill.SimpleSagMillRecipeTransferHandler;
import crazypants.enderio.machines.lang.Lang;
import crazypants.enderio.machines.machine.sagmill.ContainerSagMill;
import crazypants.enderio.machines.machine.sagmill.GuiSagMill;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class SagMillRecipeCategory
extends BlankRecipeCategory<SagRecipe> {
    @Nonnull
    public static final String UID = "SagMill";
    private static int xOff = 45;
    private static int yOff = 3;
    @Nonnull
    private final IDrawable background;
    @Nonnull
    protected final IDrawableAnimated arrow;
    private final TooltipHandlerGrinding ballsTT = new TooltipHandlerGrinding();

    public static void register() {
        RecipeWrapperIRecipe.setLevelData(SagRecipe.class, (IGuiHelper)MachinesPlugin.iGuiHelper, (int)(173 - xOff), (int)(yOff + 1), (String)"textures/blocks/block_simple_sagmill_front.png", (String)"textures/blocks/block_sagmill_front.png");
        MachinesPlugin.iModRegistry.addRecipeCategories(new IRecipeCategory[]{new SagMillRecipeCategory(MachinesPlugin.iGuiHelper)});
        MachinesPlugin.iModRegistry.handleRecipes(IRecipe.class, SagRecipe::new, UID);
        MachinesPlugin.iModRegistry.addRecipeClickArea(GuiSagMill.class, 155, 42, 16, 16, new String[]{UID});
        MachinesPlugin.iModRegistry.addRecipeCategoryCraftingItem(new ItemStack(MachineObject.block_sag_mill.getBlockNN()), new String[]{UID});
        MachinesPlugin.iModRegistry.addRecipeCategoryCraftingItem(new ItemStack(MachineObject.block_simple_sag_mill.getBlockNN()), new String[]{UID});
        MachinesPlugin.iModRegistry.addRecipeCategoryCraftingItem(new ItemStack(MachineObject.block_enhanced_sag_mill.getBlockNN()), new String[]{UID});
        MachinesPlugin.iModRegistry.addRecipes((Collection)SagMillRecipeManager.getInstance().getRecipes(), UID);
        MachinesPlugin.iModRegistry.getRecipeTransferRegistry().addRecipeTransferHandler((IRecipeTransferHandler)new SagMillRecipeTransferHandler(MachinesPlugin.iModRegistry, UID, ContainerSagMill.FIRST_RECIPE_SLOT, ContainerSagMill.NUM_RECIPE_SLOT, ContainerSagMill.FIRST_INVENTORY_SLOT, ContainerSagMill.NUM_INVENTORY_SLOT), UID);
        MachinesPlugin.iModRegistry.getRecipeTransferRegistry().addRecipeTransferHandler((IRecipeTransferHandler)new SimpleSagMillRecipeTransferHandler(MachinesPlugin.iModRegistry, UID, ContainerSagMill.FIRST_RECIPE_SLOT, ContainerSagMill.NUM_RECIPE_SLOT, ContainerSagMill.FIRST_INVENTORY_SLOT - 1, ContainerSagMill.NUM_INVENTORY_SLOT), UID);
    }

    public SagMillRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation backgroundLocation = EnderIO.proxy.getGuiTexture("crusher");
        this.background = MachinesPlugin.iGuiHelper.drawableBuilder(backgroundLocation, xOff - 1, yOff, 109, 78).addPadding(0, 0, 10, 30).build();
        IDrawableStatic flameDrawable = guiHelper.createDrawable(backgroundLocation, 201, 1, 16, 22);
        this.arrow = guiHelper.createAnimatedDrawable(flameDrawable, 200, IDrawableAnimated.StartDirection.TOP, false);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return MachineObject.block_sag_mill.getBlockNN().func_149732_F();
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.arrow.draw(minecraft, 91 - xOff, 32 - yOff);
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, final @Nonnull SagRecipe recipeWrapper, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IGuiIngredientGroup group = recipeLayout.getIngredientsGroup(EnergyIngredient.class);
        guiItemStacks.init(0, true, 90 - xOff, 11 - yOff);
        guiItemStacks.init(1, false, 59 - xOff, 58 - yOff);
        guiItemStacks.init(2, false, 80 - xOff, 58 - yOff);
        guiItemStacks.init(3, false, 101 - xOff, 58 - yOff);
        guiItemStacks.init(4, false, 122 - xOff, 58 - yOff);
        guiItemStacks.init(5, true, 132 - xOff, 22 - yOff);
        group.init(6, true, (IIngredientRenderer)EnergyIngredientRenderer.INSTANCE, 145 - xOff, 58 - yOff, 60, 10, 0, 0);
        guiItemStacks.addTooltipCallback((ITooltipCallback)new ITooltipCallback<ItemStack>(){

            public void onTooltip(int slotIndex, boolean input, @Nonnull ItemStack ingredient, @Nonnull List<String> tooltip) {
                switch (slotIndex) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        RecipeOutput output;
                        float chance;
                        if (slotIndex <= recipeWrapper.getRecipe().getOutputs().length && (chance = (output = recipeWrapper.getRecipe().getOutputs()[slotIndex - 1]).getChance()) > 0.0f && chance < 1.0f) {
                            int chanceInt = (int)(chance * 100.0f);
                            String line = TextFormatting.GRAY + MessageFormat.format(Lang.JEI_SAGMILL_CHANCE.get(), chanceInt);
                            if (recipeWrapper.getBonusType().doChances()) {
                                line = Lang.JEI_SAGMILL_CHANCE_BALL.get(new Object[]{line});
                            }
                            tooltip.add(line);
                        }
                        return;
                    }
                    case 5: {
                        if (SagMillRecipeCategory.this.ballsTT.shouldHandleItem(ingredient)) {
                            SagMillRecipeCategory.this.ballsTT.addEntries(ingredient, tooltip, recipeWrapper.getBonusType().doMultiply() ? null : Lang.JEI_SAGMILL_NO_MAINS.get());
                        }
                        return;
                    }
                }
            }
        });
        guiItemStacks.set(ingredients);
        group.set(ingredients);
    }

    @Nonnull
    public String getModName() {
        return "enderiomachines";
    }
}

