/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.alloy;

import com.enderio.core.common.util.Util;
import crazypants.enderio.base.machine.baselegacy.AbstractInventoryMachineEntity;
import crazypants.enderio.base.machine.gui.AbstractMachineContainer;
import crazypants.enderio.machines.machine.alloy.OperatingMode;
import crazypants.enderio.machines.machine.alloy.TileAlloySmelter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class ContainerAlloySmelter<T extends TileAlloySmelter>
extends AbstractMachineContainer<T> {
    public static int FIRST_RECIPE_SLOT = 0;
    public static int NUM_RECIPE_SLOT = 3;
    public static int FIRST_INVENTORY_SLOT = 5;
    public static int NUM_INVENTORY_SLOT = 36;
    @Nonnull
    private final EntityPlayer player;

    @Nonnull
    public static <E extends TileAlloySmelter> ContainerAlloySmelter<E> create(@Nonnull InventoryPlayer playerInv, @Nonnull E te) {
        if (te instanceof TileAlloySmelter.Simple) {
            return new Simple(playerInv, (TileAlloySmelter.Simple)te);
        }
        if (te instanceof TileAlloySmelter.Furnace) {
            return new Furnace(playerInv, (TileAlloySmelter.Furnace)te);
        }
        if (te instanceof TileAlloySmelter.Enhanced) {
            return new Enhanced(playerInv, (TileAlloySmelter.Enhanced)te);
        }
        return new Normal(playerInv, te);
    }

    private ContainerAlloySmelter(@Nonnull InventoryPlayer playerInv, @Nonnull T te) {
        super(playerInv, te);
        this.player = playerInv.field_70458_d;
    }

    protected void addMachineSlots(@Nonnull InventoryPlayer playerInv) {
        this.func_75146_a(new Slot(this.getInv(), 0, 54, 17){

            public boolean func_75214_a(@Nonnull ItemStack itemStack) {
                return ((AbstractInventoryMachineEntity.InventoryWrapper)ContainerAlloySmelter.this.getInv()).func_94041_b(0, itemStack);
            }
        });
        this.func_75146_a(new Slot(this.getInv(), 1, 79, 7){

            public boolean func_75214_a(@Nonnull ItemStack itemStack) {
                return ((AbstractInventoryMachineEntity.InventoryWrapper)ContainerAlloySmelter.this.getInv()).func_94041_b(1, itemStack);
            }
        });
        this.func_75146_a(new Slot(this.getInv(), 2, 103, 17){

            public boolean func_75214_a(@Nonnull ItemStack itemStack) {
                return ((AbstractInventoryMachineEntity.InventoryWrapper)ContainerAlloySmelter.this.getInv()).func_94041_b(2, itemStack);
            }
        });
        this.func_75146_a(new SlotSmelter(this.getInv(), 3, 79, 57));
    }

    public IMessage doSetMode(@Nonnull OperatingMode mode) {
        ((TileAlloySmelter)this.getTe()).setMode(mode);
        IBlockState bs = ((TileAlloySmelter)this.getTe()).func_145831_w().func_180495_p(((TileAlloySmelter)this.getTe()).func_174877_v());
        ((TileAlloySmelter)this.getTe()).func_145831_w().func_184138_a(((TileAlloySmelter)this.getTe()).func_174877_v(), bs, bs, 3);
        return null;
    }

    /* synthetic */ ContainerAlloySmelter(InventoryPlayer x0, TileAlloySmelter x1, 1 x2) {
        this(x0, x1);
    }

    private class SlotSmelter
    extends Slot {
        int numResults;

        public SlotSmelter(IInventory par1iInventory, int par2, int par3, int par4) {
            super(par1iInventory, par2, par3, par4);
            this.numResults = 0;
        }

        @Nonnull
        public ItemStack func_75209_a(int par1) {
            if (this.func_75216_d()) {
                this.numResults += Math.min(par1, this.func_75211_c().func_190916_E());
            }
            return super.func_75209_a(par1);
        }

        public boolean func_75214_a(@Nullable ItemStack par1ItemStack) {
            return false;
        }

        @Nonnull
        public ItemStack func_190901_a(@Nonnull EntityPlayer par1EntityPlayer, @Nonnull ItemStack output) {
            this.func_75208_c(output);
            return super.func_190901_a(par1EntityPlayer, output);
        }

        protected void func_75210_a(@Nonnull ItemStack par1ItemStack, int par2) {
            this.numResults += par2;
            this.func_75208_c(par1ItemStack);
        }

        protected void func_75208_c(@Nonnull ItemStack output) {
            output.func_77980_a(((ContainerAlloySmelter)ContainerAlloySmelter.this).player.field_70170_p, ContainerAlloySmelter.this.player, this.numResults);
            if (!((ContainerAlloySmelter)ContainerAlloySmelter.this).player.field_70170_p.field_72995_K) {
                ItemStack outputSized = output.func_77946_l();
                outputSized.func_190920_e(this.numResults);
                float experience = ((TileAlloySmelter)ContainerAlloySmelter.this.getTe()).getExperienceForOutput(outputSized);
                Util.giveExperience((EntityPlayer)ContainerAlloySmelter.this.player, (float)experience);
            }
            this.numResults = 0;
            FMLCommonHandler.instance().firePlayerSmeltedEvent(ContainerAlloySmelter.this.player, output);
        }
    }

    public static class Furnace
    extends ContainerAlloySmelter<TileAlloySmelter.Furnace> {
        public Furnace(@Nonnull InventoryPlayer playerInv, @Nonnull TileAlloySmelter.Furnace te) {
            super(playerInv, te, null);
        }
    }

    public static class Simple
    extends ContainerAlloySmelter<TileAlloySmelter.Simple> {
        public Simple(@Nonnull InventoryPlayer playerInv, @Nonnull TileAlloySmelter.Simple te) {
            super(playerInv, te, null);
        }
    }

    public static class Normal
    extends ContainerAlloySmelter<TileAlloySmelter> {
        public Normal(@Nonnull InventoryPlayer playerInv, @Nonnull TileAlloySmelter te) {
            super(playerInv, te, null);
        }
    }

    public static class Enhanced
    extends ContainerAlloySmelter<TileAlloySmelter.Enhanced> {
        public Enhanced(@Nonnull InventoryPlayer playerInv, @Nonnull TileAlloySmelter.Enhanced te) {
            super(playerInv, te, null);
        }
    }
}

