/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.generator.combustion;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.fluid.FluidWrapper;
import com.enderio.core.common.fluid.SmartTank;
import com.enderio.core.common.fluid.SmartTankFluidHandler;
import crazypants.enderio.api.capacitor.ICapacitorData;
import crazypants.enderio.api.capacitor.ICapacitorKey;
import crazypants.enderio.base.capacitor.CapacitorHelper;
import crazypants.enderio.base.fluid.FluidFuelRegister;
import crazypants.enderio.base.fluid.IFluidCoolant;
import crazypants.enderio.base.fluid.IFluidFuel;
import crazypants.enderio.base.fluid.SmartTankFluidMachineHandler;
import crazypants.enderio.base.machine.baselegacy.AbstractGeneratorEntity;
import crazypants.enderio.base.machine.baselegacy.SlotDefinition;
import crazypants.enderio.base.machine.interfaces.IIoConfigurable;
import crazypants.enderio.base.machine.modes.IoMode;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.power.PowerDistributor;
import crazypants.enderio.machines.capacitor.CapacitorKey;
import crazypants.enderio.machines.config.config.CombustionGenConfig;
import crazypants.enderio.machines.init.MachineObject;
import crazypants.enderio.machines.machine.generator.combustion.CombustionMath;
import crazypants.enderio.machines.machine.generator.combustion.CoolantTank;
import crazypants.enderio.machines.machine.generator.combustion.FuelTank;
import crazypants.enderio.machines.machine.generator.combustion.PacketCombustionTank;
import crazypants.enderio.machines.network.PacketHandler;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.autosave.util.NBTAction;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Storable
public class TileCombustionGenerator
extends AbstractGeneratorEntity
implements ITankAccess.IExtendedTankAccess,
IPaintable.IPaintableTileEntity {
    @Store
    @Nonnull
    private final SmartTank coolantTank = new CoolantTank(Math.round((float)((Integer)CombustionGenConfig.combGenTankSize.get()).intValue() * this.getEfficiencyMultiplier()));
    @Store
    @Nonnull
    private final SmartTank fuelTank = new FuelTank(Math.round((float)((Integer)CombustionGenConfig.combGenTankSize.get()).intValue() * this.getEfficiencyMultiplier()));
    private boolean tanksDirty;
    @Store(value={NBTAction.ITEM, NBTAction.SAVE})
    private int ticksRemaingFuel;
    @Store(value={NBTAction.ITEM, NBTAction.SAVE})
    private int ticksRemaingCoolant;
    @Store(value={NBTAction.CLIENT})
    private boolean active;
    private PowerDistributor powerDis;
    @Store(value={NBTAction.CLIENT})
    private int generated;
    private boolean inPause = false;
    private boolean generatedDirty = false;
    private static int IO_MB_TICK = 250;
    private IFluidFuel curFuel;
    private IFluidCoolant curCoolant;
    private SmartTankFluidHandler smartTankFluidHandler;

    public TileCombustionGenerator() {
        this(new SlotDefinition(0, 0, 1), CapacitorKey.COMBUSTION_POWER_SEND, CapacitorKey.COMBUSTION_POWER_BUFFER, CapacitorKey.COMBUSTION_POWER_GEN);
        this.setEnergyLoss(CapacitorKey.COMBUSTION_POWER_LOSS);
    }

    protected TileCombustionGenerator(@Nonnull SlotDefinition slotDefinition, @Nonnull ICapacitorKey maxEnergySent, @Nonnull ICapacitorKey maxEnergyStored, @Nonnull ICapacitorKey maxEnergyUsed) {
        super(slotDefinition, maxEnergySent, maxEnergyStored, maxEnergyUsed);
        this.coolantTank.setTileEntity((TileEntity)this);
        this.coolantTank.setCanDrain(false);
        this.fuelTank.setTileEntity((TileEntity)this);
        this.fuelTank.setCanDrain(false);
        this.addICap(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facingIn -> this.getSmartTankFluidHandler().get(facingIn));
    }

    protected boolean doPull(@Nullable EnumFacing dir) {
        if (super.doPull(dir)) {
            return true;
        }
        if (dir != null && this.fuelTank.getFluidAmount() < this.fuelTank.getCapacity() && FluidWrapper.transfer((IBlockAccess)this.field_145850_b, (BlockPos)this.func_174877_v().func_177972_a(dir), (EnumFacing)dir.func_176734_d(), (FluidTank)this.fuelTank, (int)IO_MB_TICK) > 0) {
            this.setTanksDirty();
            return true;
        }
        if (dir != null && this.coolantTank.getFluidAmount() < this.coolantTank.getCapacity() && FluidWrapper.transfer((IBlockAccess)this.field_145850_b, (BlockPos)this.func_174877_v().func_177972_a(dir), (EnumFacing)dir.func_176734_d(), (FluidTank)this.coolantTank, (int)IO_MB_TICK) > 0) {
            this.setTanksDirty();
            return true;
        }
        return false;
    }

    public boolean supportsMode(@Nullable EnumFacing faceHit, @Nullable IoMode mode) {
        return mode != IoMode.PUSH && mode != IoMode.PUSH_PULL;
    }

    @Nonnull
    public String getMachineName() {
        return MachineObject.block_combustion_generator.getUnlocalisedName();
    }

    public boolean isMachineItemValidForSlot(int i, @Nonnull ItemStack itemstack) {
        return false;
    }

    public boolean isActive() {
        return this.active;
    }

    public void onNeighborBlockChange(@Nonnull IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos posIn, @Nonnull Block blockIn, @Nonnull BlockPos fromPos) {
        super.onNeighborBlockChange(state, worldIn, posIn, blockIn, fromPos);
        if (this.powerDis != null) {
            this.powerDis.neighboursChanged();
        }
    }

    protected void processTasks(boolean redstoneChecksPassed) {
        if (!redstoneChecksPassed) {
            if (this.active) {
                this.active = false;
                this.updateClients = true;
            }
            return;
        }
        int lastGenerated = this.generated;
        boolean isActive = this.generateEnergy();
        if (isActive != this.active) {
            this.active = isActive;
            this.updateClients = true;
        }
        if (lastGenerated != this.generated) {
            this.generatedDirty = true;
        }
        if (this.getEnergyStored() >= this.getMaxEnergyStored()) {
            this.inPause = true;
        }
        this.transmitEnergy();
        if (this.tanksDirty && this.shouldDoWorkThisTick(10)) {
            PacketHandler.sendToAllAround((IMessage)new PacketCombustionTank(this), (TileEntity)this);
            this.tanksDirty = false;
        }
        if (this.generatedDirty && this.shouldDoWorkThisTick(10)) {
            this.generatedDirty = false;
            this.updateClients = true;
        }
    }

    private boolean transmitEnergy() {
        if (this.getEnergyStored() <= 0) {
            return false;
        }
        if (this.powerDis == null) {
            this.powerDis = new PowerDistributor(this.func_174877_v());
        }
        int transmitted = this.powerDis.transmitEnergy(this.field_145850_b, this.getMaxEnergySent());
        this.setEnergyStored(this.getEnergyStored() - transmitted);
        return transmitted > 0;
    }

    private boolean generateEnergy() {
        this.generated = 0;
        if (this.ticksRemaingCoolant <= 0 && this.getCoolantTank().isEmpty() || this.ticksRemaingFuel <= 0 && this.getFuelTank().isEmpty() || this.getEnergyStored() >= this.getMaxEnergyStored()) {
            return false;
        }
        CombustionMath math = this.getMath();
        if (this.inPause) {
            int powerPerCycle = math.getEnergyPerTick();
            if (this.getEnergyStored() >= this.getMaxEnergyStored() - powerPerCycle * 200 && this.getEnergyStored() > this.getMaxEnergyStored() / 8) {
                return false;
            }
        }
        this.inPause = false;
        if (this.ticksRemaingCoolant > 0 && this.ticksRemaingFuel > 0 && math.getEnergyPerTick() > 0) {
            --this.ticksRemaingFuel;
            --this.ticksRemaingCoolant;
            this.generated = math.getEnergyPerTick();
            this.setEnergyStored(this.getEnergyStored() + this.generated);
            return true;
        }
        if (this.ticksRemaingFuel <= 0) {
            this.curFuel = null;
        }
        if (this.ticksRemaingCoolant <= 0) {
            this.curCoolant = null;
        }
        if ((math = this.getMath()).getEnergyPerTick() <= 0) {
            return false;
        }
        if (this.ticksRemaingCoolant <= 0) {
            this.ticksRemaingCoolant += math.getTicksPerCoolant(this.getCoolantTank().removeFluidAmount(100));
        }
        if (this.ticksRemaingFuel <= 0) {
            this.ticksRemaingFuel += math.getTicksPerFuel(this.getFuelTank().removeFluidAmount(100));
        }
        if (this.ticksRemaingCoolant > 0 && this.ticksRemaingFuel > 0) {
            --this.ticksRemaingFuel;
            --this.ticksRemaingCoolant;
            this.generated = math.getEnergyPerTick();
            this.setEnergyStored(this.getEnergyStored() + this.generated);
            return true;
        }
        return false;
    }

    CombustionMath getMath() {
        if (this.curFuel == null) {
            this.curFuel = CombustionMath.toFuel(this.getFuelTank());
        }
        if (this.curCoolant == null) {
            this.curCoolant = CombustionMath.toCoolant(this.getCoolantTank());
        }
        return new CombustionMath(this.curCoolant, this.curFuel, this.maxEnergyUsed.getFloat(this.getCapacitorData()), this.getEfficiencyMultiplier());
    }

    public int getGeneratedLastTick() {
        if (!this.active) {
            return 0;
        }
        return this.generated;
    }

    public int getPowerUsePerTick() {
        return 0;
    }

    @Nonnull
    public SmartTank getCoolantTank() {
        return this.coolantTank;
    }

    @Nonnull
    public SmartTank getFuelTank() {
        return this.fuelTank;
    }

    public FluidTank getInputTank(FluidStack forFluidType) {
        if (forFluidType != null) {
            Fluid fluid = forFluidType.getFluid();
            if (fluid == null) {
                return null;
            }
            if (FluidFuelRegister.instance.getCoolant(fluid) != null) {
                return this.coolantTank;
            }
            if (FluidFuelRegister.instance.getFuel(fluid) != null) {
                return this.fuelTank;
            }
        }
        return null;
    }

    @Nonnull
    public FluidTank[] getOutputTanks() {
        return new FluidTank[0];
    }

    public void setTanksDirty() {
        this.tanksDirty = true;
    }

    @Nonnull
    public List<ITankAccess.ITankData> getTankDisplayData() {
        ArrayList<ITankAccess.ITankData> result = new ArrayList<ITankAccess.ITankData>();
        result.add(new ITankAccess.ITankData(){

            @Nonnull
            public ITankAccess.ITankData.EnumTankType getTankType() {
                return ITankAccess.ITankData.EnumTankType.INPUT;
            }

            @Nullable
            public FluidStack getContent() {
                return TileCombustionGenerator.this.fuelTank.getFluid();
            }

            public int getCapacity() {
                return TileCombustionGenerator.this.fuelTank.getCapacity();
            }
        });
        result.add(new ITankAccess.ITankData(){

            @Nonnull
            public ITankAccess.ITankData.EnumTankType getTankType() {
                return ITankAccess.ITankData.EnumTankType.INPUT;
            }

            @Nullable
            public FluidStack getContent() {
                return TileCombustionGenerator.this.coolantTank.getFluid();
            }

            public int getCapacity() {
                return TileCombustionGenerator.this.coolantTank.getCapacity();
            }
        });
        return result;
    }

    protected SmartTankFluidHandler getSmartTankFluidHandler() {
        if (this.smartTankFluidHandler == null) {
            this.smartTankFluidHandler = new SmartTankFluidMachineHandler((IIoConfigurable)this, new IFluidHandler[]{this.coolantTank, this.fuelTank});
        }
        return this.smartTankFluidHandler;
    }

    public static class Enhanced
    extends TileCombustionGenerator {
        public Enhanced() {
            super(new SlotDefinition(0, 0, 1), CapacitorKey.ENHANCED_COMBUSTION_POWER_SEND, CapacitorKey.ENHANCED_COMBUSTION_POWER_BUFFER, CapacitorKey.ENHANCED_COMBUSTION_POWER_GEN);
            this.setEnergyLoss(CapacitorKey.ENHANCED_COMBUSTION_POWER_LOSS);
            this.setEfficiencyMultiplier(CapacitorKey.ENHANCED_COMBUSTION_POWER_EFFICIENCY);
        }

        @Nonnull
        public ICapacitorData getCapacitorData() {
            return CapacitorHelper.increaseCapacitorLevel((ICapacitorData)super.getCapacitorData(), (float)1.0f);
        }

        @Override
        public boolean supportsMode(@Nullable EnumFacing faceHit, @Nullable IoMode mode) {
            return (faceHit != EnumFacing.UP || mode == IoMode.NONE) && super.supportsMode(faceHit, mode);
        }
    }
}

