/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.ihopper;

import com.enderio.core.common.inventory.EnderInventory;
import com.enderio.core.common.inventory.Filters;
import com.enderio.core.common.inventory.InventorySlot;
import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.NNList;
import com.google.common.base.Predicate;
import crazypants.enderio.api.capacitor.ICapacitorKey;
import crazypants.enderio.base.machine.base.te.AbstractCapabilityMachineEntity;
import crazypants.enderio.base.machine.modes.RedstoneControlMode;
import crazypants.enderio.machines.capacitor.CapacitorKey;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;

@Storable
public class TileImpulseHopper
extends AbstractCapabilityMachineEntity {
    public static final String OUTPUT_SLOT = "OUTPUT";
    public static final String INPUT_SLOT = "INPUT";
    public static final int SLOTS = 6;
    public static final double BASE_TICK_RATE = 20.0;
    @Store
    private boolean isOutputLocked = false;
    @Store
    @Nonnull
    private final NNList<ItemStack> items;

    public TileImpulseHopper() {
        super((ICapacitorKey)CapacitorKey.IMPULSE_HOPPER_POWER_INTAKE, (ICapacitorKey)CapacitorKey.IMPULSE_HOPPER_POWER_BUFFER, (ICapacitorKey)CapacitorKey.IMPULSE_HOPPER_POWER_USE);
        for (int i = 0; i < 6; ++i) {
            PredicateItemStackMatch predicate = new PredicateItemStackMatch(i);
            this.getInventory().add(EnderInventory.Type.INPUT, INPUT_SLOT + i, new InventorySlot((Predicate)predicate, Filters.ALWAYS_TRUE));
            this.getInventory().add(EnderInventory.Type.OUTPUT, OUTPUT_SLOT + i, new InventorySlot(Filters.ALWAYS_FALSE, Filters.ALWAYS_TRUE));
        }
        this.items = new NNList(6, (Object)ItemStack.field_190927_a);
        this.redstoneControlMode = RedstoneControlMode.IGNORE;
    }

    public void setGhostSlotContents(int slot, @Nonnull ItemStack stack, int realsize) {
        super.setGhostSlotContents(slot, stack, realsize);
        this.items.set(slot, (Object)stack);
        this.forceUpdatePlayers();
    }

    @Nonnull
    public NNList<ItemStack> getGhostSlotItems() {
        return this.items;
    }

    public boolean isActive() {
        return this.hasPower() && this.redstoneCheckPassed;
    }

    public boolean checkGhostSlot(int slot) {
        return !this.getGhostSlotContents(slot).func_190926_b();
    }

    public boolean checkInputSlot(int slot) {
        ItemStack ghostStack = this.getGhostSlotContents(slot);
        ItemStack inputStack = this.getInputSlotContents(slot);
        return !ghostStack.func_190926_b() && !inputStack.func_190926_b() && ItemUtil.areStacksEqual((ItemStack)ghostStack, (ItemStack)inputStack) && ghostStack.func_190916_E() <= inputStack.func_190916_E();
    }

    public boolean checkOutputSlot(int slot) {
        ItemStack ghostStack = this.getGhostSlotContents(slot);
        ItemStack outputStack = this.getOutputSlotContents(slot);
        return outputStack.func_190926_b() || !ghostStack.func_190926_b() && ItemUtil.areStackMergable((ItemStack)ghostStack, (ItemStack)outputStack) && outputStack.func_190916_E() + ghostStack.func_190916_E() <= outputStack.func_77976_d() && !this.isOutputLocked;
    }

    @Nonnull
    private ItemStack getGhostSlotContents(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    @Nonnull
    private ItemStack getInputSlotContents(int slot) {
        return this.getInventory().getSlot(INPUT_SLOT + slot).get();
    }

    @Nonnull
    private ItemStack getOutputSlotContents(int slot) {
        return this.getInventory().getSlot(OUTPUT_SLOT + slot).get();
    }

    public boolean isOutputLocked() {
        return this.isOutputLocked;
    }

    public void setOutputLocked(boolean isOutputLocked) {
        this.isOutputLocked = isOutputLocked;
    }

    protected void processTasks(boolean redstoneCheck) {
        if (this.shouldDoWorkThisTick() && redstoneCheck && this.getEnergy().useEnergy()) {
            int slot;
            int neededPower = 0;
            boolean doSomething = false;
            for (slot = 0; slot < 6; ++slot) {
                if (!this.checkGhostSlot(slot)) continue;
                if (this.checkInputSlot(slot) && this.checkOutputSlot(slot)) {
                    doSomething = true;
                    neededPower += this.getGhostSlotContents(slot).func_190916_E();
                    continue;
                }
                return;
            }
            if (!doSomething || this.getEnergy().getMaxUsage((ICapacitorKey)CapacitorKey.IMPULSE_HOPPER_POWER_USE_PER_ITEM) * neededPower > this.getEnergy().getEnergyStored()) {
                return;
            }
            for (slot = 0; slot < 6; ++slot) {
                ItemStack result;
                ItemStack ghostStack = this.getGhostSlotContents(slot);
                ItemStack inputStack = this.getInputSlotContents(slot);
                if (ghostStack.func_190926_b() || inputStack.func_190926_b()) continue;
                ItemStack outputStack = this.getOutputSlotContents(slot);
                if (!outputStack.func_190926_b()) {
                    result = outputStack.func_77946_l();
                    result.func_190917_f(ghostStack.func_190916_E());
                    this.getInventory().getSlot(OUTPUT_SLOT + slot).set(result);
                } else {
                    result = inputStack.func_77946_l();
                    result.func_190920_e(ghostStack.func_190916_E());
                    this.getInventory().getSlot(OUTPUT_SLOT + slot).set(result);
                }
                if (ghostStack.func_190916_E() < inputStack.func_190916_E()) {
                    ItemStack remainder = inputStack.func_77946_l();
                    remainder.func_190918_g(ghostStack.func_190916_E());
                    this.getInventory().getSlot(INPUT_SLOT + slot).set(remainder);
                    continue;
                }
                this.getInventory().getSlot(INPUT_SLOT + slot).set(ItemStack.field_190927_a);
            }
            this.getEnergy().useEnergy();
            for (int i = 0; i < neededPower; ++i) {
                this.getEnergy().useEnergy((ICapacitorKey)CapacitorKey.IMPULSE_HOPPER_POWER_USE_PER_ITEM);
            }
            super.processTasks(redstoneCheck);
        }
    }

    private boolean shouldDoWorkThisTick() {
        int impulseHopperSpeedScaled = CapacitorKey.IMPULSE_HOPPER_SPEED.get(this.getCapacitorData());
        if (impulseHopperSpeedScaled > 0) {
            return this.shouldDoWorkThisTick(MathHelper.func_76143_f((double)(20.0 / (double)impulseHopperSpeedScaled)));
        }
        return false;
    }

    private class PredicateItemStackMatch
    extends Filters.PredicateItemStack {
        private final int slot;

        PredicateItemStackMatch(int slot) {
            this.slot = slot;
        }

        public boolean doApply(@Nonnull ItemStack input) {
            return input.func_77969_a((ItemStack)TileImpulseHopper.this.items.get(this.slot));
        }
    }
}

