/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.light;

import com.enderio.core.common.BlockEnder;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.TileEntityEio;
import crazypants.enderio.machines.init.MachineObject;
import crazypants.enderio.machines.machine.light.BlockLightNode;
import crazypants.enderio.machines.machine.light.TileElectricLight;
import crazypants.enderio.util.FuncUtil;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.autosave.util.NBTAction;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;

@Storable
public class TileLightNode
extends TileEntityEio {
    @Store(value={NBTAction.SAVE})
    @Nonnull
    private NNList<BlockPos> parents = new NNList();

    public void onNeighbourChanged() {
        this.parents.apply(parent -> FuncUtil.doIf((Object)BlockEnder.getAnyTileEntitySafe((IBlockAccess)this.field_145850_b, (BlockPos)parent, TileElectricLight.class), light -> light.nodeNeighbourChanged(this)));
        this.checkSelf();
    }

    public void onBlockRemoved() {
        this.parents.apply(parent -> FuncUtil.doIf((Object)BlockEnder.getAnyTileEntitySafe((IBlockAccess)this.field_145850_b, (BlockPos)parent, TileElectricLight.class), light -> light.nodeRemoved(this)));
    }

    public String toString() {
        return "TileLightNode [parents=" + this.parents + ",  pos=" + this.field_174879_c + ", tileEntityInvalid=" + this.field_145846_f + "]";
    }

    public void addParent(@Nonnull BlockPos parent) {
        this.parents.add((Object)parent.func_185334_h());
    }

    public void removeParent(@Nonnull BlockPos parent) {
        this.parents.remove((Object)parent.func_185334_h());
        this.checkSelf();
    }

    protected void checkSelf() {
        if (!this.field_145850_b.field_72995_K) {
            NNList.NNIterator iterator = this.parents.iterator();
            while (iterator.hasNext()) {
                BlockPos parent = (BlockPos)iterator.next();
                if (!this.field_145850_b.func_175667_e(parent) || this.field_145850_b.func_180495_p(parent).func_177230_c() == MachineObject.block_electric_light.getBlock()) continue;
                iterator.remove();
            }
            if (this.parents.isEmpty()) {
                IBlockState lnbs = this.field_145850_b.func_180495_p(this.field_174879_c);
                if (lnbs.func_177230_c() == MachineObject.block_light_node.getBlockNN()) {
                    this.field_145850_b.func_175698_g(this.field_174879_c);
                } else if (this.field_145850_b.func_175625_s(this.field_174879_c) == this) {
                    this.field_145850_b.func_175713_t(this.field_174879_c);
                }
            }
        }
    }

    public boolean isParent(@Nonnull BlockPos parent) {
        return this.parents.contains((Object)parent.func_185334_h());
    }

    public void calculateLight() {
        if (!this.field_145850_b.field_72995_K) {
            boolean isPowered = false;
            NNList.NNIterator iterator = this.parents.iterator();
            while (!isPowered && iterator.hasNext()) {
                BlockPos parent = (BlockPos)iterator.next();
                TileElectricLight light = (TileElectricLight)((Object)BlockEnder.getAnyTileEntitySafe((IBlockAccess)this.field_145850_b, (BlockPos)parent, TileElectricLight.class));
                if (light == null) continue;
                isPowered = light.providesPoweredLight();
            }
            IBlockState lnbs = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (lnbs.func_177230_c() != MachineObject.block_light_node.getBlockNN()) {
                if (lnbs.func_177230_c() == Blocks.field_150350_a) {
                    lnbs = MachineObject.block_light_node.getBlockNN().func_176223_P();
                } else {
                    if (this.field_145850_b.func_175625_s(this.field_174879_c) == this) {
                        this.field_145850_b.func_175713_t(this.field_174879_c);
                    }
                    return;
                }
            }
            IBlockState lnbsnew = lnbs.func_177226_a((IProperty)BlockLightNode.ACTIVE, (Comparable)Boolean.valueOf(isPowered));
            this.field_145850_b.func_180501_a(this.field_174879_c, lnbsnew, 2);
            this.field_145850_b.func_184138_a(this.field_174879_c, lnbs, lnbsnew, 3);
            this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.field_174879_c);
        }
    }
}

