/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.niard;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.xp.XpUtil;
import crazypants.enderio.machines.config.config.NiardConfig;
import crazypants.enderio.machines.machine.niard.FluidType;
import crazypants.enderio.machines.machine.niard.PacketSFXFluidFizzle;
import crazypants.enderio.machines.machine.niard.RadiusIterator;
import crazypants.enderio.machines.machine.niard.TileNiard;
import crazypants.enderio.machines.network.PacketHandler;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.BlockFluidFinite;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.wrappers.BlockLiquidWrapper;
import net.minecraftforge.fluids.capability.wrappers.BlockWrapper;
import net.minecraftforge.fluids.capability.wrappers.FluidBlockWrapper;

public class EngineNiard {
    @Nonnull
    private final TileNiard owner;
    private Fluid fluid = null;
    @Nonnull
    private Block block = Blocks.field_150355_j;
    @Nonnull
    private FluidType type = FluidType.VANILLA;
    @Nonnull
    private EnumFacing downflowDirection = EnumFacing.DOWN;
    private int radius = -1;
    private RadiusIterator radiusItr = new RadiusIterator(BlockPos.field_177992_a, 0);

    public EngineNiard(@Nonnull TileNiard owner) {
        this.owner = owner;
    }

    public EngineNiard setFluid(Fluid fluid) {
        if (fluid != this.fluid) {
            if (fluid.canBePlacedInWorld()) {
                this.fluid = fluid;
                this.downflowDirection = fluid.getDensity() > 0 ? EnumFacing.DOWN : EnumFacing.UP;
                Block fluidBlock = fluid.getBlock();
                if (fluidBlock instanceof BlockFluidClassic) {
                    this.type = FluidType.CLASSIC;
                    this.block = fluidBlock;
                } else if (fluidBlock instanceof BlockFluidFinite) {
                    this.type = FluidType.FINITE;
                    this.block = fluidBlock;
                } else if (fluidBlock instanceof BlockLiquid) {
                    this.type = FluidType.VANILLA;
                    this.block = fluidBlock;
                } else {
                    this.fluid = null;
                }
            } else {
                this.fluid = null;
            }
        }
        return this;
    }

    public boolean work() {
        if (this.fluid == null) {
            return false;
        }
        if (this.radius != this.owner.getRange()) {
            this.radius = this.owner.getRange();
            this.radiusItr = new RadiusIterator(this.owner.getLocation(), this.radius);
        }
        for (int i = 0; i < this.radiusItr.size(); ++i) {
            NNList seen = new NNList();
            BlockPos base = this.radiusItr.next();
            BlockPos next = base.func_177972_a(this.downflowDirection);
            while (this.isInWorld(next) && (this.isSameLiquid(next) ? this.isFlowingBlock(next) : this.canPlace(next))) {
                seen.add(0, (Object)next);
                next = next.func_177972_a(this.downflowDirection);
            }
            if (seen.isEmpty()) continue;
            this.setSourceBlock((BlockPos)seen.remove(0));
            seen.apply(bc -> this.setVerticalBlock((BlockPos)bc, false));
            this.owner.func_145831_w().func_180495_p(base.func_177972_a(this.downflowDirection)).func_189546_a(this.owner.func_145831_w(), base.func_177972_a(this.downflowDirection), this.owner.func_145831_w().func_180495_p(this.owner.getLocation()).func_177230_c(), this.owner.getLocation());
            return true;
        }
        return false;
    }

    private boolean canPlace(@Nonnull BlockPos pos) {
        World world = this.owner.func_145831_w();
        IBlockState destBlockState = world.func_180495_p(pos);
        Material destMaterial = destBlockState.func_185904_a();
        boolean isDestNonSolid = !destMaterial.func_76220_a();
        boolean isLiquid = destMaterial.func_76224_d();
        boolean isDestReplaceable = destBlockState.func_177230_c().func_176200_f((IBlockAccess)world, pos);
        return world.func_175623_d(pos) || !isLiquid && (isDestNonSolid || isDestReplaceable);
    }

    public int work(int xp_in_mb) {
        int remaining = XpUtil.liquidToExperience((int)xp_in_mb);
        if (this.radius != this.owner.getRange()) {
            this.radius = this.owner.getRange();
            this.radiusItr = new RadiusIterator(this.owner.getLocation(), this.radius);
        }
        if (this.radius >= 0) {
            for (int i = 0; i < this.radiusItr.size(); ++i) {
                BlockPos next = this.radiusItr.next().func_177972_a(EnumFacing.DOWN);
                if (!this.isInWorld(next) || !this.canPlace(next)) continue;
                int i1 = EntityXPOrb.func_70527_a((int)(remaining / (this.owner.func_145831_w().field_73012_v.nextInt(4) + 1)));
                remaining -= i1;
                EntityXPOrb xpOrb = new EntityXPOrb(this.owner.func_145831_w(), (double)next.func_177958_n() + 0.5, (double)next.func_177956_o() + 0.7, (double)next.func_177952_p() + 0.5, i1);
                xpOrb.field_70159_w /= 4.0;
                xpOrb.field_70181_x = 0.0;
                xpOrb.field_70179_y /= 4.0;
                this.owner.func_145831_w().func_72838_d((Entity)xpOrb);
                if (remaining > 0) continue;
                return 0;
            }
        }
        return XpUtil.experienceToLiquid((int)remaining);
    }

    private boolean isInWorld(@Nonnull BlockPos bc) {
        return bc.func_177956_o() >= 0 && bc.func_177956_o() < 256 && this.owner.func_145831_w().func_175667_e(bc);
    }

    private boolean isSameLiquid(@Nonnull BlockPos bc) {
        Block wblock = this.owner.func_145831_w().func_180495_p(bc).func_177230_c();
        return wblock == this.block || this.block == Blocks.field_150355_j && wblock == Blocks.field_150358_i || this.block == Blocks.field_150353_l && wblock == Blocks.field_150356_k;
    }

    private boolean isFlowingBlock(@Nonnull BlockPos bc) {
        switch (this.type) {
            case CLASSIC: {
                return !((BlockFluidClassic)this.block).isSourceBlock((IBlockAccess)this.owner.func_145831_w(), bc);
            }
            case FINITE: {
                return false;
            }
            case VANILLA: {
                return (Integer)this.owner.func_145831_w().func_180495_p(bc).func_177229_b((IProperty)BlockLiquid.field_176367_b) != 0;
            }
        }
        throw new IllegalStateException("unreachable code");
    }

    private void setSourceBlock(@Nonnull BlockPos bc) {
        World world = this.owner.func_145831_w();
        FluidStack stack = new FluidStack(this.fluid, 1000);
        if (world.field_73011_w.func_177500_n() && this.fluid.doesVaporize(stack) && !((Boolean)NiardConfig.allowWaterInHell.get()).booleanValue()) {
            PacketHandler.sendToAllAround(new PacketSFXFluidFizzle(stack, bc), (TileEntity)this.owner);
            this.setVerticalBlock(bc, false);
            return;
        }
        FluidUtil.destroyBlockOnFluidPlacement((World)world, (BlockPos)bc);
        if (!world.func_175623_d(bc)) {
            IBlockState iblockstate = world.func_180495_p(bc);
            iblockstate.func_177230_c().func_176226_b(world, bc, iblockstate, 0);
            world.func_180501_a(bc, Blocks.field_150350_a.func_176223_P(), 3);
        }
        this.getFluidBlockHandler(bc).fill(stack, true);
    }

    private void setVerticalBlock(@Nonnull BlockPos bc, boolean blockUpdate) {
        IBlockState metaToSet;
        switch (this.type) {
            case CLASSIC: {
                metaToSet = this.block.func_176223_P().func_177226_a((IProperty)NullHelper.notnullF((Object)BlockFluidClassic.LEVEL, (String)"BlockFluidClassic.LEVEL"), (Comparable)Integer.valueOf(1));
                break;
            }
            case FINITE: {
                return;
            }
            case VANILLA: {
                metaToSet = this.block.func_176223_P().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(8));
                break;
            }
            default: {
                return;
            }
        }
        this.owner.func_145831_w().func_180501_a(bc, metaToSet, blockUpdate ? 3 : 2);
    }

    IFluidHandler getFluidBlockHandler(BlockPos pos) {
        if (this.block instanceof IFluidBlock) {
            return new FluidBlockWrapper((IFluidBlock)this.block, this.owner.func_145831_w(), pos);
        }
        if (this.block instanceof BlockLiquid) {
            return new BlockLiquidWrapper((BlockLiquid)this.block, this.owner.func_145831_w(), pos);
        }
        return new BlockWrapper(this.block, this.owner.func_145831_w(), pos);
    }
}

