/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.niard;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.common.fluid.FluidWrapper;
import com.enderio.core.common.fluid.SmartTank;
import com.enderio.core.common.fluid.SmartTankFluidHandler;
import com.enderio.core.common.inventory.EnderInventory;
import com.enderio.core.common.inventory.InventorySlot;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.FluidUtil;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.api.capacitor.ICapacitorKey;
import crazypants.enderio.base.fluid.Fluids;
import crazypants.enderio.base.fluid.SmartTankFluidMachineHandler;
import crazypants.enderio.base.machine.base.te.AbstractCapabilityMachineEntity;
import crazypants.enderio.base.machine.interfaces.IIoConfigurable;
import crazypants.enderio.base.render.ranged.IRanged;
import crazypants.enderio.base.render.ranged.RangeParticle;
import crazypants.enderio.machines.capacitor.CapacitorKey;
import crazypants.enderio.machines.machine.niard.EngineNiard;
import crazypants.enderio.machines.machine.niard.FluidColorUtil;
import crazypants.enderio.machines.machine.niard.PacketNiardTank;
import crazypants.enderio.machines.network.PacketHandler;
import crazypants.enderio.util.Prep;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Storable
public class TileNiard
extends AbstractCapabilityMachineEntity
implements ITankAccess.IExtendedTankAccess,
IRanged {
    private static final int ONE_BLOCK_OF_LIQUID = 1000;
    private static int IO_MB_TICK = 100;
    @Store
    @Nonnull
    protected final SmartTank inputTank = new SmartTank(2000);
    @Nonnull
    protected final SmartTankFluidHandler smartTankFluidHandler = new SmartTankFluidMachineHandler((IIoConfigurable)this, new IFluidHandler[]{this.inputTank});
    @Nonnull
    protected final EngineNiard engine = new EngineNiard(this);
    protected int sleep = 20;
    protected boolean tanksDirty = false;
    private boolean showingRange;
    @Nonnull
    protected static final Vector4f fallbackColor = new Vector4f(0.5686275f, 0.32156864f, 0.08235294f, 0.4f);

    public TileNiard() {
        super((ICapacitorKey)CapacitorKey.NIARD_POWER_INTAKE, (ICapacitorKey)CapacitorKey.NIARD_POWER_BUFFER, (ICapacitorKey)CapacitorKey.NIARD_POWER_USE);
        this.inputTank.setTileEntity((TileEntity)this);
        this.inputTank.setCanDrain(false);
        this.addICap(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, arg_0 -> ((SmartTankFluidHandler)this.smartTankFluidHandler).get(arg_0));
        this.getInventory().add(EnderInventory.Type.INPUT, (Enum)SLOT.INPUT, new InventorySlot(item -> item != null && FluidUtil.getFluidTypeFromItem((ItemStack)item) != null, -1));
        this.getInventory().add(EnderInventory.Type.OUTPUT, (Enum)SLOT.OUTPUT, new InventorySlot());
    }

    public boolean isActive() {
        return false;
    }

    protected void processTasks(boolean redstoneCheck) {
        if (this.getEnergy().hasCapacitor() && this.canTick(redstoneCheck)) {
            this.doTick();
        }
        if (this.tanksDirty && this.shouldDoWorkThisTick(5)) {
            PacketHandler.sendToAllAround((IMessage)new PacketNiardTank(this), (TileEntity)this);
            this.tanksDirty = false;
        }
        super.processTasks(redstoneCheck);
    }

    protected boolean canTick(boolean redstoneChecksPassed) {
        if (redstoneChecksPassed) {
            if (!this.inputTank.isFull() && !this.isOutputQueued() && !this.getInventory().getSlot((Enum)SLOT.INPUT).isEmpty() && this.shouldDoWorkThisTick(20)) {
                this.drainFullContainer();
            }
            if (this.sleep > 0) {
                --this.sleep;
            }
            return this.getEnergy().useEnergy() && this.sleep == 0 && !this.inputTank.isEmpty() && this.getEnergy().canUseEnergy((ICapacitorKey)CapacitorKey.NIARD_POWER_WORK);
        }
        return false;
    }

    protected void doTick() {
        if (this.shouldDoWorkThisTick(CapacitorKey.NIARD_DELAY.get(this.getCapacitorData()))) {
            if (this.inputTank.getFluidNN().getFluid() == Fluids.XP_JUICE.getFluid()) {
                this.doWorkXP();
            } else if (this.inputTank.getFluidAmount() >= 1000 && this.engine.setFluid(this.inputTank.getFluidNN().getFluid()).work()) {
                this.inputTank.setFluidAmount(this.inputTank.getFluidAmount() - 1000);
                this.getEnergy().useEnergy((ICapacitorKey)CapacitorKey.NIARD_POWER_WORK);
            } else {
                this.sleep = 200;
            }
        }
    }

    protected int getRange() {
        return CapacitorKey.NIARD_RANGE.get(this.getCapacitorData());
    }

    protected void doWorkXP() {
        int amount = this.inputTank.getFluidAmount();
        boolean looping = true;
        while (looping) {
            int remaining = this.engine.work(amount);
            if (remaining == amount || remaining == 0) {
                looping = false;
            }
            amount = remaining;
        }
        if (amount != this.inputTank.getFluidAmount()) {
            this.inputTank.setFluidAmount(amount);
            for (int usedFluid = this.inputTank.getFluidAmount() - amount; usedFluid > 0; usedFluid -= 1000) {
                this.getEnergy().useEnergy((ICapacitorKey)CapacitorKey.NIARD_POWER_WORK);
            }
        } else {
            this.sleep = 200;
        }
    }

    protected boolean drainFullContainer() {
        FluidUtil.FluidAndStackResult fill = FluidUtil.tryDrainContainer((ItemStack)this.getInventory().getSlot((Enum)SLOT.INPUT).get(), (ITankAccess)this);
        if (fill.result.fluidStack == null) {
            return false;
        }
        this.getInputTank().setFluid(fill.remainder.fluidStack);
        this.getInventory().getSlot((Enum)SLOT.INPUT).set(fill.remainder.itemStack);
        if (Prep.isValid((ItemStack)fill.result.itemStack)) {
            this.addToOutputQueue(fill.result.itemStack);
        }
        this.setTanksDirty();
        this.func_70296_d();
        return false;
    }

    protected boolean doPull(@Nullable EnumFacing dir) {
        if (super.doPull(dir)) {
            return true;
        }
        if (dir != null && !this.inputTank.isFull() && FluidWrapper.transfer((IBlockAccess)this.field_145850_b, (BlockPos)this.func_174877_v().func_177972_a(dir), (EnumFacing)dir.func_176734_d(), (FluidTank)this.inputTank, (int)IO_MB_TICK) > 0) {
            this.setTanksDirty();
            return true;
        }
        return false;
    }

    @Nonnull
    protected SmartTank getInputTank() {
        return this.inputTank;
    }

    @Nullable
    public FluidTank getInputTank(FluidStack forFluidType) {
        return !this.inputTank.isFull() && this.isValidFluid(forFluidType) ? this.inputTank : null;
    }

    @Nonnull
    public FluidTank[] getOutputTanks() {
        return new FluidTank[0];
    }

    public void setTanksDirty() {
        this.tanksDirty = true;
    }

    @Nonnull
    public List<ITankAccess.ITankData> getTankDisplayData() {
        return Collections.singletonList(new ITankAccess.ITankData(){

            @Nonnull
            public ITankAccess.ITankData.EnumTankType getTankType() {
                return ITankAccess.ITankData.EnumTankType.INPUT;
            }

            @Nullable
            public FluidStack getContent() {
                return TileNiard.this.inputTank.getFluid();
            }

            public int getCapacity() {
                return TileNiard.this.inputTank.getCapacity();
            }
        });
    }

    protected int getFilledLevel() {
        int level = (int)Math.floor(16.0f * this.inputTank.getFilledRatio());
        if (level == 0 && this.inputTank.getFluidAmount() > 0) {
            level = 1;
        }
        return level;
    }

    public int getComparatorOutput() {
        return this.getFilledLevel();
    }

    protected boolean isValidFluid(Fluid fluid) {
        return fluid != null && (fluid.canBePlacedInWorld() || fluid == Fluids.XP_JUICE.getFluid());
    }

    protected boolean isValidFluid(FluidStack fluid) {
        return fluid != null && this.isValidFluid(fluid.getFluid());
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isShowingRange() {
        return this.showingRange;
    }

    @SideOnly(value=Side.CLIENT)
    public void setShowRange(boolean showRange) {
        if (this.showingRange == showRange) {
            return;
        }
        this.showingRange = showRange;
        if (this.showingRange) {
            Vector4f color4f = fallbackColor;
            FluidStack fluid = this.inputTank.getFluid();
            if (fluid != null) {
                int color = fluid.getFluid().getColor(fluid);
                if (color != -1) {
                    float r = (float)(color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(color >> 8 & 0xFF) / 255.0f;
                    float b = (float)(color & 0xFF) / 255.0f;
                    float a = (float)(color >> 24 & 0xFF) / 255.0f;
                    color4f = new Vector4f(r, g, b, a * 0.4f);
                } else {
                    color4f = FluidColorUtil.getFluidColor(fluid, color4f);
                }
            }
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new RangeParticle((TileEntity)this, color4f));
        }
    }

    @Nonnull
    public BoundingBox getBounds() {
        FluidStack fluid = this.inputTank.getFluid();
        if (fluid != null && fluid.getFluid().getDensity() <= 0) {
            return new BoundingBox(this.field_174879_c.func_177968_d().func_177974_f().func_177984_a(), BlockCoord.withY((BlockPos)this.field_174879_c, (int)256)).expand((double)this.getRange(), 0.0, (double)this.getRange());
        }
        return new BoundingBox(this.field_174879_c.func_177968_d().func_177974_f(), BlockCoord.withY((BlockPos)this.field_174879_c, (int)0)).expand((double)this.getRange(), 0.0, (double)this.getRange());
    }

    static enum SLOT {
        INPUT,
        OUTPUT;

    }
}

