/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.obelisk.inhibitor;

import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.api.teleport.TeleportEntityEvent;
import crazypants.enderio.machines.machine.obelisk.inhibitor.TileInhibitorObelisk;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="enderiomachines")
public class InhibitorHandler {
    @Nonnull
    private static final Map<World, Map<BlockPos, WeakReference<TileInhibitorObelisk>>> HANDLERS = new WeakHashMap<World, Map<BlockPos, WeakReference<TileInhibitorObelisk>>>();

    public static void register(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull TileInhibitorObelisk teleportInhibitor) {
        if (!world.field_72995_K) {
            HANDLERS.computeIfAbsent(world, w -> new HashMap()).put(pos.func_185334_h(), new WeakReference<TileInhibitorObelisk>(teleportInhibitor));
        }
    }

    public static boolean isInhibited(@Nonnull World world, @Nonnull BlockPos pos1, @Nonnull BlockPos pos2) {
        if (!world.field_72995_K) {
            Iterator itr = HANDLERS.computeIfAbsent(world, w -> new HashMap()).entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry next = itr.next();
                BlockPos blockPos = (BlockPos)next.getKey();
                TileInhibitorObelisk inhibitor = (TileInhibitorObelisk)((Object)((WeakReference)next.getValue()).get());
                if (blockPos == null || !world.func_175667_e(blockPos) || inhibitor == null || !inhibitor.func_145830_o() || inhibitor.func_145837_r() || world.func_175625_s(blockPos) != inhibitor) {
                    itr.remove();
                    continue;
                }
                if (!inhibitor.isActive() || !inhibitor.getBounds().contains(pos1) && !inhibitor.getBounds().contains(pos2)) continue;
                return true;
            }
        }
        return false;
    }

    @SubscribeEvent
    public static void onTeleport(TeleportEntityEvent event) {
        if (InhibitorHandler.isInhibited(event.getEntity().field_70170_p, BlockCoord.get((Entity)event.getEntity()), event.getTarget())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEnderTeleport(EnderTeleportEvent event) {
        if (InhibitorHandler.isInhibited(event.getEntity().field_70170_p, BlockCoord.get((Entity)event.getEntity()), new BlockPos(event.getTargetX(), event.getTargetY(), event.getTargetZ()))) {
            event.setCanceled(true);
        }
    }
}

