/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.slicensplice;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.api.capacitor.ICapacitorKey;
import crazypants.enderio.base.farming.FarmingTool;
import crazypants.enderio.base.machine.baselegacy.AbstractPoweredTaskEntity;
import crazypants.enderio.base.machine.baselegacy.SlotDefinition;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.recipe.IMachineRecipe;
import crazypants.enderio.base.recipe.IManyToOneRecipe;
import crazypants.enderio.base.recipe.IRecipeInput;
import crazypants.enderio.base.recipe.MachineRecipeInput;
import crazypants.enderio.base.recipe.MachineRecipeRegistry;
import crazypants.enderio.base.recipe.ManyToOneMachineRecipe;
import crazypants.enderio.machines.capacitor.CapacitorKey;
import crazypants.enderio.machines.config.config.SliceAndSpliceConfig;
import crazypants.enderio.util.Prep;
import info.loenwind.autosave.annotations.Storable;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.common.FMLCommonHandler;

@Storable
public class TileSliceAndSplice
extends AbstractPoweredTaskEntity
implements IPaintable.IPaintableTileEntity {
    protected static final int axeIndex = 6;
    protected static final int shearsIndex = 7;
    private EntityLivingBase fakePlayer;
    @Nonnull
    private static final ResourceLocation SOUND = new ResourceLocation("enderio", "machine.slicensplice");

    public TileSliceAndSplice() {
        super(new SlotDefinition(8, 1, 1), (ICapacitorKey)CapacitorKey.SLICE_POWER_INTAKE, (ICapacitorKey)CapacitorKey.SLICE_POWER_BUFFER, (ICapacitorKey)CapacitorKey.SLICE_POWER_USE);
    }

    @Nonnull
    public String getMachineName() {
        return "slicensplice";
    }

    public ResourceLocation getSound() {
        return SOUND;
    }

    public int getInventoryStackLimit() {
        return 1;
    }

    public int getInventoryStackLimit(int slot) {
        return slot == this.getSlotDefinition().getMinOutputSlot() ? 64 : 1;
    }

    protected IMachineRecipe canStartNextTask(long nextSeed) {
        if (!this.hasTools()) {
            return null;
        }
        return super.canStartNextTask(nextSeed);
    }

    @Nonnull
    private ItemStack getAxe() {
        return this.getStackInSlot(6);
    }

    @Nonnull
    private ItemStack getShears() {
        return this.getStackInSlot(7);
    }

    protected void checkProgress(boolean redstoneChecksPassed) {
        if (this.hasTools()) {
            super.checkProgress(redstoneChecksPassed);
        }
    }

    private boolean hasTools() {
        return Prep.isValid((ItemStack)this.getAxe()) && Prep.isValid((ItemStack)this.getShears());
    }

    protected void taskComplete() {
        super.taskComplete();
        this.damageTool(this.getAxe(), 6);
        this.damageTool(this.getShears(), 7);
    }

    protected int usePower(int wantToUse) {
        if (wantToUse > 0) {
            if (this.random.nextFloat() < ((Float)SliceAndSpliceConfig.toolDamageChance.get()).floatValue()) {
                this.damageTool(this.getAxe(), 6);
            }
            if (this.random.nextFloat() < ((Float)SliceAndSpliceConfig.toolDamageChance.get()).floatValue()) {
                this.damageTool(this.getShears(), 7);
            }
        }
        return super.usePower(wantToUse);
    }

    private void damageTool(@Nonnull ItemStack tool, int toolIndex) {
        if (Prep.isValid((ItemStack)tool) && tool.func_77984_f()) {
            tool.func_77972_a(1, this.getFakePlayer());
            if (tool.func_77952_i() >= tool.func_77958_k()) {
                tool.func_190918_g(1);
            }
            this.func_70296_d();
        }
    }

    @Nonnull
    private EntityLivingBase getFakePlayer() {
        if (this.fakePlayer == null) {
            this.fakePlayer = FakePlayerFactory.getMinecraft((WorldServer)FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(this.field_145850_b.field_73011_w.getDimension()));
        }
        return this.fakePlayer;
    }

    @Nonnull
    protected NNList<MachineRecipeInput> getRecipeInputs() {
        NNList res = new NNList();
        for (int slot = this.slotDefinition.minInputSlot; slot <= this.slotDefinition.maxInputSlot - 2; ++slot) {
            ItemStack item = this.getStackInSlot(slot);
            if (!Prep.isValid((ItemStack)item)) continue;
            res.add((Object)new MachineRecipeInput(slot, item));
        }
        return res;
    }

    public boolean isMachineItemValidForSlot(int slot, @Nonnull ItemStack itemstack) {
        if (Prep.isInvalid((ItemStack)itemstack)) {
            return false;
        }
        if (!this.slotDefinition.isInputSlot(slot)) {
            return false;
        }
        if (slot == 6) {
            return FarmingTool.AXE.itemMatches(itemstack);
        }
        if (slot == 7) {
            return FarmingTool.SHEARS.itemMatches(itemstack);
        }
        ItemStack currentStackInSlot = this.getStackInSlot(slot);
        if (Prep.isValid((ItemStack)currentStackInSlot)) {
            return currentStackInSlot.func_77969_a(itemstack);
        }
        int numSlotsFilled = 0;
        for (int i = this.slotDefinition.getMinInputSlot(); i <= this.slotDefinition.getMaxInputSlot(); ++i) {
            if (i < 0 || i >= this.inventory.length || i == 6 || i == 7 || !Prep.isValid((ItemStack)this.getStackInSlot(i))) continue;
            ++numSlotsFilled;
        }
        NNList recipes = MachineRecipeRegistry.instance.getRecipesForInput(this.getMachineLevel(), this.getMachineName(), MachineRecipeInput.create((int)slot, (ItemStack)itemstack));
        return this.isValidInputForAlloyRecipe(slot, itemstack, numSlotsFilled, (List<IMachineRecipe>)recipes);
    }

    private boolean isValidInputForAlloyRecipe(int slot, ItemStack itemstack, int numSlotsFilled, List<IMachineRecipe> recipes) {
        ItemStack[] resultInv = new ItemStack[this.slotDefinition.getNumInputSlots()];
        for (int i = this.slotDefinition.getMinInputSlot(); i <= this.slotDefinition.getMaxInputSlot(); ++i) {
            if (i < 0 || i >= this.inventory.length || i == 6 || i == 7) continue;
            resultInv[i] = i == slot ? itemstack : this.inventory[i];
        }
        for (IMachineRecipe recipe : recipes) {
            if (!(recipe instanceof ManyToOneMachineRecipe)) continue;
            for (IManyToOneRecipe oneRecipe : ((ManyToOneMachineRecipe)recipe).getRecipesThatHaveTheseAsValidRecipeComponents(resultInv)) {
                boolean valid = true;
                block3: for (int i = 0; valid && i < resultInv.length; ++i) {
                    ItemStack resultInvI = resultInv[i];
                    if (resultInvI == null || resultInvI.func_190926_b()) continue;
                    for (IRecipeInput ri : oneRecipe.getInputs()) {
                        if (ri.getSlotNumber() != i) continue;
                        if (ri.isInput(resultInvI)) continue block3;
                        valid = false;
                        continue block3;
                    }
                }
                if (!valid) continue;
                return true;
            }
        }
        return false;
    }
}

