/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.solar;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.TileEntityEio;
import crazypants.enderio.base.fluid.BlockFluidEio;
import crazypants.enderio.base.fluid.Fluids;
import crazypants.enderio.base.item.conduitprobe.PacketConduitProbe;
import crazypants.enderio.base.power.IPowerInterface;
import crazypants.enderio.base.power.PowerHandlerUtil;
import crazypants.enderio.base.power.forge.tile.ILegacyPoweredTile;
import crazypants.enderio.base.power.forge.tile.InternalGeneratorTileWrapper;
import crazypants.enderio.machines.config.config.SolarConfig;
import crazypants.enderio.machines.init.MachineObject;
import crazypants.enderio.machines.machine.solar.ISolarPanelNetwork;
import crazypants.enderio.machines.machine.solar.NoSolarPanelNetwork;
import crazypants.enderio.machines.machine.solar.SolarPanelNetwork;
import crazypants.enderio.machines.machine.solar.SolarType;
import info.loenwind.autosave.annotations.Storable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;

@Storable
public class TileSolarPanel
extends TileEntityEio
implements ILegacyPoweredTile,
PacketConduitProbe.IHasConduitProbeData {
    protected ISolarPanelNetwork network = NoSolarPanelNetwork.INSTANCE;
    private int idleCounter = 0;

    public TileSolarPanel() {
        this.addICap(CapabilityEnergy.ENERGY, facing -> facing == EnumFacing.DOWN ? InternalGeneratorTileWrapper.get((ILegacyPoweredTile)this, (EnumFacing)facing) : null);
    }

    public boolean canConnectEnergy(@Nonnull EnumFacing from) {
        return from == EnumFacing.DOWN;
    }

    public int getEnergyStored() {
        return this.network.getEnergyAvailablePerTick();
    }

    public int getMaxEnergyStored() {
        return this.network.getEnergyMaxPerTick();
    }

    public void setEnergyStored(int stored) {
    }

    public void doUpdate() {
        if (!this.func_145830_o()) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            super.doUpdate();
            return;
        }
        if (!this.network.isValid()) {
            SolarPanelNetwork.build(this);
        }
        if (this.idleCounter > 0) {
            --this.idleCounter;
            return;
        }
        IPowerInterface receptor = PowerHandlerUtil.getPowerInterface((ICapabilityProvider)this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(EnumFacing.DOWN)), (EnumFacing)EnumFacing.UP);
        if (receptor != null && receptor.receiveEnergy(1, true) > 0) {
            int canTransmit = this.network.getEnergyAvailableThisTick();
            if (canTransmit > 0) {
                this.network.extractEnergy(receptor.receiveEnergy(canTransmit, false));
            } else {
                this.idleCounter = this.field_145850_b.field_73012_v.nextInt(32);
            }
        } else {
            this.idleCounter = this.field_145850_b.field_73012_v.nextInt(256);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.network.destroyNetwork();
    }

    int getEnergyPerTick() {
        return TileSolarPanel.getEnergyPerTick(this.field_145850_b, this.field_174879_c);
    }

    static int getEnergyPerTick(@Nonnull World world, @Nonnull BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        if (blockState.func_177230_c() == MachineObject.block_solar_panel.getBlock()) {
            return ((SolarType)((Object)blockState.func_177229_b(SolarType.KIND))).getRfperTick();
        }
        return -1;
    }

    float calculateLightRatio() {
        return TileSolarPanel.calculateLightRatio(this.field_145850_b);
    }

    static boolean isPowered(@Nonnull World world, BlockPos pos) {
        return TileSolarPanel.isSolarPowered(world, pos) || TileSolarPanel.isArtificiallyPowered(world, pos);
    }

    static boolean isSolarPowered(@Nonnull World world, BlockPos pos) {
        return world.func_175710_j(pos.func_177984_a());
    }

    static boolean isArtificiallyPowered(@Nonnull World world, BlockPos pos) {
        return (Boolean)SolarConfig.solarPoweredBySunshine.get() != false && world.func_180495_p(pos.func_177984_a()).func_177230_c() == Fluids.LIQUID_SUNSHINE.getBlock();
    }

    static float calculateLocalLightRatio(@Nonnull World world, BlockPos pos, float baseRatio) {
        IBlockState blockState;
        float ratio;
        float f = ratio = TileSolarPanel.isSolarPowered(world, pos) ? baseRatio : 0.0f;
        if (ratio < 1.0f && ((Boolean)SolarConfig.solarPoweredBySunshine.get()).booleanValue() && (blockState = world.func_180495_p(pos.func_177984_a())).func_177230_c() == Fluids.LIQUID_SUNSHINE.getBlock()) {
            float value = ((BlockFluidEio.LiquidSunshine)Fluids.LIQUID_SUNSHINE.getBlock()).getScaledLevel(blockState, (IBlockAccess)world, pos.func_177984_a());
            ratio = Math.max(value, ratio);
        }
        return ratio;
    }

    public static float calculateLightRatio(@Nonnull World world) {
        int lightValue = EnumSkyBlock.SKY.field_77198_c - world.func_175657_ab();
        float sunAngle = world.func_72929_e(1.0f);
        sunAngle = sunAngle < (float)Math.PI ? (sunAngle += (0.0f - sunAngle) * 0.2f) : (sunAngle += ((float)Math.PI * 2 - sunAngle) * 0.2f);
        lightValue = Math.round((float)lightValue * MathHelper.func_76134_b((float)sunAngle));
        lightValue = MathHelper.func_76125_a((int)lightValue, (int)0, (int)15);
        return (float)lightValue / 15.0f;
    }

    public boolean displayPower() {
        return true;
    }

    public void setNetwork(ISolarPanelNetwork network) {
        this.network = network;
    }

    @Nonnull
    public BlockPos getLocation() {
        return this.field_174879_c;
    }

    @Nonnull
    public NNList<ITextComponent> getConduitProbeInformation(@Nonnull EntityPlayer player, @Nullable EnumFacing side) {
        return this.network.getConduitProbeInformation(player, side);
    }
}

