/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.teleport.telepad.gui;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.common.util.IProgressTile;
import com.enderio.core.client.gui.IDrawingElement;
import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.Util;
import crazypants.enderio.api.capacitor.ICapacitorKey;
import crazypants.enderio.base.gui.GuiContainerBaseEIO;
import crazypants.enderio.base.item.coordselector.TelepadTarget;
import crazypants.enderio.base.machine.gui.IPowerBarData;
import crazypants.enderio.base.machine.gui.PowerBar;
import crazypants.enderio.machines.capacitor.CapacitorKey;
import crazypants.enderio.machines.lang.Lang;
import crazypants.enderio.machines.machine.teleport.telepad.TileDialingDevice;
import crazypants.enderio.machines.machine.teleport.telepad.TileTelePad;
import crazypants.enderio.machines.machine.teleport.telepad.gui.ContainerDialingDevice;
import crazypants.enderio.machines.machine.teleport.telepad.gui.ContainerDialingDeviceProxy;
import crazypants.enderio.machines.machine.teleport.telepad.gui.GuiTargetList;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;

public class GuiDialingDevice
extends GuiContainerBaseEIO<TileDialingDevice>
implements ContainerDialingDeviceProxy {
    private static final int ID_TELEPORT_BUTTON = 96;
    private GuiButton teleportButton;
    @Nonnull
    private final TileTelePad telepad;
    private static final int powerX = 8;
    private static final int powerY = 9;
    private static final int powerScale = 120;
    private static final int progressX = 26;
    private static final int progressY = 110;
    private static final int progressScale = 124;
    private final GuiTargetList targetList;

    public GuiDialingDevice(@Nonnull InventoryPlayer playerInv, @Nonnull TileDialingDevice te, final @Nonnull TileTelePad telepad) {
        super((Object)te, (Container)new ContainerDialingDevice(playerInv, te), new String[]{"dialing_device"});
        this.telepad = telepad;
        this.field_147000_g = 220;
        this.addToolTip(new GuiToolTip(new Rectangle(26, 110, 124, 10), new String[]{""}){

            protected void updateText() {
                this.text.clear();
                this.text.add(Math.round(telepad.getProgress() * 100.0f) + "%");
            }
        });
        int w = 115;
        int h = 71;
        int x = 30;
        int y = 10;
        this.targetList = new GuiTargetList(w, h, x, y, te);
        this.targetList.setShowSelectionBox(true);
        this.targetList.setScrollButtonIds(100, 101);
        this.targetList.setSelection(telepad.getTarget());
        this.addToolTip(new GuiToolTip(new Rectangle(x, y, w, h), new String[]{""}){

            protected void updateText() {
                this.text.clear();
                TelepadTarget el = (TelepadTarget)GuiDialingDevice.this.targetList.getElementAt(this.getLastMouseX() + GuiDialingDevice.this.getGuiLeft(), this.getLastMouseY() + GuiDialingDevice.this.getGuiTop());
                if (el != null) {
                    Rectangle iconBnds = GuiDialingDevice.this.targetList.getIconBounds(0);
                    if (iconBnds.contains(this.getLastMouseX() + GuiDialingDevice.this.getGuiLeft(), 1)) {
                        this.text.add(TextFormatting.RED + "Delete");
                    } else {
                        String name = el.getName();
                        if (name.trim().length() == 0) {
                            name = Lang.GUI_TELEPAD_UNNAMED_LOCATION.get();
                        }
                        this.text.add(TextFormatting.WHITE + name);
                        this.text.add(BlockCoord.chatString((BlockPos)el.getLocation(), (TextFormatting)TextFormatting.WHITE));
                        this.text.add(el.getDimenionName());
                    }
                }
            }
        });
        this.addDrawingElement((IDrawingElement)new PowerBar((IPowerBarData)te.getEnergy(), (GuiContainerBaseEIO)this, 8, 9, 120));
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        String text = Lang.GUI_TELEPAD_TELEPORT.get();
        int textWidth = this.getFontRenderer().func_78256_a(text) + 10;
        int x = this.field_147003_i + this.field_146999_f / 2 - textWidth / 2;
        int y = this.field_147009_r + 85;
        this.teleportButton = new GuiButton(96, x, y, textWidth, 20, text);
        this.func_189646_b(this.teleportButton);
        ((ContainerDialingDevice)this.field_147002_h).createGhostSlots((List<GhostSlot>)this.getGhostSlotHandler().getGhostSlots());
        this.targetList.onGuiInit((IGuiScreen)this);
    }

    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindGuiTexture();
        int sx = (this.field_146294_l - this.field_146999_f) / 2;
        int sy = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(sx, sy, 0, 0, this.field_146999_f, this.field_147000_g);
        this.targetList.drawScreen(mouseX, mouseY, partialTick);
        super.func_146976_a(partialTick, mouseX, mouseY);
        if (((TileDialingDevice)((Object)this.getOwner())).getEnergy().getEnergyStored() < ((TileDialingDevice)((Object)this.getOwner())).getEnergy().getMaxUsage((ICapacitorKey)CapacitorKey.DIALING_DEVICE_POWER_USE_TELEPORT)) {
            String txt = TextFormatting.DARK_RED + "No Power";
            this.renderInfoMessage(sx, sy, txt, 0);
            return;
        }
        if (this.telepad.getEnergy().getEnergyStored() <= 0) {
            String txt = TextFormatting.DARK_RED + "Telepad not powered";
            this.renderInfoMessage(sx, sy, txt, 0);
            return;
        }
        if (this.targetList.getSelectedElement() == null) {
            String txt = TextFormatting.DARK_RED + "Enter Target";
            this.renderInfoMessage(sx, sy, txt, 0);
            return;
        }
        this.bindGuiTexture();
        int progressScaled = Util.getProgressScaled((int)124, (IProgressTile)this.telepad);
        this.func_73729_b(sx + 26, sy + 110, 0, this.field_147000_g, progressScaled, 10);
        Entity e = this.telepad.getCurrentTarget();
        if (e != null) {
            String name = e.func_70005_c_();
            this.renderInfoMessage(sx, sy, name, 0);
        } else if (this.telepad.wasBlocked()) {
            String s = Lang.GUI_TELEPAD_ERROR_BLOCKED.get();
            this.renderInfoMessage(sx, sy, s, 0xAA0000);
        }
    }

    private void renderInfoMessage(int sx, int sy, @Nonnull String txt, int color) {
        FontRenderer fnt = Minecraft.func_71410_x().field_71466_p;
        fnt.func_78276_b(txt, sx + this.field_146999_f / 2 - fnt.func_78256_a(txt) / 2, sy + 110 + fnt.field_78288_b + 6, color);
    }

    protected void func_146284_a(@Nonnull GuiButton button) throws IOException {
        int targetID;
        TelepadTarget target;
        super.func_146284_a(button);
        if (button.field_146127_k == 96 && (target = (TelepadTarget)this.targetList.getSelectedElement()) != null && (targetID = ((TileDialingDevice)((Object)this.getOwner())).getTargets().indexOf(target)) >= 0) {
            this.doTeleport(this.telepad.func_174877_v(), targetID, true);
        }
    }
}

