/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.wired;

import com.enderio.core.client.gui.widget.GhostBackgroundItemSlot;
import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.common.util.ArrayInventory;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.integration.baubles.BaublesUtil;
import crazypants.enderio.base.integration.jei.ItemHelper;
import crazypants.enderio.base.machine.baselegacy.AbstractInventoryMachineEntity;
import crazypants.enderio.base.machine.gui.AbstractMachineContainer;
import crazypants.enderio.base.power.PowerHandlerUtil;
import crazypants.enderio.machines.machine.tank.InventorySlot;
import crazypants.enderio.machines.machine.wired.TileWiredCharger;
import crazypants.enderio.util.ShadowInventory;
import java.awt.Point;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Triple;

public abstract class ContainerWiredCharger
extends AbstractMachineContainer<TileWiredCharger> {
    public static int FIRST_RECIPE_SLOT = 0;
    public static int NUM_RECIPE_SLOT = 1;
    public static int FIRST_INVENTORY_SLOT = 3;
    public static int NUM_INVENTORY_SLOT = 36;
    protected IInventory baubles;

    @Nonnull
    public static ContainerWiredCharger create(@Nonnull InventoryPlayer playerInv, @Nonnull TileWiredCharger te, final int baubleSlots) {
        return new ContainerWiredCharger(playerInv, te){

            @Override
            protected int getBaublesSize() {
                return baubleSlots;
            }
        };
    }

    public ContainerWiredCharger(@Nonnull InventoryPlayer playerInv, @Nonnull TileWiredCharger te) {
        super(playerInv, (AbstractInventoryMachineEntity)te);
    }

    protected void addMachineSlots(final @Nonnull InventoryPlayer playerInv) {
        this.func_75146_a((Slot)new InventorySlot(this.getInv(), 0, 75, 28));
        this.func_75146_a((Slot)new InventorySlot(this.getInv(), 1, 126, 28));
        this.baubles = BaublesUtil.instance().getBaubles(playerInv.field_70458_d);
        if (this.baubles != null && BaublesUtil.WhoAmI.whoAmI((World)playerInv.field_70458_d.field_70170_p) == BaublesUtil.WhoAmI.SPCLIENT) {
            this.baubles = new ShadowInventory(this.baubles);
        }
        if (this.hasBaublesSlots() && this.baubles == null) {
            this.baubles = new ArrayInventory(this.getBaublesSize()){

                public boolean func_94041_b(int i, @Nonnull ItemStack itemstack) {
                    return false;
                }

                @Nonnull
                public ItemStack func_70301_a(int slot) {
                    return new ItemStack(Blocks.field_180401_cv);
                }

                @Nonnull
                public ItemStack func_70298_a(int slot, int amount) {
                    return ItemStack.field_190927_a;
                }

                @Nonnull
                public ItemStack func_70304_b(int index) {
                    return ItemStack.field_190927_a;
                }
            };
        }
        int baublesOffset = 196;
        for (final EntityEquipmentSlot slt : EntityEquipmentSlot.values()) {
            if (slt.func_188453_a() != EntityEquipmentSlot.Type.ARMOR) continue;
            this.func_75146_a(new Slot((IInventory)playerInv, 36 + slt.func_188454_b(), 6, 66 - slt.func_188454_b() * 18){

                public int func_75219_a() {
                    return 1;
                }

                public boolean func_75214_a(@Nonnull ItemStack par1ItemStack) {
                    if (par1ItemStack.func_190926_b()) {
                        return false;
                    }
                    return par1ItemStack.func_77973_b().isValidArmor(par1ItemStack, slt, (Entity)playerInv.field_70458_d);
                }

                @SideOnly(value=Side.CLIENT)
                public String func_178171_c() {
                    return ItemArmor.field_94603_a[slt.func_188454_b()];
                }
            });
        }
        this.func_75146_a(new Slot((IInventory)playerInv, 40, 6, 84){

            @Nullable
            @SideOnly(value=Side.CLIENT)
            public String func_178171_c() {
                return "minecraft:items/empty_armor_slot_shield";
            }
        });
        if (this.hasBaublesSlots() && this.baubles != null) {
            for (int i = 0; i < this.baubles.func_70302_i_(); ++i) {
                this.func_75146_a(new Slot(this.baubles, i, baublesOffset, 12 + i * 18){

                    public boolean func_75214_a(@Nonnull ItemStack par1ItemStack) {
                        return this.field_75224_c.func_94041_b(this.getSlotIndex(), par1ItemStack);
                    }

                    public boolean func_82869_a(@Nonnull EntityPlayer playerIn) {
                        ItemStack stackInSlot = this.field_75224_c.func_70301_a(this.getSlotIndex());
                        if (stackInSlot.func_77973_b() == Item.func_150898_a((Block)Blocks.field_180401_cv)) {
                            return false;
                        }
                        return super.func_82869_a(playerIn);
                    }
                });
            }
        }
    }

    public void addGhostslots(NNList<GhostSlot> ghostSlots) {
        final NNList empties = new NNList();
        final NNList fulls = new NNList();
        ContainerWiredCharger.getValidPair((List<ItemStack>)ItemHelper.getValidItems()).apply((NNList.Callback)new NNList.Callback<Triple<ItemStack, ItemStack, Integer>>(){

            public void apply(@Nonnull Triple<ItemStack, ItemStack, Integer> e) {
                empties.add(e.getLeft());
                fulls.add(e.getMiddle());
            }
        });
        ghostSlots.removeAllByClass(GhostBackgroundItemSlot.class);
        GhostBackgroundItemSlot ghost0 = new GhostBackgroundItemSlot((List)empties, this.getSlotFromInventory(0));
        ghost0.setDisplayStdOverlay(true);
        ghostSlots.add((Object)ghost0);
        GhostBackgroundItemSlot ghost1 = new GhostBackgroundItemSlot((List)fulls, this.getSlotFromInventory(1));
        ghost1.setDisplayStdOverlay(true);
        ghostSlots.add((Object)ghost1);
    }

    public static NNList<Triple<ItemStack, ItemStack, Integer>> getValidPair(List<ItemStack> validItems) {
        NNList result = new NNList();
        for (ItemStack stack : validItems) {
            try {
                int added;
                ItemStack copy;
                IEnergyStorage emptyCap;
                if (PowerHandlerUtil.getCapability((ICapabilityProvider)stack, null) == null || (emptyCap = PowerHandlerUtil.getCapability((ICapabilityProvider)(copy = stack.func_77946_l()), null)) == null) continue;
                int extracted = 1;
                int maxloop = 200;
                while (extracted > 0 && emptyCap.canExtract() && maxloop-- > 0) {
                    extracted = emptyCap.extractEnergy(Integer.MAX_VALUE, false);
                }
                if (!emptyCap.canReceive() || emptyCap.getEnergyStored() >= emptyCap.getMaxEnergyStored()) continue;
                ItemStack empty = copy.func_77946_l();
                int power = added = emptyCap.receiveEnergy(Integer.MAX_VALUE, false);
                maxloop = 200;
                while (added > 0 && maxloop-- > 0) {
                    added = emptyCap.receiveEnergy(Integer.MAX_VALUE, false);
                    power += added;
                }
                result.add((Object)Triple.of((Object)empty, (Object)copy, (Object)power));
            }
            catch (Exception e) {
                Log.LOGGER.error("An itemstack (" + stack + ") threw an exception during energy detection. This is a bug in that mod!", (Throwable)e);
            }
        }
        return result;
    }

    @Nonnull
    public ItemStack func_82846_b(@Nonnull EntityPlayer entityPlayer, int slotIndex) {
        int otherSlots;
        int startBaublesSlot = otherSlots = 9;
        int endBaublesSlot = this.hasBaublesSlots() ? 0 : startBaublesSlot + this.getBaublesSize();
        ItemStack copystack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        if (slot != null && slot.func_75216_d()) {
            ItemStack origStack = slot.func_75211_c();
            copystack = origStack.func_77946_l();
            if (slotIndex < 4 ? !this.mergeItemStackIntoArmor(entityPlayer, origStack, slotIndex) && !this.func_75135_a(origStack, this.startPlayerSlot, this.endHotBarSlot, false) : (!((AbstractInventoryMachineEntity.InventoryWrapper)this.getInv()).func_94041_b(0, origStack) || !this.func_75135_a(origStack, 0, 4, false)) && (slotIndex >= startBaublesSlot && slotIndex < endBaublesSlot ? !this.func_75135_a(origStack, this.startHotBarSlot, this.endHotBarSlot, false) && !this.func_75135_a(origStack, this.startPlayerSlot, this.endPlayerSlot, false) : (slotIndex < this.endPlayerSlot ? !this.func_75135_a(origStack, this.startHotBarSlot, this.endHotBarSlot, false) : slotIndex >= this.startHotBarSlot && slotIndex < this.endHotBarSlot && !this.func_75135_a(origStack, this.startPlayerSlot, this.endPlayerSlot, false)))) {
                return ItemStack.field_190927_a;
            }
            if (origStack.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            slot.func_75218_e();
            if (origStack.func_190916_E() == copystack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            return slot.func_190901_a(entityPlayer, origStack);
        }
        return copystack;
    }

    public boolean hasBaublesSlots() {
        return this.getBaublesSize() > 0;
    }

    protected abstract int getBaublesSize();

    private boolean mergeItemStackIntoArmor(EntityPlayer entityPlayer, ItemStack origStack, int slotIndex) {
        if (origStack == null || EntityLiving.func_184640_d((ItemStack)origStack).func_188453_a() != EntityEquipmentSlot.Type.ARMOR) {
            return false;
        }
        NonNullList ai = entityPlayer.field_71071_by.field_70460_b;
        int index = EntityLiving.func_184640_d((ItemStack)origStack).func_188454_b();
        if (((ItemStack)ai.get(index)).func_190926_b()) {
            ai.set(index, (Object)origStack.func_77946_l());
            origStack.func_190920_e(0);
            return true;
        }
        return false;
    }

    @Nonnull
    public Point getPlayerInventoryOffset() {
        return new Point(29, 84);
    }

    @Nonnull
    public Point getUpgradeOffset() {
        return new Point(33, 60);
    }
}

