/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.tools;

import ivorius.ivtoolkit.blocks.BlockArea;
import ivorius.ivtoolkit.blocks.BlockPositions;
import ivorius.ivtoolkit.blocks.IvBlockCollection;
import ivorius.ivtoolkit.tools.MCRegistry;
import ivorius.ivtoolkit.tools.NBTCompoundObjectsMC;
import ivorius.ivtoolkit.tools.NBTStateInjector;
import ivorius.ivtoolkit.tools.NBTTagLists;
import ivorius.ivtoolkit.transform.Mover;
import ivorius.ivtoolkit.world.MockWorld;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class IvWorldData {
    public IvBlockCollection blockCollection;
    public List<NBTTagCompound> tileEntities;
    public List<NBTTagCompound> entities;

    public IvWorldData(IvBlockCollection blockCollection, List<NBTTagCompound> tileEntities, List<NBTTagCompound> entities) {
        this.blockCollection = blockCollection;
        this.tileEntities = tileEntities;
        this.entities = entities;
    }

    public IvWorldData(NBTTagCompound compound, MCRegistry registry) {
        compound = compound.func_74737_b();
        DataFixer fixer = DataFixesManager.func_188279_a();
        this.blockCollection = new IvBlockCollection(compound.func_74775_l("blockCollection"), registry);
        this.tileEntities = new ArrayList<NBTTagCompound>();
        this.tileEntities.addAll(NBTTagLists.compoundsFrom(compound, "tileEntities"));
        this.tileEntities.forEach(teCompound -> NBTStateInjector.recursivelyApply((NBTBase)teCompound, registry, false));
        this.tileEntities.replaceAll(teCompound -> fixer.func_188257_a((IFixType)FixTypes.BLOCK_ENTITY, teCompound));
        this.entities = new ArrayList<NBTTagCompound>();
        this.entities.addAll(NBTTagLists.compoundsFrom(compound, "entities"));
        this.entities.forEach(entityCompound -> NBTStateInjector.recursivelyApply((NBTBase)entityCompound, registry, false));
        this.tileEntities.replaceAll(teCompound -> fixer.func_188257_a((IFixType)FixTypes.ENTITY, teCompound));
    }

    public static IvWorldData capture(World world, BlockArea blockArea, boolean captureEntities) {
        return IvWorldData.capture(MockWorld.of(world), blockArea, captureEntities);
    }

    public static IvWorldData capture(MockWorld world, BlockArea blockArea, boolean captureEntities) {
        BlockPos referenceCoord = blockArea.getLowerCorner();
        BlockPos invertedReference = BlockPositions.invert(referenceCoord);
        int[] size = blockArea.areaSize();
        IvBlockCollection blockCollection = new IvBlockCollection(size[0], size[1], size[2]);
        ArrayList<NBTTagCompound> tileEntities = new ArrayList<NBTTagCompound>();
        for (BlockPos worldCoord : blockArea) {
            BlockPos dataCoord = worldCoord.func_177973_b((Vec3i)blockArea.getLowerCorner());
            blockCollection.setBlockState(dataCoord, world.func_180495_p(worldCoord));
            TileEntity tileEntity = world.func_175625_s(worldCoord);
            if (tileEntity == null) continue;
            Mover.moveTileEntity(tileEntity, invertedReference);
            NBTTagCompound teCompound = NBTCompoundObjectsMC.write(tileEntity, true);
            NBTStateInjector.recursivelyInject((NBTBase)teCompound);
            tileEntities.add(teCompound);
            Mover.moveTileEntity(tileEntity, referenceCoord);
        }
        List<NBTTagCompound> entities = captureEntities ? world.getEntities(blockArea.asAxisAlignedBB(), IvWorldData.saveableEntityPredicate()).stream().map(entity -> {
            Mover.moveEntity(entity, invertedReference);
            NBTTagCompound entityCompound = NBTCompoundObjectsMC.write(entity, true);
            NBTStateInjector.recursivelyInject((NBTBase)entityCompound);
            Mover.moveEntity(entity, referenceCoord);
            return entityCompound;
        }).collect(Collectors.toList()) : Collections.emptyList();
        return new IvWorldData(blockCollection, tileEntities, entities);
    }

    public static Predicate<Entity> saveableEntityPredicate() {
        return entity -> !(entity instanceof EntityPlayer);
    }

    @Deprecated
    public NBTTagCompound createTagCompound(BlockPos referenceCoord) {
        return this.createTagCompound();
    }

    public NBTTagCompound createTagCompound() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("blockCollection", (NBTBase)this.blockCollection.createTagCompound());
        compound.func_74782_a("tileEntities", (NBTBase)NBTTagLists.write(this.tileEntities));
        compound.func_74782_a("entities", (NBTBase)NBTTagLists.write(this.entities));
        return compound;
    }
}

