/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.commands.info;

import com.google.common.collect.Lists;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.commands.RCTextStyle;
import ivorius.reccomplex.commands.structure.CommandSearchStructure;
import ivorius.reccomplex.commands.structure.StructureSearch;
import ivorius.reccomplex.shadow.mcopts.commands.CommandSplit;
import ivorius.reccomplex.shadow.mcopts.commands.SimpleCommand;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.MCP;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.Parameters;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.expect.MCE;
import ivorius.reccomplex.shadow.mcopts.translation.ServerTranslations;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class CommandBiomeDict
extends CommandSplit {
    public CommandBiomeDict() {
        super(RCConfig.commandPrefix + "biome");
        this.add(new SimpleCommand("search", expect -> expect.skip().descriptionU("terms").required()){

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                Parameters parameters = Parameters.of(args, this.expect()::declare);
                List<String> terms = parameters.get(0).varargsList().require();
                CommandSearchStructure.postResultMessage("Biomes:", sender, RCTextStyle::biome, CommandSearchStructure.search(Biome.field_185377_q.func_148742_b(), loc -> StructureSearch.searchRank(terms, CommandBiomeDict.keywords(loc, (Biome)Biome.field_185377_q.func_82594_a(loc)))));
            }
        });
        this.add(new SimpleCommand("types", expect -> expect.then(MCE::biome).required()){

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                Parameters parameters = Parameters.of(args, this.expect()::declare);
                Biome biome = (Biome)parameters.get(0).to(MCP::biome).require();
                sender.func_145747_a(RecurrentComplex.translations.format("commands.biomedict.get", RCTextStyle.biome(biome), ServerTranslations.join(Lists.newArrayList((Iterable)BiomeDictionary.getTypes((Biome)biome)).stream().map(RCTextStyle::biomeType).toArray())));
            }
        });
        this.add(new SimpleCommand("list", expect -> expect.then(MCE::biomeType).required()){

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                Parameters parameters = Parameters.of(args, this.expect()::declare);
                BiomeDictionary.Type type = (BiomeDictionary.Type)parameters.get(0).to(MCP::biomeDictionaryType).require();
                sender.func_145747_a(RecurrentComplex.translations.format("commands.biomedict.list", RCTextStyle.biomeType(type), ServerTranslations.join(Lists.newArrayList((Iterable)BiomeDictionary.getBiomes((BiomeDictionary.Type)type)).stream().map(RCTextStyle::biome).toArray())));
            }
        });
        this.permitFor(2);
    }

    @Nonnull
    public static Collection<String> keywords(ResourceLocation id, Biome biome) {
        return Arrays.asList(id.toString(), biome.func_185359_l());
    }
}

