/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.commands.schematic;

import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.commands.parameters.RCP;
import ivorius.reccomplex.commands.parameters.expect.RCE;
import ivorius.reccomplex.commands.schematic.CommandExportSchematic;
import ivorius.reccomplex.commands.schematic.CommandImportSchematic;
import ivorius.reccomplex.files.loading.ResourceDirectory;
import ivorius.reccomplex.network.PacketEditStructureHandler;
import ivorius.reccomplex.shadow.mcopts.commands.CommandExpecting;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.Parameters;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.expect.Expect;
import ivorius.reccomplex.world.gen.feature.structure.generic.GenericStructure;
import ivorius.reccomplex.world.gen.feature.structure.schematics.SchematicFile;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;

public class CommandConvertSchematic
extends CommandExpecting {
    public String func_71517_b() {
        return "convert";
    }

    @Override
    public void expect(Expect expect) {
        expect.then(RCE::schematic).named("id", new String[0]).then(RCE::randomString).descriptionU("export id").named("from", new String[0]).then(RCE::structure).named("directory", "d").then(RCE::resourceDirectory);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender commandSender, String[] args) throws CommandException {
        Parameters parameters = Parameters.of(args, this.expect()::declare);
        EntityPlayerMP player = CommandConvertSchematic.func_71521_c((ICommandSender)commandSender);
        if (args.length < 1) {
            throw RecurrentComplex.translations.wrongUsageException("commands.rcconvertschematic.usage", new Object[0]);
        }
        ResourceDirectory directory = parameters.get("directory").to(RCP::resourceDirectory).optional().orElse(null);
        String schematicName = parameters.get(0).require();
        String structureID = parameters.get("id").optional().orElse(schematicName);
        SchematicFile schematicFile = CommandImportSchematic.parseSchematic(schematicName);
        GenericStructure from = (GenericStructure)parameters.get("from").to(RCP::structureFromBlueprint, commandSender).require();
        from.worldDataCompound = CommandExportSchematic.toWorldData(schematicFile).createTagCompound();
        PacketEditStructureHandler.openEditStructure(player, from, player.func_180425_c(), structureID, directory);
    }

    public int func_82362_a() {
        return 4;
    }
}

