/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.files.saving;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import ivorius.reccomplex.files.loading.LeveledRegistry;
import ivorius.reccomplex.files.saving.FileSaverAdapter;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class FileSaverString<S>
extends FileSaverAdapter<S> {
    public Writer<? super S> writer;

    public FileSaverString(String id, String suffix, LeveledRegistry<S> registry, Writer<? super S> writer) {
        super(id, suffix, registry);
        this.writer = writer;
    }

    public FileSaverString(String id, String suffix, LeveledRegistry<S> registry, Gson gson, Class<? extends S> type) {
        this(id, suffix, registry, FileSaverString.gsonSaver(gson, type));
    }

    public FileSaverString(String id, String suffix, LeveledRegistry<S> registry, Class<? extends S> type) {
        this(id, suffix, registry, FileSaverString.gsonSaver(type));
    }

    public static <S> Writer<S> gsonSaver(Gson gson, Class<? extends S> type) {
        return s -> gson.toJson(s, (Type)type);
    }

    public static <S> Writer<S> gsonSaver(Class<? extends S> type) {
        return FileSaverString.gsonSaver(new GsonBuilder().setPrettyPrinting().create(), type);
    }

    @Override
    public void saveFile(Path path, S s) throws Exception {
        Files.write(path, this.write(s).getBytes(), new OpenOption[0]);
    }

    public String write(S s) throws Exception {
        if (this.writer == null) {
            throw new UnsupportedOperationException("write");
        }
        return this.writer.write(s);
    }

    public static interface Writer<S> {
        public String write(S var1) throws Exception;
    }
}

