/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.utils.expression;

import com.google.common.primitives.Ints;
import ivorius.reccomplex.utils.algebra.BoolFunctionExpressionCache;
import ivorius.reccomplex.utils.algebra.FunctionExpressionCache;
import ivorius.reccomplex.utils.algebra.RCBoolAlgebra;
import ivorius.reccomplex.utils.algebra.SupplierCache;
import java.text.ParseException;
import java.util.function.Function;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.text.TextFormatting;

public class CommandExpression
extends BoolFunctionExpressionCache<Argument, Object> {
    public static final String NAME_PREFIX = "name=";
    public static final String PERM_PREFIX = "canUseLevel:";

    public CommandExpression() {
        super(RCBoolAlgebra.algebra(), true, TextFormatting.GREEN + "Any Command");
        this.addTypes(new NameType(NAME_PREFIX, ""), t -> t.alias("$", ""));
        this.addTypes(new PermType(PERM_PREFIX, ""), t -> t.alias("#", ""));
    }

    protected class PermType
    extends FunctionExpressionCache.VariableType<Boolean, Argument, Object> {
        public PermType(String prefix, String suffix) {
            super(prefix, suffix);
        }

        public Integer parseNumber(String var) {
            Integer integer = Ints.tryParse((String)var);
            return integer != null ? integer : 0;
        }

        @Override
        public Function<SupplierCache<Argument>, Boolean> parse(String var) throws ParseException {
            Integer level = this.parseNumber(var);
            if (level == null) {
                throw new ParseException("Not a number: " + var, 0);
            }
            return argument -> ((Argument)argument.get()).sender.func_70003_b(level.intValue(), ((Argument)argument.get()).name);
        }

        @Override
        public FunctionExpressionCache.Validity validity(String var, Object object) {
            return FunctionExpressionCache.Validity.KNOWN;
        }
    }

    protected class NameType
    extends FunctionExpressionCache.VariableType<Boolean, Argument, Object> {
        public NameType(String prefix, String suffix) {
            super(prefix, suffix);
        }

        @Override
        public Function<SupplierCache<Argument>, Boolean> parse(String var) {
            return argument -> ((Argument)argument.get()).sender.func_70005_c_().equals(var);
        }

        @Override
        public FunctionExpressionCache.Validity validity(String var, Object object) {
            return FunctionExpressionCache.Validity.KNOWN;
        }
    }

    public static class Argument {
        public final String name;
        public final ICommandSender sender;

        public Argument(String name, ICommandSender sender) {
            this.name = name;
            this.sender = sender;
        }
    }
}

