/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.utils.presets;

import com.google.common.collect.Lists;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.utils.presets.PresetRegistry;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PresettedObject<T> {
    @Nonnull
    protected PresetRegistry<T> presetRegistry;
    @Nullable
    protected String preset;
    protected T t;

    public PresettedObject(@Nonnull PresetRegistry<T> presetRegistry, @Nullable String preset) {
        this.presetRegistry = presetRegistry;
        this.setPreset(preset);
    }

    @Nonnull
    public PresetRegistry<T> getPresetRegistry() {
        return this.presetRegistry;
    }

    public void setPresetRegistry(@Nonnull PresetRegistry<T> presetRegistry) {
        this.presetRegistry = presetRegistry;
    }

    @Nullable
    public String getPreset() {
        return this.preset;
    }

    @Nonnull
    public Optional<String> presetTitle() {
        return Optional.ofNullable(this.getPreset()).map(id -> this.presetRegistry.title((String)id).orElse(String.format("Missing Preset (%s)", id)));
    }

    @Nonnull
    public Optional<List<String>> presetDescription() {
        return Optional.ofNullable(this.getPreset()).map(id -> this.presetRegistry.description((String)id).orElse(Lists.newArrayList((Object[])new String[]{String.format("Missing Preset (%s)", id)})));
    }

    public boolean setPreset(@Nullable String preset) {
        this.preset = preset;
        this.t = null;
        return true;
    }

    public void setToCustom() {
        this.loadFromPreset(true);
        this.preset = null;
    }

    public boolean isCustom() {
        return this.preset == null;
    }

    public void setToDefault() {
        this.setPreset(this.defaultPreset());
    }

    public T getContents() {
        if (!this.isCustom()) {
            this.loadFromPreset(false);
        }
        return this.t;
    }

    public void setContents(T ts) {
        this.preset = null;
        this.t = ts;
    }

    protected boolean loadFromPreset(boolean copy) {
        if (this.preset == null) {
            return true;
        }
        this.t = this.presetContents(copy);
        if (this.t != null) {
            return true;
        }
        RecurrentComplex.logger.warn(String.format("Failed to find preset (%s): %s", this.presetRegistry.getRegistry().description, this.preset));
        this.t = (copy ? this.presetRegistry.preset(this.defaultPreset()) : this.presetRegistry.originalPreset(this.defaultPreset())).get();
        return false;
    }

    protected String defaultPreset() {
        String defaultPreset = this.presetRegistry.defaultID();
        if (!this.presetRegistry.has(defaultPreset)) {
            throw new IllegalStateException(String.format("Default preset named '%s' not found!", defaultPreset));
        }
        return defaultPreset;
    }

    private T presetContents(boolean copy) {
        return (copy ? this.presetRegistry.preset(this.preset) : this.presetRegistry.originalPreset(this.preset)).orElse(null);
    }
}

