/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.structure.generic.transformers;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import ivorius.ivtoolkit.blocks.BlockStates;
import ivorius.ivtoolkit.tools.IvWorldData;
import ivorius.ivtoolkit.tools.MCRegistry;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.gui.editstructure.transformers.TableDataSourceBTPillar;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.datasource.TableDataSource;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.nbt.NBTNone;
import ivorius.reccomplex.utils.algebra.ExpressionCache;
import ivorius.reccomplex.utils.expression.BlockExpression;
import ivorius.reccomplex.world.gen.feature.structure.Environment;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureLoadContext;
import ivorius.reccomplex.world.gen.feature.structure.context.StructurePrepareContext;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureSpawnContext;
import ivorius.reccomplex.world.gen.feature.structure.generic.transformers.RunTransformer;
import ivorius.reccomplex.world.gen.feature.structure.generic.transformers.Transformer;
import ivorius.reccomplex.world.gen.feature.structure.generic.transformers.TransformerReplace;
import ivorius.reccomplex.world.gen.feature.structure.generic.transformers.TransformerSingleBlock;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TransformerPillar
extends TransformerSingleBlock<NBTNone> {
    public BlockExpression sourceMatcher;
    public IBlockState destState;

    public TransformerPillar() {
        this(null, BlockExpression.of((MCRegistry)RecurrentComplex.specialRegistry, Blocks.field_150348_b, 0), Blocks.field_150348_b.func_176223_P());
    }

    public TransformerPillar(@Nullable String id, String sourceExpression, IBlockState destState) {
        super(id != null ? id : TransformerPillar.randomID(TransformerPillar.class));
        this.sourceMatcher = ExpressionCache.of(new BlockExpression(RecurrentComplex.specialRegistry), sourceExpression);
        this.destState = destState;
    }

    @Override
    public boolean matches(Environment environment, NBTNone instanceData, BlockPos sourcePos, IBlockState state) {
        return this.sourceMatcher.test(state);
    }

    @Override
    public void transformBlock(NBTNone instanceData, Transformer.Phase phase, StructureSpawnContext context, RunTransformer transformer, int[] areaSize, BlockPos coord, IBlockState sourceState) {
        if (RecurrentComplex.specialRegistry.isSafe(this.destState.func_177230_c())) {
            BlockPos pos;
            IBlockState blockState;
            WorldServer world = context.environment.world;
            int y = coord.func_177956_o();
            do {
                pos = new BlockPos(coord.func_177958_n(), y--, coord.func_177952_p());
                context.setBlock(pos, this.destState, 2);
            } while (((blockState = world.func_180495_p(pos)).func_177230_c().func_176200_f((IBlockAccess)world, pos) || blockState.func_185904_a() == Material.field_151584_j || blockState.func_177230_c().isFoliage((IBlockAccess)world, pos)) && y > 0);
        }
    }

    @Override
    public NBTNone prepareInstanceData(StructurePrepareContext context, IvWorldData worldData) {
        return new NBTNone();
    }

    @Override
    public NBTNone loadInstanceData(StructureLoadContext context, NBTBase nbt) {
        return new NBTNone();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getDisplayString() {
        return "Pillar: " + this.sourceMatcher.getDisplayString(null) + "->" + this.destState.func_177230_c().func_149732_F();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TableDataSource tableDataSource(TableNavigator navigator, TableDelegate delegate) {
        return new TableDataSourceBTPillar(this, navigator, delegate);
    }

    @Override
    public boolean generatesInPhase(NBTNone instanceData, Transformer.Phase phase) {
        return phase == Transformer.Phase.BEFORE;
    }

    public static class Serializer
    implements JsonDeserializer<TransformerPillar>,
    JsonSerializer<TransformerPillar> {
        private MCRegistry registry;

        public Serializer(MCRegistry registry) {
            this.registry = registry;
        }

        public TransformerPillar deserialize(JsonElement jsonElement, Type par2Type, JsonDeserializationContext context) {
            String destBlock;
            Block dest;
            JsonObject jsonObject = JsonUtils.asJsonObject(jsonElement, "transformerPillar");
            String id = Transformer.readID(jsonObject);
            String expression = TransformerReplace.Serializer.readLegacyMatcher(jsonObject, "source", "sourceMetadata");
            if (expression == null) {
                expression = JsonUtils.getString(jsonObject, "sourceExpression", "");
            }
            IBlockState destState = (dest = this.registry.blockFromID(new ResourceLocation(destBlock = JsonUtils.getString(jsonObject, "dest")))) != null ? BlockStates.fromMetadata(dest, JsonUtils.getInt(jsonObject, "destMetadata")) : null;
            return new TransformerPillar(id, expression, destState);
        }

        public JsonElement serialize(TransformerPillar transformer, Type par2Type, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("id", transformer.id());
            jsonObject.addProperty("sourceExpression", transformer.sourceMatcher.getExpression());
            jsonObject.addProperty("dest", this.registry.idFromBlock(transformer.destState.func_177230_c()).toString());
            jsonObject.addProperty("destMetadata", (Number)BlockStates.toMetadata(transformer.destState));
            return jsonObject;
        }
    }
}

