/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.StaxFactory;
import crazypants.enderio.base.config.recipes.xml.Output;
import javax.xml.stream.XMLStreamException;

public class OutputWithChance
extends Output {
    private float chance = 1.0f;

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        super.readResolve();
        if (this.chance < 0.0f) {
            throw new InvalidRecipeConfigException("Invalid negative chance in <output>");
        }
        if (this.chance > 1.0f) {
            throw new InvalidRecipeConfigException("Invalid chance above 100% in <output>");
        }
        return this;
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        if ("chance".equals(name)) {
            this.chance = Float.valueOf(value).floatValue();
            return true;
        }
        return super.setAttribute(factory, name, value);
    }

    public float getChance() {
        return this.chance;
    }
}

