/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.material.glass;

import com.enderio.core.common.util.NullHelper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.material.glass.FusedQuartzType;
import crazypants.enderio.base.material.glass.IFusedBlockstate;
import crazypants.enderio.base.render.property.EnumMergingBlockRenderMode;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="enderio", value={Side.CLIENT})
public class EnderIOGlassesStateMapper
extends StateMapperBase {
    @SubscribeEvent
    public static void init(@Nonnull ModelRegistryEvent event) {
        EnderIOGlassesStateMapper mapper = new EnderIOGlassesStateMapper();
        for (FusedQuartzType glasstype : FusedQuartzType.values()) {
            ModelLoader.setCustomStateMapper((Block)glasstype.getBlock(), (IStateMapper)mapper);
        }
    }

    @Nonnull
    protected ModelResourceLocation func_178132_a(@Nonnull IBlockState state) {
        ImmutableMap properties = state.func_177228_b();
        LinkedHashMap map = Maps.newLinkedHashMap();
        map.put(FusedQuartzType.KIND, IFusedBlockstate.get(state).isBlastResistant() ? Material.QUARTZ : Material.GLASS);
        map.put(EnumMergingBlockRenderMode.RENDER, properties.get(EnumMergingBlockRenderMode.RENDER));
        return new ModelResourceLocation((ResourceLocation)Block.field_149771_c.func_177774_c((Object)ModObject.blockFusedQuartz.getBlockNN()), this.func_178131_a(map));
    }

    @Nonnull
    public String func_178131_a(@Nonnull Map<IProperty<?>, Comparable<?>> values) {
        StringBuilder stringbuilder = new StringBuilder();
        for (Map.Entry<IProperty<?>, Comparable<?>> entry : values.entrySet()) {
            if (stringbuilder.length() != 0) {
                stringbuilder.append(",");
            }
            stringbuilder.append(entry.getKey().func_177701_a());
            stringbuilder.append("=");
            stringbuilder.append(((IStringSerializable)entry.getValue()).func_176610_l());
        }
        if (stringbuilder.length() == 0) {
            stringbuilder.append("normal");
        }
        return stringbuilder.toString();
    }

    private static enum Material implements IStringSerializable
    {
        QUARTZ,
        GLASS;


        @Nonnull
        public String func_176610_l() {
            return (String)NullHelper.notnullJ((Object)this.name().toLowerCase(Locale.ENGLISH), (String)"String.toLowerCase()");
        }
    }
}

