/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.paint;

import com.enderio.core.common.BlockEnder;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.paint.PaintUtil;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.Optional;
import team.chisel.ctm.api.IFacade;

public interface IPaintable {
    default public void setPaintSource(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nullable IBlockState paintSource) {
        IPaintableTileEntity te = (IPaintableTileEntity)BlockEnder.getAnyTileEntity((IBlockAccess)world, (BlockPos)pos, IPaintableTileEntity.class);
        if (te != null) {
            te.setPaintSource(paintSource);
        }
    }

    default public void setPaintSource(@Nonnull Block block, @Nonnull ItemStack stack, @Nullable IBlockState paintSource) {
        PaintUtil.setSourceBlock(stack, paintSource);
    }

    @Nullable
    default public IBlockState getPaintSource(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        IPaintableTileEntity te = (IPaintableTileEntity)BlockEnder.getAnyTileEntitySafe((IBlockAccess)world, (BlockPos)pos, IPaintableTileEntity.class);
        if (te != null) {
            return te.getPaintSource();
        }
        return null;
    }

    @Nullable
    default public IBlockState getPaintSource(@Nonnull Block block, @Nonnull ItemStack stack) {
        return PaintUtil.getSourceBlock(stack);
    }

    public static interface IWrenchHideablePaint {
    }

    public static interface IPaintableTileEntity {
        public void setPaintSource(@Nullable IBlockState var1);

        @Nullable
        public IBlockState getPaintSource();

        @Nonnull
        default public IBlockState getPaintSourceNN() {
            return (IBlockState)NullHelper.notnullJ((Object)Optional.ofNullable(this.getPaintSource()).orElseGet(() -> ((Block)Blocks.field_150350_a).func_176223_P()), (String)"Optional orElseGet returned null!");
        }
    }

    public static interface INonSolidBlockPaintableBlock
    extends IBlockPaintableBlock {
    }

    public static interface ISolidBlockPaintableBlock
    extends IBlockPaintableBlock {
    }

    @Optional.Interface(iface="team.chisel.ctm.api.IFacade", modid="ctm-api")
    public static interface IBlockPaintableBlock
    extends IPaintable,
    IFacade {
        @Nonnull
        default public IBlockState getFacade(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nullable EnumFacing side) {
            IBlockState blockState = world.func_180495_p(pos);
            IBlockState paintSource = this.getPaintSource(blockState, world, pos);
            return paintSource != null ? paintSource : blockState;
        }
    }

    public static interface ITexturePaintableBlock
    extends IPaintable {
    }
}

