/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.util;

import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.Log;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Profiler {
    public static final Profiler instance = new Profiler();
    private ConcurrentHashMap<String, Data> profiler = new ConcurrentHashMap();
    private long lastProfiled = 0L;
    private boolean on = false;

    public long start() {
        return this.on ? System.nanoTime() : Long.MAX_VALUE;
    }

    public long pause(long start) {
        return this.on ? System.nanoTime() - start : Long.MAX_VALUE;
    }

    public long resume(long start) {
        return this.on ? System.nanoTime() - start : Long.MAX_VALUE;
    }

    public void stop(long start, String source) {
        long elapsed;
        long l = elapsed = this.on ? System.nanoTime() - start : -1L;
        if (elapsed >= 0L) {
            try {
                this.profiler.putIfAbsent(source, new Data());
                Data data = this.profiler.get(source);
                data.time += elapsed;
                ++data.count;
                if (EnderIO.proxy.getTickCount() > this.lastProfiled) {
                    this.lastProfiled = EnderIO.proxy.getTickCount() + 200L;
                    for (Map.Entry<String, Data> e : this.profiler.entrySet()) {
                        long avg = e.getValue().time / e.getValue().count;
                        Log.info(e.getKey() + ": " + avg + " ns avg over " + e.getValue().count + " calls");
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static class Data {
        long time = 0L;
        long count = 0L;

        private Data() {
        }
    }
}

