/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.network.packet.server;

import io.netty.buffer.ByteBuf;
import jds.bibliocraft.network.packet.Utils;
import jds.bibliocraft.tileentities.TileEntityPainting;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class BiblioPainting
implements IMessage {
    BlockPos pos;
    int corner;
    int scale;
    int res;
    int aspect;
    int rotation;
    int customAspectX;
    int customAspectY;
    boolean hideFrame;

    public BiblioPainting() {
    }

    public BiblioPainting(BlockPos pos, int corner, int scale, int res, int aspect, int rotation, int customAspectX, int customAspectY, boolean hideFrame) {
        this.pos = pos;
        this.corner = corner;
        this.scale = scale;
        this.res = res;
        this.aspect = aspect;
        this.rotation = rotation;
        this.customAspectX = customAspectX;
        this.customAspectY = customAspectY;
        this.hideFrame = hideFrame;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.corner = buf.readInt();
        this.scale = buf.readInt();
        this.res = buf.readInt();
        this.aspect = buf.readInt();
        this.rotation = buf.readInt();
        this.customAspectX = buf.readInt();
        this.customAspectY = buf.readInt();
        this.hideFrame = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        buf.writeInt(this.corner);
        buf.writeInt(this.scale);
        buf.writeInt(this.res);
        buf.writeInt(this.aspect);
        buf.writeInt(this.rotation);
        buf.writeInt(this.customAspectX);
        buf.writeInt(this.customAspectY);
        buf.writeBoolean(this.hideFrame);
    }

    public static class Handler
    implements IMessageHandler<BiblioPainting, IMessage> {
        public IMessage onMessage(BiblioPainting message, MessageContext ctx) {
            ctx.getServerHandler().field_147369_b.func_71121_q().func_152344_a(() -> {
                World world;
                TileEntity tile;
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                if (Utils.hasPointLoaded(player, message.pos) && (tile = (world = player.field_70170_p).func_175625_s(message.pos)) != null && tile instanceof TileEntityPainting) {
                    TileEntityPainting painting = (TileEntityPainting)tile;
                    painting.setHideFrame(message.hideFrame);
                    painting.setPacketUpdate(message.corner, message.scale, message.res, message.aspect, message.rotation, message.customAspectX, message.customAspectY);
                }
            });
            return null;
        }
    }
}

