/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.util;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import tonius.simplyjetpacks.util.math.MathHelper;

public final class FireworksHelper {
    public static ItemStack getFireworksStack(int var0, Explosion ... var1) {
        NBTTagCompound var2 = new NBTTagCompound();
        NBTTagCompound var3 = new NBTTagCompound();
        NBTTagList var4 = new NBTTagList();
        if (var1 != null) {
            int var6 = var1.length;
            for (Explosion var8 : var1) {
                if (var8 == null) continue;
                var4.func_74742_a((NBTBase)var8.getTagCompound());
            }
        }
        var3.func_74774_a("Flight", (byte)MathHelper.clampI(var0, 0, 3));
        var3.func_74782_a("Explosions", (NBTBase)var4);
        var2.func_74782_a("Fireworks", (NBTBase)var3);
        ItemStack var9 = new ItemStack(Items.field_151152_bP);
        var9.func_77982_d(var2);
        return var9;
    }

    public static ItemStack getRandomFireworks(int var0, int var1, int var2, int var3) {
        var1 = MathHelper.clampI(var1, 0, Integer.MAX_VALUE);
        Explosion[] var4 = new Explosion[var1];
        for (int var5 = 0; var5 < var1; ++var5) {
            var4[var5] = Explosion.getRandom(var2, var3);
        }
        return FireworksHelper.getFireworksStack(var0, var4);
    }

    public static final class Explosion {
        private boolean twinkle = false;
        private boolean trail = false;
        private final List<Integer> primaryColors = new ArrayList<Integer>();
        private final List<Integer> fadeColors = new ArrayList<Integer>();
        private Type type = Type.BALL;

        public static Explosion getRandom(int var0, int var1) {
            Color var5;
            int var4;
            var0 = MathHelper.clampI(var0, 1, Integer.MAX_VALUE);
            var1 = MathHelper.clampI(var1, 1, Integer.MAX_VALUE);
            Explosion var2 = new Explosion();
            int var3 = MathHelper.RANDOM.nextInt(4);
            switch (var3) {
                case 0: 
                case 2: {
                    var2.setTwinkle(true);
                    if (var3 == 0) break;
                }
                case 1: {
                    var2.setTrail(true);
                }
            }
            var2.setType(MathHelper.RANDOM.nextInt(5));
            for (var4 = 0; var4 < var0; ++var4) {
                var5 = new Color(Color.HSBtoRGB(MathHelper.RANDOM.nextFloat() * 360.0f, MathHelper.RANDOM.nextFloat() * 0.15f + 0.8f, 0.85f));
                var2.addPrimaryColor(var5.getRed(), var5.getGreen(), var5.getBlue());
            }
            for (var4 = 0; var4 < var1; ++var4) {
                var5 = new Color(Color.HSBtoRGB(MathHelper.RANDOM.nextFloat() * 360.0f, MathHelper.RANDOM.nextFloat() * 0.15f + 0.8f, 0.85f));
                var2.addFadeColor(var5.getRed(), var5.getGreen(), var5.getBlue());
            }
            return var2;
        }

        public Explosion setTwinkle(boolean twinkle) {
            this.twinkle = twinkle;
            return this;
        }

        public Explosion setTrail(boolean trail) {
            this.trail = trail;
            return this;
        }

        public Explosion setType(Type type) {
            this.type = type;
            return this;
        }

        public Explosion setType(int index) {
            this.setType(Type.values()[MathHelper.clampI(index, 0, Type.values().length - 1)]);
            return this;
        }

        public Explosion addPrimaryColor(int red, int green, int blue) {
            this.primaryColors.add((red << 16) + (green << 8) + blue);
            return this;
        }

        public Explosion addFadeColor(int red, int green, int blue) {
            this.fadeColors.add((red << 16) + (green << 8) + blue);
            return this;
        }

        public NBTTagCompound getTagCompound() {
            int var3;
            NBTTagCompound var1 = new NBTTagCompound();
            var1.func_74757_a("Flicker", this.twinkle);
            var1.func_74757_a("Trail", this.trail);
            var1.func_74774_a("Type", (byte)this.type.ordinal());
            int[] var2 = new int[this.primaryColors.size()];
            for (var3 = 0; var3 < this.primaryColors.size(); ++var3) {
                var2[var3] = this.primaryColors.get(var3);
            }
            var1.func_74783_a("Colors", var2);
            var2 = new int[this.fadeColors.size()];
            for (var3 = 0; var3 < this.fadeColors.size(); ++var3) {
                var2[var3] = this.fadeColors.get(var3);
            }
            var1.func_74783_a("FadeColors", var2);
            return var1;
        }

        public ItemStack getFireworkStarStack() {
            NBTTagCompound var1 = new NBTTagCompound();
            NBTTagCompound var2 = this.getTagCompound();
            var1.func_74782_a("Explosion", (NBTBase)var2);
            ItemStack var3 = new ItemStack(Items.field_151154_bQ);
            var3.func_77982_d(var1);
            return var3;
        }

        public static enum Type {
            BALL,
            LARGE_BALL,
            STAR,
            CREEPER,
            BURST;

        }
    }
}

