/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.yungnickyoung.minecraft.bettermineshafts.BetterMineshafts;
import com.yungnickyoung.minecraft.bettermineshafts.util.ColPos;
import com.yungnickyoung.minecraft.bettermineshafts.util.SurfaceUtil;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftGenerator;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.MineshaftVariantSettings;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.MineshaftPiece;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class VerticalEntrance
extends MineshaftPiece {
    private BlockPos centerPos;
    private int yAxisLen = 0;
    private int localYEnd = 0;
    private int tunnelLength = 0;
    private int tunnelFloorAltitude = 0;
    private EnumFacing tunnelEnumFacing = EnumFacing.NORTH;
    private boolean hasTunnel = false;

    public VerticalEntrance() {
    }

    public VerticalEntrance(int i, int pieceChainLen, Random random, BlockPos.MutableBlockPos centerPos, EnumFacing direction, MineshaftVariantSettings settings) {
        super(i, pieceChainLen, settings);
        this.func_186164_a(direction);
        this.centerPos = new BlockPos((Vec3i)centerPos);
        this.field_74887_e = VerticalEntrance.getInitialBoundingBox((BlockPos)centerPos);
    }

    @Override
    @ParametersAreNonnullByDefault
    protected void func_143012_a(NBTTagCompound tag) {
        super.func_143012_a(tag);
        tag.func_74783_a("centerPos", new int[]{this.centerPos.func_177958_n(), this.centerPos.func_177956_o(), this.centerPos.func_177952_p()});
        tag.func_74768_a("yAxisLen", this.yAxisLen);
        tag.func_74768_a("tunnelLen", this.tunnelLength);
        tag.func_74768_a("floorAltitude", this.tunnelFloorAltitude);
        tag.func_74768_a("tunnelDir", this.tunnelEnumFacing.func_176736_b());
        tag.func_74757_a("hasTunnel", this.hasTunnel);
    }

    @Override
    @ParametersAreNonnullByDefault
    protected void func_143011_b(NBTTagCompound tag, TemplateManager templateManager) {
        super.func_143011_b(tag, templateManager);
        int centerPosX = tag.func_74759_k("centerPos")[0];
        int centerPosY = tag.func_74759_k("centerPos")[1];
        int centerPosZ = tag.func_74759_k("centerPos")[2];
        this.centerPos = new BlockPos(centerPosX, centerPosY, centerPosZ);
        this.yAxisLen = tag.func_74762_e("yAxisLen");
        this.localYEnd = this.yAxisLen - 1;
        this.tunnelLength = tag.func_74762_e("tunnelLen");
        this.tunnelFloorAltitude = tag.func_74762_e("floorAltitude");
        int tunnelDirInt = tag.func_74762_e("tunnelDir");
        this.tunnelEnumFacing = tunnelDirInt == -1 ? null : EnumFacing.func_176731_b((int)tunnelDirInt);
        this.hasTunnel = tag.func_74767_n("hasTunnel");
    }

    private static StructureBoundingBox getInitialBoundingBox(BlockPos centerPos) {
        return new StructureBoundingBox(centerPos.func_177958_n() - 2, centerPos.func_177956_o(), centerPos.func_177952_p() - 2, centerPos.func_177958_n() + 12, 256, centerPos.func_177952_p() + 12);
    }

    @Override
    public void func_74861_a(StructureComponent structurePiece, List<StructureComponent> list, Random random) {
        EnumFacing direction = this.func_186165_e();
        if (direction == null) {
            return;
        }
        switch (direction) {
            default: {
                BetterMineshaftGenerator.generateAndAddBigTunnelPiece(structurePiece, list, random, this.centerPos.func_177958_n() - 4, this.centerPos.func_177956_o(), this.centerPos.func_177952_p() - 3, direction, this.func_74877_c(), this.pieceChainLen);
                break;
            }
            case SOUTH: {
                BetterMineshaftGenerator.generateAndAddBigTunnelPiece(structurePiece, list, random, this.centerPos.func_177958_n() + 4, this.centerPos.func_177956_o(), this.centerPos.func_177952_p() + 3, direction, this.func_74877_c(), this.pieceChainLen);
                break;
            }
            case WEST: {
                BetterMineshaftGenerator.generateAndAddBigTunnelPiece(structurePiece, list, random, this.centerPos.func_177958_n() - 3, this.centerPos.func_177956_o(), this.centerPos.func_177952_p() + 4, direction, this.func_74877_c(), this.pieceChainLen);
                break;
            }
            case EAST: {
                BetterMineshaftGenerator.generateAndAddBigTunnelPiece(structurePiece, list, random, this.centerPos.func_177958_n() + 3, this.centerPos.func_177956_o(), this.centerPos.func_177952_p() - 4, direction, this.func_74877_c(), this.pieceChainLen);
            }
        }
    }

    @ParametersAreNonnullByDefault
    public boolean func_74875_a(World world, Random random, StructureBoundingBox box) {
        if (!this.hasTunnel) {
            this.determineEnumFacing(world);
        }
        if (this.hasTunnel) {
            this.generateVerticalShaft(world, random, box);
            this.generateSurfaceTunnel(world, random, box);
            return true;
        }
        return false;
    }

    private void generateVerticalShaft(World world, Random random, StructureBoundingBox box) {
        int shaftStartX = 0;
        int shaftStartZ = 0;
        int shaftEndX = 4;
        int shaftEndZ = 4;
        EnumFacing facing = this.func_186165_e();
        if (facing == EnumFacing.NORTH || facing == EnumFacing.WEST) {
            shaftStartZ = 10;
            shaftEndZ = 14;
        }
        this.fill(world, box, random, shaftStartX, 0, shaftStartZ, shaftEndX, this.localYEnd, shaftEndZ, this.getMainSelector());
        this.fill(world, box, shaftStartX + 1, 1, shaftStartZ + 1, shaftEndX - 1, this.localYEnd - 1, shaftEndZ - 1, AIR);
        this.replaceAir(world, box, shaftStartX + 1, 0, shaftStartZ + 1, shaftEndX - 1, 0, shaftEndZ - 1, this.getMainBlock());
        this.replaceAir(world, box, shaftStartX + 2, 1, shaftStartZ, shaftStartX + 2, this.localYEnd - 4, shaftStartZ, this.getMainBlock());
        this.fill(world, box, shaftStartX + 2, 1, shaftStartZ + 1, shaftStartX + 2, this.localYEnd - 4, shaftStartZ + 1, Blocks.field_150468_ap.func_176223_P());
        this.fill(world, box, shaftStartX + 1, 1, shaftStartZ + 4, shaftStartX + 3, 2, shaftStartZ + 4, this.getMainDoorwayWall());
        this.fill(world, box, shaftStartX + 2, 3, shaftStartZ + 4, shaftStartX + 2, 3, shaftStartZ + 4, this.getMainDoorwaySlab());
        this.fill(world, box, shaftStartX + 2, 1, shaftStartZ + 4, shaftStartX + 2, 2, shaftStartZ + 4, AIR);
        this.addBiomeDecorations(world, box, random, shaftStartX + 1, 0, shaftStartZ + 1, shaftEndX - 1, 1, shaftEndZ - 1);
        this.addVines(world, box, random, shaftStartX + 1, 0, shaftStartZ + 1, shaftEndX - 1, this.localYEnd - 4, shaftEndZ - 1);
    }

    private void generateSurfaceTunnel(World world, Random random, StructureBoundingBox box) {
        int x;
        IBlockState floorBlock;
        int z;
        boolean[] validPositions;
        int tunnelStartX = 0;
        int tunnelStartZ = 0;
        int tunnelEndX = 0;
        int tunnelEndZ = 0;
        EnumFacing facing = this.func_186165_e();
        float rotationDifference = facing.func_185119_l() - this.tunnelEnumFacing.func_185119_l();
        EnumFacing relativeTunnelDir = EnumFacing.func_176733_a((double)(EnumFacing.NORTH.func_185119_l() - rotationDifference));
        if (relativeTunnelDir == EnumFacing.NORTH) {
            tunnelStartX = 0;
            tunnelStartZ = 4;
            tunnelEndX = 4;
            tunnelEndZ = 4 + this.tunnelLength;
        } else if (relativeTunnelDir == EnumFacing.WEST && facing != EnumFacing.SOUTH && facing != EnumFacing.WEST || relativeTunnelDir == EnumFacing.EAST && (facing == EnumFacing.SOUTH || facing == EnumFacing.WEST)) {
            tunnelStartX = 10 - this.tunnelLength;
            tunnelStartZ = 0;
            tunnelEndX = 10;
            tunnelEndZ = 4;
        } else if (relativeTunnelDir == EnumFacing.SOUTH) {
            tunnelStartX = 0;
            tunnelStartZ = 10 - this.tunnelLength;
            tunnelEndX = 4;
            tunnelEndZ = 10;
        } else if (relativeTunnelDir == EnumFacing.EAST || relativeTunnelDir == EnumFacing.WEST) {
            tunnelStartX = 4;
            tunnelStartZ = 0;
            tunnelEndX = 4 + this.tunnelLength;
            tunnelEndZ = 4;
            if (facing == EnumFacing.NORTH || facing == EnumFacing.WEST) {
                tunnelStartZ = 10;
                tunnelEndZ = 14;
            }
        }
        this.chanceReplaceNonAir(world, box, random, 0.6f, tunnelStartX, this.tunnelFloorAltitude, tunnelStartZ, tunnelEndX, this.tunnelFloorAltitude + 4, tunnelEndZ, this.getMainSelector());
        if (facing.func_176740_k() == this.tunnelEnumFacing.func_176740_k()) {
            this.replaceAir(world, box, tunnelStartX + 1, this.tunnelFloorAltitude, tunnelStartZ, tunnelEndX - 1, this.tunnelFloorAltitude, tunnelEndZ, this.getMainBlock());
            this.fill(world, box, tunnelStartX + 1, this.tunnelFloorAltitude + 1, tunnelStartZ, tunnelEndX - 1, this.tunnelFloorAltitude + 3, tunnelEndZ, AIR);
        } else {
            this.replaceAir(world, box, tunnelStartX, this.tunnelFloorAltitude, tunnelStartZ + 1, tunnelEndX, this.tunnelFloorAltitude, tunnelEndZ - 1, this.getMainBlock());
            this.fill(world, box, tunnelStartX, this.tunnelFloorAltitude + 1, tunnelStartZ + 1, tunnelEndX, this.tunnelFloorAltitude + 3, tunnelEndZ - 1, AIR);
        }
        this.addVines(world, box, random, tunnelStartX + 1, this.tunnelFloorAltitude, tunnelStartZ + 1, tunnelEndX - 1, this.tunnelFloorAltitude + 4, tunnelEndZ - 1);
        if (facing.func_176740_k() == this.tunnelEnumFacing.func_176740_k()) {
            validPositions = new boolean[tunnelEndZ - tunnelStartZ + 1];
            for (z = 0; z < validPositions.length; ++z) {
                floorBlock = this.func_175807_a(world, tunnelStartX + 2, this.tunnelFloorAltitude, tunnelStartZ + z, box);
                if (!floorBlock.func_185904_a().func_76220_a()) continue;
                validPositions[z] = true;
            }
        } else {
            validPositions = new boolean[tunnelEndX - tunnelStartX + 1];
            for (x = 0; x < validPositions.length; ++x) {
                floorBlock = this.func_175807_a(world, tunnelStartX + x, this.tunnelFloorAltitude, tunnelStartZ + 2, box);
                if (!floorBlock.func_185904_a().func_76220_a()) continue;
                validPositions[x] = true;
            }
        }
        if (facing.func_176740_k() == this.tunnelEnumFacing.func_176740_k()) {
            for (z = tunnelStartZ; z <= tunnelEndZ; ++z) {
                int r = random.nextInt(4);
                if (r != 0 || !validPositions[z - tunnelStartZ]) continue;
                this.fill(world, box, tunnelStartX + 1, this.tunnelFloorAltitude + 1, z, tunnelStartX + 1, this.tunnelFloorAltitude + 2, z, this.getSupportBlock());
                this.fill(world, box, tunnelStartX + 3, this.tunnelFloorAltitude + 1, z, tunnelStartX + 3, this.tunnelFloorAltitude + 2, z, this.getSupportBlock());
                this.fill(world, box, tunnelStartX + 1, this.tunnelFloorAltitude + 3, z, tunnelStartX + 3, this.tunnelFloorAltitude + 3, z, this.getMainBlock());
                this.chanceReplaceNonAir(world, box, random, 0.25f, tunnelStartX + 1, this.tunnelFloorAltitude + 3, z, tunnelStartX + 3, this.tunnelFloorAltitude + 3, z, this.getSupportBlock());
                this.chanceReplaceAir(world, box, random, 0.15f, tunnelStartX + 1, this.tunnelFloorAltitude + 3, z - 1, tunnelStartX + 1, this.tunnelFloorAltitude + 3, z + 1, Blocks.field_150321_G.func_176223_P());
                this.chanceReplaceAir(world, box, random, 0.15f, tunnelStartX + 3, this.tunnelFloorAltitude + 3, z - 1, tunnelStartX + 3, this.tunnelFloorAltitude + 3, z + 1, Blocks.field_150321_G.func_176223_P());
                z += 3;
            }
        } else {
            for (x = tunnelStartX; x <= tunnelEndX; ++x) {
                int r = random.nextInt(4);
                if (r != 0 || !validPositions[x - tunnelStartX]) continue;
                this.fill(world, box, x, this.tunnelFloorAltitude + 1, tunnelStartZ + 1, x, this.tunnelFloorAltitude + 2, tunnelStartZ + 1, this.getSupportBlock());
                this.fill(world, box, x, this.tunnelFloorAltitude + 1, tunnelStartZ + 3, x, this.tunnelFloorAltitude + 2, tunnelStartZ + 3, this.getSupportBlock());
                this.fill(world, box, x, this.tunnelFloorAltitude + 3, tunnelStartZ + 1, x, this.tunnelFloorAltitude + 3, tunnelStartZ + 3, this.getMainBlock());
                this.chanceReplaceNonAir(world, box, random, 0.25f, x, this.tunnelFloorAltitude + 3, tunnelStartZ + 1, x, this.tunnelFloorAltitude + 3, tunnelStartZ + 3, this.getSupportBlock());
                this.chanceReplaceAir(world, box, random, 0.15f, x - 1, this.tunnelFloorAltitude + 3, tunnelStartZ + 1, x + 1, this.tunnelFloorAltitude + 3, tunnelStartZ + 1, Blocks.field_150321_G.func_176223_P());
                this.chanceReplaceAir(world, box, random, 0.15f, x - 1, this.tunnelFloorAltitude + 3, tunnelStartZ + 3, x + 1, this.tunnelFloorAltitude + 3, tunnelStartZ + 3, Blocks.field_150321_G.func_176223_P());
                x += 3;
            }
        }
        if (facing.func_176740_k() == this.tunnelEnumFacing.func_176740_k()) {
            for (z = 0; z < tunnelEndZ - tunnelStartZ + 1; ++z) {
                if (!validPositions[z] || !(random.nextFloat() < 0.3f)) continue;
                this.fill(world, box, tunnelStartX + 2, this.tunnelFloorAltitude + 1, tunnelStartZ + z, tunnelStartX + 2, this.tunnelFloorAltitude + 1, tunnelStartZ + z + 1, Blocks.field_150448_aq.func_176223_P());
                ++z;
            }
        } else {
            for (x = 0; x < tunnelEndX - tunnelStartX + 1; ++x) {
                if (!validPositions[x] || !(random.nextFloat() < 0.3f)) continue;
                this.fill(world, box, tunnelStartX + x, this.tunnelFloorAltitude + 1, tunnelStartZ + 2, tunnelStartX + x + 1, this.tunnelFloorAltitude + 1, tunnelStartZ + 2, Blocks.field_150448_aq.func_176223_P());
                ++x;
            }
        }
    }

    private void determineEnumFacing(World world) {
        int minSurfaceHeight = 255;
        for (int xOffset = -2; xOffset <= 2; ++xOffset) {
            for (int zOffset = -2; zOffset <= 2; ++zOffset) {
                try {
                    int realX = this.centerPos.func_177958_n() + xOffset;
                    int realZ = this.centerPos.func_177952_p() + zOffset;
                    int surfaceHeight = SurfaceUtil.getSurfaceHeight(world, new ColPos(realX, realZ));
                    if (surfaceHeight <= 1) continue;
                    minSurfaceHeight = Math.min(minSurfaceHeight, surfaceHeight);
                    continue;
                }
                catch (NullPointerException e) {
                    BetterMineshafts.LOGGER.error("Unexpected YUNG's Better Mineshafts error. Please report this!");
                    BetterMineshafts.LOGGER.error(e.toString());
                    BetterMineshafts.LOGGER.error(e.getMessage());
                }
            }
        }
        if (minSurfaceHeight < 60 || minSurfaceHeight == 255) {
            return;
        }
        int ceilingHeight = minSurfaceHeight - 2;
        int floorHeight = ceilingHeight - 4;
        this.yAxisLen = ceilingHeight - this.centerPos.func_177956_o() + 1;
        this.localYEnd = this.yAxisLen - 1;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(this.centerPos);
        int radius = 5;
        int maxRadialDist = 2;
        for (int radialDist = 0; radialDist < maxRadialDist; ++radialDist) {
            for (EnumFacing direction : EnumFacing.values()) {
                if (direction != EnumFacing.EAST && direction != EnumFacing.SOUTH) continue;
                mutable.func_189533_g((Vec3i)this.centerPos.func_177967_a(direction, radius * radialDist + 2));
                for (int i = radialDist * radius; i < radialDist * radius + radius; ++i) {
                    int surfaceHeight = SurfaceUtil.getSurfaceHeight(world, new ColPos(mutable.func_177958_n(), mutable.func_177952_p()));
                    if (surfaceHeight <= floorHeight && surfaceHeight > 1) {
                        this.hasTunnel = true;
                        this.tunnelEnumFacing = direction;
                        this.tunnelFloorAltitude = ceilingHeight - 4 - this.field_74887_e.field_78895_b;
                        this.tunnelLength = i;
                        return;
                    }
                    mutable.func_189536_c(direction);
                }
            }
        }
    }
}

