/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.helpers;

import erogenousbeef.bigreactors.api.data.ReactorReaction;
import erogenousbeef.bigreactors.api.registry.Reactants;
import erogenousbeef.bigreactors.api.registry.ReactorConversions;
import erogenousbeef.bigreactors.common.BRLog;
import erogenousbeef.bigreactors.common.data.ReactantStack;
import erogenousbeef.bigreactors.common.multiblock.helpers.ReactantContainer;
import net.minecraft.nbt.NBTTagCompound;

public class FuelContainer
extends ReactantContainer {
    private static final String[] tankNames = new String[]{"fuel", "waste"};
    private static final int FUEL = 0;
    private static final int WASTE = 1;
    private float radiationFuelUsage = 0.0f;

    public FuelContainer() {
        super(tankNames, 0);
    }

    public int getFuelAmount() {
        return this.getReactantAmount(0);
    }

    public int getWasteAmount() {
        return this.getReactantAmount(1);
    }

    @Override
    public boolean isReactantValidForStack(int idx, String name) {
        switch (idx) {
            case 0: {
                return Reactants.isFuel(name);
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    public int addFuel(String name, int amount, boolean doAdd) {
        if (name == null || amount <= 0) {
            return 0;
        }
        return this.fill(0, name, amount, doAdd);
    }

    public int addWaste(String name, int amount) {
        int wasteAdded = this.fill(1, name, amount, true);
        return wasteAdded;
    }

    private int addWaste(int wasteAmt) {
        if (this.getWasteType() == null) {
            BRLog.warning("System is using addWaste(int) when there's no waste present, defaulting to cyanite", new Object[0]);
            return this.fill(1, "cyanite", wasteAmt, true);
        }
        return this.addToStack(1, wasteAmt);
    }

    public int dumpFuel() {
        return this.dump(0);
    }

    public int dumpFuel(int amount) {
        return this.dump(0, amount);
    }

    public int dumpWaste() {
        return this.dump(1);
    }

    public int dumpWaste(int amount) {
        return this.dump(1, amount);
    }

    public String getFuelType() {
        return this.getReactantType(0);
    }

    public String getWasteType() {
        return this.getReactantType(1);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound destination) {
        super.writeToNBT(destination);
        destination.func_74776_a("fuelUsage", this.radiationFuelUsage);
        return destination;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74764_b("fuelUsage")) {
            this.radiationFuelUsage = data.func_74760_g("fuelUsage");
        }
    }

    public void emptyFuel() {
        this.setReactant(0, null);
    }

    public void emptyWaste() {
        this.setReactant(1, null);
    }

    public void setFuel(ReactantStack newFuel) {
        this.setReactant(0, newFuel);
    }

    public void setWaste(ReactantStack newWaste) {
        this.setReactant(1, newWaste);
    }

    public void merge(FuelContainer other) {
        this.radiationFuelUsage = Math.max(this.radiationFuelUsage, other.radiationFuelUsage);
        super.merge(other);
    }

    public void onRadiationUsesFuel(float fuelUsed) {
        if (Float.isInfinite(fuelUsed) || Float.isNaN(fuelUsed)) {
            return;
        }
        this.radiationFuelUsage += fuelUsed;
        if (this.radiationFuelUsage < 1.0f) {
            return;
        }
        int fuelToConvert = Math.min(this.getFuelAmount(), (int)this.radiationFuelUsage);
        if (fuelToConvert <= 0) {
            return;
        }
        this.radiationFuelUsage = Math.max(0.0f, this.radiationFuelUsage - (float)fuelToConvert);
        String fuelType = this.getFuelType();
        if (fuelType != null) {
            this.dumpFuel(fuelToConvert);
            if (this.getWasteType() != null) {
                this.addWaste(fuelToConvert);
            } else {
                String wasteType;
                ReactorReaction reaction = ReactorConversions.get(fuelType);
                String string = wasteType = reaction == null ? null : reaction.getProduct();
                if (wasteType == null) {
                    BRLog.warning("Could not locate waste for reaction of fuel type " + fuelType + "; using cyanite", new Object[0]);
                    wasteType = "cyanite";
                }
                this.addWaste(wasteType, fuelToConvert);
            }
        } else {
            BRLog.warning("Attempting to use %d fuel and there's no fuel in the tank", fuelToConvert);
        }
    }

    public float getFuelReactivity() {
        String reactant = this.getFuelType();
        ReactorReaction reaction = ReactorConversions.get(reactant);
        if (reaction == null) {
            BRLog.warning("Could not locate reaction data for reactant type " + reactant + "; using default value for reactivity", new Object[0]);
            return 1.05f;
        }
        return reaction.getReactivity();
    }
}

