/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.kleeslabs;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.blay09.mods.kleeslabs.KleeSlabs;
import net.blay09.mods.kleeslabs.converter.SlabConverter;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.io.FilenameUtils;

@Mod.EventBusSubscriber
public class JsonCompatLoader {
    private static final Gson gson = new Gson();
    private static final NonNullList<ItemStack> nonFoodRecipes = NonNullList.func_191196_a();
    private static final JsonObject EMPTY_OBJECT = new JsonObject();
    private static final JsonArray EMPTY_ARRAY = new JsonArray();

    public static boolean loadCompat() {
        nonFoodRecipes.clear();
        ModContainer mod = (ModContainer)Loader.instance().getIndexedModList().get("kleeslabs");
        return JsonCompatLoader.findConfigFiles() && CraftingHelper.findFiles((ModContainer)mod, (String)"assets/kleeslabs/compat", root -> true, (root, file) -> {
            String relative = root.relativize((Path)file).toString();
            if (!"json".equals(FilenameUtils.getExtension((String)file.toString())) || relative.startsWith("_")) {
                return true;
            }
            String fileName = FilenameUtils.removeExtension((String)relative).replaceAll("\\\\", "/");
            try (BufferedReader reader = Files.newBufferedReader(file);){
                JsonCompatLoader.parse(reader);
            }
            catch (JsonParseException e) {
                KleeSlabs.logger.error("Parsing error loading compat {}", (Object)fileName, (Object)e);
                return false;
            }
            catch (IOException e) {
                KleeSlabs.logger.error("Couldn't read compat {}", (Object)fileName, (Object)e);
                return false;
            }
            return true;
        }, (boolean)true, (boolean)true);
    }

    private static boolean findConfigFiles() {
        File compatDir = new File(KleeSlabs.configDir, "KleeSlabsCompat");
        if (!compatDir.exists()) {
            KleeSlabs.logger.info("If you wish to setup additional KleeSlabs compatibility, create a folder called 'KleeSlabsCompat' in your config directory and place JSON files inside.");
            return true;
        }
        Path path = compatDir.toPath();
        try {
            Files.walk(path, new FileVisitOption[0]).filter(it -> it.toString().endsWith(".json")).forEach(it -> {
                try (BufferedReader reader = Files.newBufferedReader(it);){
                    JsonCompatLoader.parse(reader);
                }
                catch (IOException e) {
                    KleeSlabs.logger.error("Couldn't read compat {}", it, (Object)e);
                }
            });
        }
        catch (IOException e) {
            KleeSlabs.logger.error("Couldn't walk compat dir", (Throwable)e);
            return false;
        }
        return true;
    }

    public static void parse(String json) {
        JsonCompatLoader.parse((JsonObject)gson.fromJson(json, JsonObject.class));
    }

    public static void parse(Reader reader) {
        JsonObject json = (JsonObject)JsonUtils.func_193839_a((Gson)gson, (Reader)reader, JsonObject.class);
        if (json != null) {
            JsonCompatLoader.parse(json);
        }
    }

    private static void parse(JsonObject root) {
        Class<?> converterClass;
        String modId = JsonUtils.func_151200_h((JsonObject)root, (String)"modid");
        if (!modId.equals("minecraft") && !Loader.isModLoaded((String)modId) && KleeSlabs.config.getBoolean(modId, "compat", true, "")) {
            return;
        }
        boolean isSilent = JsonUtils.func_151209_a((JsonObject)root, (String)"silent", (boolean)false);
        String converterName = JsonUtils.func_151200_h((JsonObject)root, (String)"converter");
        try {
            converterClass = Class.forName("net.blay09.mods.kleeslabs.converter." + converterName);
        }
        catch (ClassNotFoundException ignored) {
            try {
                converterClass = Class.forName(converterName);
            }
            catch (ClassNotFoundException e) {
                KleeSlabs.logger.error("Slab converter class was not found: {}", (Object)converterName);
                return;
            }
        }
        if (!SlabConverter.class.isAssignableFrom(converterClass)) {
            KleeSlabs.logger.error("Slab converter class was not found: {}", (Object)converterName);
            return;
        }
        JsonArray slabs = JsonUtils.func_151213_a((JsonObject)root, (String)"slabs", (JsonArray)EMPTY_ARRAY);
        for (Object element : slabs) {
            String slabName = element.getAsString();
            Block slab = JsonCompatLoader.parseBlock(modId, slabName);
            if (slab != Blocks.field_150350_a) {
                JsonCompatLoader.registerSlab(converterClass, slab, slab);
                continue;
            }
            if (isSilent) continue;
            KleeSlabs.logger.error("Slab {} could not be found.", (Object)slabName);
        }
        JsonObject mappedSlabs = JsonUtils.func_151218_a((JsonObject)root, (String)"mapped_slabs", (JsonObject)EMPTY_OBJECT);
        for (Map.Entry entry : mappedSlabs.entrySet()) {
            String singleSlabName = (String)entry.getKey();
            Block singleSlab = JsonCompatLoader.parseBlock(modId, singleSlabName);
            if (singleSlab == Blocks.field_150350_a) {
                KleeSlabs.logger.error("Slab {} could not be found.", (Object)singleSlabName);
                continue;
            }
            String doubleSlabName = ((JsonElement)entry.getValue()).getAsString();
            Block doubleSlab = JsonCompatLoader.parseBlock(modId, doubleSlabName);
            if (doubleSlab == Blocks.field_150350_a) {
                KleeSlabs.logger.error("Slab {} could not be found.", (Object)doubleSlabName);
                continue;
            }
            JsonCompatLoader.registerSlab(converterClass, singleSlab, doubleSlab);
        }
        Pattern patternSearch = Pattern.compile(JsonUtils.func_151219_a((JsonObject)root, (String)"pattern_search", (String)".+"));
        Matcher matcherSearch = patternSearch.matcher("");
        String patternReplace = JsonUtils.func_151219_a((JsonObject)root, (String)"pattern_replace", (String)"$0_double");
        JsonArray patternSlabs = JsonUtils.func_151213_a((JsonObject)root, (String)"pattern_slabs", (JsonArray)EMPTY_ARRAY);
        for (JsonElement element : patternSlabs) {
            String singleSlabName = element.getAsString();
            matcherSearch.reset(singleSlabName);
            String doubleSlabName = matcherSearch.replaceFirst(patternReplace);
            Block singleSlab = JsonCompatLoader.parseBlock(modId, singleSlabName);
            if (singleSlab == Blocks.field_150350_a) {
                KleeSlabs.logger.error("Slab {} could not be found.", (Object)singleSlabName);
                continue;
            }
            Block doubleSlab = JsonCompatLoader.parseBlock(modId, doubleSlabName);
            if (doubleSlab == Blocks.field_150350_a) {
                KleeSlabs.logger.error("Slab {} could not be found.", (Object)doubleSlabName);
                continue;
            }
            JsonCompatLoader.registerSlab(converterClass, singleSlab, doubleSlab);
        }
    }

    private static void registerSlab(Class<?> converterClass, Block singleSlab, Block doubleSlab) {
        try {
            Constructor<?> constructor = converterClass.getConstructor(Block.class);
            SlabConverter converter = (SlabConverter)constructor.newInstance(singleSlab);
            KleeSlabs.registerSlabConverter(doubleSlab, converter);
        }
        catch (NoSuchMethodException e) {
            KleeSlabs.logger.error("Slab converter class does not have a constructor that takes a Block argument: {}", converterClass);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            KleeSlabs.logger.error("Slab converter class constructor invocation failed: {}", converterClass, (Object)e);
        }
    }

    private static Block parseBlock(String modId, String name) {
        int colon = name.indexOf(58);
        if (colon != -1) {
            modId = name.substring(0, colon);
            name = name.substring(colon + 1);
        }
        return (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(modId, name));
    }
}

