/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.page;

import com.google.gson.annotations.SerializedName;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.page.abstr.PageWithText;
import vazkii.patchouli.common.util.EntityUtil;

public class PageEntity
extends PageWithText {
    @SerializedName(value="entity")
    public String entityId;
    float scale = 1.0f;
    @SerializedName(value="offset")
    float extraOffset = 0.0f;
    String name;
    boolean rotate = true;
    @SerializedName(value="default_rotation")
    float defaultRotation = -45.0f;
    transient boolean errored;
    transient Entity entity;
    transient EntityUtil.EntityCreator creator;
    transient float renderScale;
    transient float offset;

    @Override
    public void build(BookEntry entry, int pageNum) {
        super.build(entry, pageNum);
        this.creator = EntityUtil.loadEntity(this.entityId);
    }

    @Override
    public void onDisplayed(GuiBookEntry parent, int left, int top) {
        super.onDisplayed(parent, left, top);
        this.loadEntity((World)parent.field_146297_k.field_71441_e);
    }

    @Override
    public int getTextHeight() {
        return 115;
    }

    @Override
    public void render(int mouseX, int mouseY, float pticks) {
        int x = 5;
        int y = 7;
        GlStateManager.func_179147_l();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GuiBook.drawFromTexture(this.book, x, y, 405, 149, 106, 106);
        this.parent.drawCenteredStringNoShadow(this.name, 58, 0, this.book.headerColor);
        if (this.errored) {
            this.fontRenderer.func_175063_a(I18n.func_135052_a((String)"patchouli.gui.lexicon.loading_error", (Object[])new Object[0]), 58.0f, 60.0f, 0xFF0000);
        }
        if (this.entity != null) {
            this.renderEntity((World)this.parent.field_146297_k.field_71441_e, this.rotate ? ClientTicker.total : this.defaultRotation);
        }
        super.render(mouseX, mouseY, pticks);
    }

    private void renderEntity(World world, float rotation) {
        PageEntity.renderEntity(this.entity, world, 58.0f, 60.0f, rotation, this.renderScale, this.offset);
    }

    public static void renderEntity(Entity entity, World world, float x, float y, float rotation, float renderScale, float offset) {
        entity.field_70170_p = world;
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)x, (float)y, (float)50.0f);
        GlStateManager.func_179152_a((float)(-renderScale), (float)renderScale, (float)renderScale);
        GlStateManager.func_179109_b((float)0.0f, (float)offset, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        Minecraft.func_71410_x().func_175598_ae().field_78735_i = 180.0f;
        Minecraft.func_71410_x().func_175598_ae().func_188391_a(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    private void loadEntity(World world) {
        if (!this.errored && (this.entity == null || this.entity.field_70128_L)) {
            try {
                this.entity = this.creator.create(world);
                float entitySize = this.entity.field_70130_N;
                if (this.entity.field_70130_N < this.entity.field_70131_O) {
                    entitySize = this.entity.field_70131_O;
                }
                entitySize = Math.max(1.0f, entitySize);
                this.renderScale = 100.0f / entitySize * 0.8f * this.scale;
                this.offset = Math.max(this.entity.field_70131_O, entitySize) * 0.5f + this.extraOffset;
                if (this.name == null || this.name.isEmpty()) {
                    this.name = this.entity.func_70005_c_();
                }
            }
            catch (Exception e) {
                this.errored = true;
                e.printStackTrace();
            }
        }
    }
}

