/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.init;

import cofh.cofhworld.CoFHWorld;
import cofh.cofhworld.init.FeatureParser;
import cofh.cofhworld.parser.distribution.DistParserCave;
import cofh.cofhworld.parser.distribution.DistParserCustom;
import cofh.cofhworld.parser.distribution.DistParserDecoration;
import cofh.cofhworld.parser.distribution.DistParserFractal;
import cofh.cofhworld.parser.distribution.DistParserGaussian;
import cofh.cofhworld.parser.distribution.DistParserReplace;
import cofh.cofhworld.parser.distribution.DistParserSequential;
import cofh.cofhworld.parser.distribution.DistParserSurface;
import cofh.cofhworld.parser.distribution.DistParserUnderfluid;
import cofh.cofhworld.parser.distribution.DistParserUniform;
import cofh.cofhworld.parser.generator.GenParserBoulder;
import cofh.cofhworld.parser.generator.GenParserCluster;
import cofh.cofhworld.parser.generator.GenParserConsecutive;
import cofh.cofhworld.parser.generator.GenParserDecoration;
import cofh.cofhworld.parser.generator.GenParserDungeon;
import cofh.cofhworld.parser.generator.GenParserGeode;
import cofh.cofhworld.parser.generator.GenParserLake;
import cofh.cofhworld.parser.generator.GenParserLargeVein;
import cofh.cofhworld.parser.generator.GenParserPlate;
import cofh.cofhworld.parser.generator.GenParserSequential;
import cofh.cofhworld.parser.generator.GenParserSmallTree;
import cofh.cofhworld.parser.generator.GenParserSpike;
import cofh.cofhworld.parser.generator.GenParserSpout;
import cofh.cofhworld.parser.generator.GenParserStalagmite;
import cofh.cofhworld.parser.generator.GenParserStructure;
import cofh.cofhworld.util.Utils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;

public class WorldProps {
    public static File configDir;
    public static Path worldGenPath;
    public static File worldGenDir;
    public static String cannonicalWorldGenDir;
    public static File standardGenFile;
    public static final String FILE_GEN_STANDARD_INTERNAL = "00_minecraft.json";
    public static final String PATH_GEN_STANDARD_INTERNAL = "assets/cofhworld/world/00_minecraft.json";
    public static boolean disableFeatureGeneration;
    public static boolean replaceStandardGeneration;
    public static boolean enableRetroactiveGeneration;
    public static boolean enableFlatBedrock;
    public static boolean enableRetroactiveFlatBedrock;
    public static boolean forceFullRegeneration;
    public static int chanceTreeGrowth;
    public static int numBedrockLayers;
    public static int maxBedrockLayers;

    private WorldProps() {
    }

    public static void preInit() {
        WorldProps.config();
        WorldProps.initFeatures();
    }

    private static void config() {
        String category = "World";
        String comment = "If TRUE, CoFH World will not generate features at all. This option is intended for use when you want another mod to handle ore generation but do not want to blank out the various .json files yourself. Flat Bedrock may still be used.";
        disableFeatureGeneration = CoFHWorld.config.getBoolean("DisableAllGeneration", category, disableFeatureGeneration, comment);
        comment = "If TRUE, standard Minecraft ore generation will be REPLACED. Configure in the 00_minecraft.json file; standard Minecraft defaults have been provided. If you rename the 00_minecraft.json file, this option WILL NOT WORK.";
        replaceStandardGeneration = CoFHWorld.config.getBoolean("ReplaceStandardGeneration", category, replaceStandardGeneration, comment);
        comment = "If TRUE, world generation handled by CoFH World will be retroactively applied to existing chunks.";
        enableRetroactiveGeneration = CoFHWorld.config.getBoolean("RetroactiveGeneration", category, enableRetroactiveGeneration, comment);
        comment = "This adjusts the % chance that a tree will grow as normal when it is meant to. Reducing this value will mean that trees take longer to grow, on average.";
        chanceTreeGrowth = CoFHWorld.config.getInt("TreeGrowthChance", category, chanceTreeGrowth, 1, 100, comment);
        category = "World.Bedrock";
        comment = "If TRUE, the bedrock layer will be flattened.";
        enableFlatBedrock = CoFHWorld.config.getBoolean("EnableFlatBedrock", category, enableFlatBedrock, comment);
        comment = "This adjusts the number of layers of Flat Bedrock, if enabled.";
        numBedrockLayers = CoFHWorld.config.getInt("NumBedrockLayers", category, 2, 1, maxBedrockLayers, comment);
        comment = "If TRUE, Flat Bedrock will retroactively be applied to existing chunks, if retroactive generation is enabled.";
        enableRetroactiveFlatBedrock = CoFHWorld.config.getBoolean("EnableRetroactiveFlatBedrock", category, enableRetroactiveFlatBedrock, comment);
    }

    private static void initFeatures() {
        CoFHWorld.log.info("Registering default Feature Templates...");
        FeatureParser.registerTemplate("gaussian", new DistParserGaussian());
        FeatureParser.registerTemplate("uniform", new DistParserUniform());
        FeatureParser.registerTemplate("surface", new DistParserSurface());
        FeatureParser.registerTemplate("fractal", new DistParserFractal());
        FeatureParser.registerTemplate("decoration", new DistParserDecoration());
        FeatureParser.registerTemplate("underwater", new DistParserUnderfluid(true));
        FeatureParser.registerTemplate("underfluid", new DistParserUnderfluid(false));
        FeatureParser.registerTemplate("cave", new DistParserCave());
        FeatureParser.registerTemplate("sequential", new DistParserSequential());
        FeatureParser.registerTemplate("custom", new DistParserCustom());
        FeatureParser.registerTemplate("replace", new DistParserReplace());
        CoFHWorld.log.info("Registering default World Generators...");
        FeatureParser.registerGenerator(null, new GenParserCluster(false));
        FeatureParser.registerGenerator("", new GenParserCluster(false));
        FeatureParser.registerGenerator("cluster", new GenParserCluster(false));
        FeatureParser.registerGenerator("sparse-cluster", new GenParserCluster(true));
        FeatureParser.registerGenerator("large-vein", new GenParserLargeVein());
        FeatureParser.registerGenerator("decoration", new GenParserDecoration());
        FeatureParser.registerGenerator("lake", new GenParserLake());
        FeatureParser.registerGenerator("plate", new GenParserPlate());
        FeatureParser.registerGenerator("geode", new GenParserGeode());
        FeatureParser.registerGenerator("spike", new GenParserSpike());
        FeatureParser.registerGenerator("boulder", new GenParserBoulder());
        FeatureParser.registerGenerator("dungeon", new GenParserDungeon());
        FeatureParser.registerGenerator("stalagmite", new GenParserStalagmite(false));
        FeatureParser.registerGenerator("stalactite", new GenParserStalagmite(true));
        FeatureParser.registerGenerator("small-tree", new GenParserSmallTree());
        FeatureParser.registerGenerator("spout", new GenParserSpout());
        FeatureParser.registerGenerator("structure", new GenParserStructure());
        FeatureParser.registerGenerator("sequential", new GenParserSequential());
        FeatureParser.registerGenerator("consecutive", new GenParserConsecutive());
        CoFHWorld.log.info("Verifying or creating base world generation directory...");
        worldGenDir = new File(configDir, "/cofh/world/");
        worldGenPath = Paths.get(configDir.getPath(), new String[0]);
        try {
            cannonicalWorldGenDir = worldGenDir.getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (!worldGenDir.exists()) {
            try {
                if (!worldGenDir.mkdir()) {
                    throw new Error("Could not create directory (unspecified error).");
                }
                CoFHWorld.log.info("Created world generation directory.");
            }
            catch (Throwable t) {
                CoFHWorld.log.fatal("Could not create world generation directory:", t);
                return;
            }
        }
        standardGenFile = new File(worldGenDir, FILE_GEN_STANDARD_INTERNAL);
        try {
            if (standardGenFile.createNewFile()) {
                Utils.copyFileUsingStream(PATH_GEN_STANDARD_INTERNAL, standardGenFile);
                CoFHWorld.log.info("Created standard generation json.");
            } else if (!standardGenFile.exists()) {
                throw new Error("Unable to create standard generation json (unspecified error).");
            }
        }
        catch (Throwable t) {
            replaceStandardGeneration = false;
            CoFHWorld.log.error("Could not create standard generation json.", t);
        }
        CoFHWorld.log.info("Complete.");
    }

    static {
        disableFeatureGeneration = false;
        replaceStandardGeneration = false;
        enableRetroactiveGeneration = false;
        enableFlatBedrock = false;
        enableRetroactiveFlatBedrock = false;
        forceFullRegeneration = false;
        chanceTreeGrowth = 100;
        numBedrockLayers = 1;
        maxBedrockLayers = 8;
    }
}

