/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.toolleveling.capability;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.toolleveling.TinkerToolLeveling;
import slimeknights.toolleveling.capability.CapabilityDamageXp;
import slimeknights.toolleveling.capability.IDamageXp;

public class DamageXpHandler
implements IDamageXp,
ICapabilitySerializable<NBTTagList> {
    private static String TAG_PLAYER_UUID = "player_uuid";
    private static String TAG_DAMAGE_LIST = "damage_data";
    private static String TAG_ITEM = "item";
    private static String TAG_DAMAGE = "damage";
    private Map<UUID, Map<ItemStack, Float>> playerToDamageMap = new HashMap<UUID, Map<ItemStack, Float>>();

    @Override
    public void addDamageFromTool(float damage, ItemStack tool, EntityPlayer player) {
        Map damageMap = this.playerToDamageMap.getOrDefault(player.func_110124_au(), new HashMap());
        damageMap.put(tool, Float.valueOf(damage += this.getDamageDealtByTool(tool, player)));
        this.playerToDamageMap.put(player.func_110124_au(), damageMap);
    }

    @Override
    public float getDamageDealtByTool(ItemStack tool, EntityPlayer player) {
        Map damageMap = this.playerToDamageMap.getOrDefault(player.func_110124_au(), new HashMap());
        return damageMap.entrySet().stream().filter(itemStackFloatEntry -> ToolCore.isEqualTinkersItem((ItemStack)tool, (ItemStack)((ItemStack)itemStackFloatEntry.getKey()))).findFirst().map(Map.Entry::getValue).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public void distributeXpToTools(EntityLivingBase deadEntity) {
        this.playerToDamageMap.forEach((uuid, itemStackFloatMap) -> this.distributeXpForPlayer(deadEntity.func_130014_f_(), (UUID)uuid, (Map<ItemStack, Float>)itemStackFloatMap));
    }

    private void distributeXpForPlayer(World world, UUID playerUuid, Map<ItemStack, Float> damageMap) {
        Optional.ofNullable(world.func_152378_a(playerUuid)).ifPresent(player -> damageMap.forEach((itemStack, damage) -> this.distributeXpToPlayerForTool((EntityPlayer)player, (ItemStack)itemStack, damage.floatValue())));
    }

    private void distributeXpToPlayerForTool(EntityPlayer player, ItemStack tool, float damage) {
        if (!tool.func_190926_b() && player.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            int i;
            IItemHandler itemHandler = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            for (i = 0; i < itemHandler.getSlots(); ++i) {
                if (itemHandler.getStackInSlot(i) != tool) continue;
                TinkerToolLeveling.modToolLeveling.addXp(tool, Math.round(damage), player);
                return;
            }
            for (i = 0; i < itemHandler.getSlots(); ++i) {
                if (!ToolCore.isEqualTinkersItem((ItemStack)itemHandler.getStackInSlot(i), (ItemStack)tool)) continue;
                TinkerToolLeveling.modToolLeveling.addXp(itemHandler.getStackInSlot(i), Math.round(damage), player);
                return;
            }
        }
    }

    public NBTTagList serializeNBT() {
        NBTTagList playerList = new NBTTagList();
        this.playerToDamageMap.forEach((uuid, itemStackFloatMap) -> playerList.func_74742_a((NBTBase)this.convertPlayerDataToTag((UUID)uuid, (Map<ItemStack, Float>)itemStackFloatMap)));
        return playerList;
    }

    private NBTTagCompound convertPlayerDataToTag(UUID uuid, Map<ItemStack, Float> itemStackFloatMap) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_186854_a(TAG_PLAYER_UUID, uuid);
        NBTTagList damageTag = new NBTTagList();
        itemStackFloatMap.forEach((itemStack, damage) -> damageTag.func_74742_a((NBTBase)this.convertItemDamageDataToTag((ItemStack)itemStack, (Float)damage)));
        tag.func_74782_a(TAG_DAMAGE_LIST, (NBTBase)damageTag);
        return tag;
    }

    private NBTTagCompound convertItemDamageDataToTag(ItemStack stack, Float damage) {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound itemTag = stack.func_77955_b(new NBTTagCompound());
        tag.func_74782_a(TAG_ITEM, (NBTBase)itemTag.func_74737_b());
        tag.func_74776_a(TAG_DAMAGE, damage.floatValue());
        return tag;
    }

    public void deserializeNBT(NBTTagList nbt) {
        this.playerToDamageMap = new HashMap<UUID, Map<ItemStack, Float>>();
        for (int i = 0; i < nbt.func_74745_c(); ++i) {
            NBTTagCompound tag = nbt.func_150305_b(i);
            UUID playerUuid = tag.func_186857_a(TAG_PLAYER_UUID);
            NBTTagList data = tag.func_150295_c(TAG_DAMAGE_LIST, 10);
            HashMap<ItemStack, Float> damageMap = new HashMap<ItemStack, Float>();
            for (int j = 0; j < data.func_74745_c(); ++j) {
                this.deserializeTagToMapEntry(damageMap, data.func_150305_b(j));
            }
            this.playerToDamageMap.put(playerUuid, damageMap);
        }
    }

    private void deserializeTagToMapEntry(Map<ItemStack, Float> damageMap, NBTTagCompound tag) {
        ItemStack stack = new ItemStack(tag.func_74775_l(TAG_ITEM));
        if (!stack.func_190926_b()) {
            damageMap.put(stack, Float.valueOf(tag.func_74760_g(TAG_DAMAGE)));
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityDamageXp.CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityDamageXp.CAPABILITY) {
            return (T)this;
        }
        return null;
    }
}

