/*
 * Decompiled with CFR 0.152.
 */
package de.impelon.disenchanter;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="disenchanter", category="")
public class DisenchanterConfig {
    @Config.Name(value="experience_jar")
    public static final ExperienceJarSection experienceJar = new ExperienceJarSection();
    @Config.RequiresMcRestart
    @Config.Name(value="crafting")
    public static final CraftingSection crafting = new CraftingSection();
    @Config.Name(value="disenchanting")
    public static final DisenchantingSection disenchanting = new DisenchantingSection();
    @Config.Name(value="visual")
    public static final VisualSection visual = new VisualSection();

    @Mod.EventBusSubscriber
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("disenchanter")) {
                ConfigManager.sync((String)"disenchanter", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class VisualSection {
        @Config.Name(value="BookRendererYOffset")
        @Config.Comment(value={"How should the book be positioned above the disenchantment table compared to the regular enchanting table?", "0.0 is the same as the enchanting table."})
        public double bookRendererYOffset = 0.4;
        @Config.Name(value="BookRendererFlipped")
        @Config.Comment(value={"Should the book above the disenchantment table be flipped upside-down?"})
        public boolean bookRendererFlipped = true;
        @Config.Name(value="BookRendererHidden")
        @Config.Comment(value={"Should the book above the disenchantment table be completely hidden?"})
        public boolean bookRendererHidden = false;
        @Config.Name(value="ShowUpgradesInGUI")
        @Config.Comment(value={"Should the different upgrades of a disenchantment table be listed when viewing the GUI of said table?"})
        public boolean showUpgradesInGUI = true;
        @Config.Name(value="DescriptionInGUIColor")
        @Config.Comment(value={"What color should be used for additional descriptions (f.e. list of table upgrades) shown in the GUI of a disenchantment table?"})
        public int descriptionInGUIColor = 0xAAAAAA;
    }

    public static class DisenchantingSection {
        @Config.Name(value="FlatDamage")
        @Config.Comment(value={"How much flat damage should be dealt to items when disenchanting?"})
        public int flatDamage = 10;
        @Config.Name(value="MaxDurabilityDamage")
        @Config.Comment(value={"How much of the item's maximum durability should be dealt as damage to items when disenchanting?"})
        public double maxDurabilityDamage = 0.025;
        @Config.Name(value="MaxDurabilityDamageReducible")
        @Config.Comment(value={"How much of the item's maximum durability should be dealt as reducible damage to items when disenchanting?", "This can be reduced by surrounding the disenchantment table with blocks that increase the enchanting level for the enchanting table (e.g. bookshelves)."})
        public double maxDurabilityDamageReducible = 0.2;
        @Config.Name(value="MachineDamageMultiplier")
        @Config.Comment(value={"By how much should the damage be multiplied when using an automatic disenchantment table?"})
        public double machineDamageMultiplier = 2.5;
        @Config.Name(value="EnchantmentLossChance")
        @Config.Comment(value={"What should the probability be that an enchantment is lost when disenchanting?"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double enchantmentLossChance = 0.0;
        @Config.Name(value="RepairCostMultiplier")
        @Config.Comment(value={"By how much should the repair cost of the item (f.e. used by anvils) be multiplied when disenchanting?", "0.5 is halving the repair cost (using an anvil doubles the repair cost); 1.0 leaves the cost unchanged."})
        @Config.RangeDouble(min=0.0)
        public double repairCostMultiplier = 0.5;
        @Config.Name(value="FlatExperience")
        @Config.Comment(value={"When converting an enchantment to XP, a flat amount of experience points will be added.", "What should that amount be?"})
        public int flatExperience = 0;
        @Config.Name(value="MinEnchantabilityExperience")
        @Config.Comment(value={"When converting an enchantment to XP, experience points relative to the enchantment's minimum enchantability will be added.", "What percentage of the enchantability should be used?"})
        public double minEnchantabilityExperience = 0.33;
        @Config.Name(value="MaxEnchantabilityExperience")
        @Config.Comment(value={"When converting an enchantment to XP, experience points relative to the enchantment's maximum enchantability will be added.", "What percentage of the enchantability should be used?"})
        public double maxEnchantabilityExperience = 0.15;
        @Config.Name(value="AutomaticDisenchantingProcessTicks")
        @Config.Comment(value={"How many ticks should the disenchanting process last when using an automatic disenchantment table?"})
        @Config.RangeInt(min=1)
        public int ticksAutomaticDisenchantingProcess = 100;
        @Config.Name(value="CyclingDisenchantingTicks")
        @Config.Comment(value={"How many ticks should the cycling disenchantment table wait before switching to a new enchantment?"})
        @Config.RangeInt(min=1)
        public int ticksCyclingDisenchanting = 60;
        @Config.Name(value="DisabledItems")
        @Config.Comment(value={"Which items should not be disenchantable?", "Entries are of the format `modid:itemid`; for example minecraft:dirt", "Java Regex can be used with a `[r]`-prefix; for example [r]minecraft:.* to ban all vanilla items."})
        public String[] disabledItems = new String[0];
        @Config.Name(value="DisabledEnchantments")
        @Config.Comment(value={"Which enchantments should be ignored when disenchanting?", "Entries are of the format `modid:enchantid`; for example minecraft:bane_of_arthropods", "Java Regex can be used with a `[r]`-prefix; for example [r]minecraft:.* to ban all vanilla enchantments."})
        public String[] disabledEnchantments = new String[0];
        @Config.Name(value="DisableCurses")
        @Config.Comment(value={"Should curse-enchantments -like curse of vanishing- be ignored when disenchanting?"})
        public boolean disableCurses = false;
        @Config.Name(value="EnableTCBehaviour")
        @Config.Comment(value={"Should items from Tinkers Construct be handled differently?", "Enchantments will not be able to be removed from these items."})
        public boolean enableTCBehaviour = true;
    }

    public static class CraftingSection {
        @Config.Name(value="EnableDisenchantmentTableRecipe")
        @Config.Comment(value={"Should the recipe for the normal disenchantment table be available?"})
        public boolean enableDisenchantmentTableRecipe = true;
        @Config.Name(value="EnableAutomaticTableUpgradeRecipe")
        @Config.Comment(value={"Should the recipe for the automatic-upgrade (disenchantment table) be available?"})
        public boolean enableAutomaticTableUpgradeRecipe = true;
        @Config.Name(value="EnableBulkDisenchantingTableUpgradeRecipe")
        @Config.Comment(value={"Should the recipe for the bulk-disenchanting-upgrade (disenchantment table) be available?"})
        public boolean enableBulkDisenchantingTableUpgradeRecipe = true;
        @Config.Name(value="EnableCyclingTableUpgradeRecipe")
        @Config.Comment(value={"Should the recipe for the cycling-upgrade (disenchantment table) be available?"})
        public boolean enableCyclingTableUpgradeRecipe = true;
        @Config.Name(value="EnableVoidingTableUpgradeRecipe")
        @Config.Comment(value={"Should the recipe for the voiding-upgrade (disenchantment table) be available?"})
        public boolean enableVoidingTableUpgradeRecipe = true;
        @Config.Name(value="EnableClearTableRecipe")
        @Config.Comment(value={"Should the recipe for clearing all upgrades from a disenchantment table be available?"})
        public boolean enableClearTableRecipe = true;
        @Config.Name(value="EnableJarRecipe")
        @Config.Comment(value={"Should the recipe for the jar of experience be available?"})
        public boolean enableJarRecipe = true;
        @Config.Name(value="EnableOverloadJarUpgradeRecipe")
        @Config.Comment(value={"Should the recipe for the overload-upgrade (jar of experience) be available?"})
        public boolean enableOverloadJarUpgradeRecipe = true;
        @Config.Name(value="EnableCapacityJarUpgradeRecipe")
        @Config.Comment(value={"Should the recipe for upgrading the capacity (jar of experience) be available?"})
        public boolean enableCapacityJarUpgradeRecipe = true;
        @Config.Name(value="EnableClearJarRecipe")
        @Config.Comment(value={"Should the recipe for clearing all upgrades from a jar of experience be available?"})
        public boolean enableClearJarRecipe = true;
    }

    public static class ExperienceJarSection {
        @Config.Name(value="JarDefaultExperienceCapacity")
        @Config.Comment(value={"How many experience points should the jar of experience store at most by default?"})
        @Config.RangeInt(min=0)
        public int jarDefaultExperienceCapacity = 1024;
        @Config.Name(value="JarUpgradeCapacityChange")
        @Config.Comment(value={"By how many experience points should the capacity be changed when upgrading a jar of experience?"})
        public int jarUpgradeCapacityChange = 512;
        @Config.Name(value="JarUpgradeMaxCapacity")
        @Config.Comment(value={"What should be the maximal capacity of experience points obtainable via upgrades be for the jar of experience?"})
        public int jarUpgradeMaxCapacity = 2048;
    }
}

