/*
 * Decompiled with CFR 0.152.
 */
package de.impelon.disenchanter.inventory;

import de.impelon.disenchanter.DisenchantingUtils;
import de.impelon.disenchanter.inventory.IDisenchantmentItemHandler;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;

public class DisenchantmentItemStackHandler
extends ItemStackHandler
implements IDisenchantmentItemHandler {
    public static final int SOURCE_SLOT = 0;
    public static final int RECEIVER_SLOT = 1;
    public static final int OUTPUT_SLOT = 2;
    protected static final int NUMBER_OF_SLOTS = 3;
    protected IItemHandlerModifiable inputInventory = new RangedWrapper((IItemHandlerModifiable)this, 0, 3){

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot != 0 && slot != 1) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot != 2) {
                return ItemStack.field_190927_a;
            }
            return super.extractItem(slot, amount, simulate);
        }
    };
    protected IItemHandlerModifiable outputInventory = new RangedWrapper((IItemHandlerModifiable)this, 0, 3){

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot != 0 && slot != 2) {
                return ItemStack.field_190927_a;
            }
            return super.extractItem(slot, amount, simulate);
        }
    };

    public DisenchantmentItemStackHandler() {
        super(3);
    }

    public IItemHandlerModifiable getInputInventory() {
        return this.inputInventory;
    }

    public IItemHandlerModifiable getOutputInventory() {
        return this.outputInventory;
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        switch (slot) {
            case 0: {
                return !DisenchantingUtils.getAvailableEnchantmentIndices(stack).isEmpty();
            }
            case 1: {
                return !DisenchantingUtils.getAppropriateResultTarget(stack).func_190926_b();
            }
        }
        return super.isItemValid(slot, stack);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        return super.insertItem(slot, stack, simulate);
    }

    @Override
    public void setSourceStack(ItemStack stack) {
        this.setStackInSlot(0, stack);
    }

    @Override
    public void setReceiverStack(ItemStack stack) {
        this.setStackInSlot(1, stack);
    }

    @Override
    public void setOutputStack(ItemStack stack) {
        this.setStackInSlot(2, stack);
    }

    @Override
    public ItemStack getSourceStack() {
        return this.getStackInSlot(0);
    }

    @Override
    public ItemStack getReceiverStack() {
        return this.getStackInSlot(1);
    }

    @Override
    public ItemStack getOutputStack() {
        return this.getStackInSlot(2);
    }
}

