/*
 * Decompiled with CFR 0.152.
 */
package de.impelon.disenchanter.inventory;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class InventoryUtils {
    public static ItemStack copyStackWithSize(ItemStack itemstack, int size) {
        return ItemHandlerHelper.copyStackWithSize((ItemStack)itemstack, (int)size);
    }

    public static NonNullList<ItemStack> extractItemsFromInventory(IItemHandler inventory, boolean simulate) {
        NonNullList items = NonNullList.func_191196_a();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            items.add((Object)inventory.extractItem(i, inventory.getSlotLimit(i), simulate));
        }
        return items;
    }

    public static NonNullList<ItemStack> extractItemsFromInventory(IInventory inventory, boolean simulate) {
        NonNullList items = NonNullList.func_191196_a();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (simulate) {
                items.add((Object)inventory.func_70301_a(i));
                continue;
            }
            items.add((Object)inventory.func_70304_b(i));
        }
        return items;
    }

    public static int calcRedstoneFromInventory(TileEntity tileentity) {
        if (tileentity instanceof IInventory) {
            return InventoryUtils.calcRedstoneFromInventory((IInventory)tileentity);
        }
        IItemHandler inventory = (IItemHandler)tileentity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (inventory == null) {
            return 0;
        }
        return InventoryUtils.calcRedstoneFromInventory(inventory);
    }

    public static int calcRedstoneFromInventory(IItemHandler inventory) {
        return ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)inventory);
    }

    public static int calcRedstoneFromInventory(IInventory inventory) {
        return Container.func_94526_b((IInventory)inventory);
    }

    public static void dropInventory(World world, BlockPos position, TileEntity tileentity) {
        if (tileentity instanceof IInventory) {
            InventoryUtils.dropInventory(world, position, (IInventory)tileentity);
            return;
        }
        IItemHandler inventory = (IItemHandler)tileentity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (inventory == null) {
            return;
        }
        InventoryUtils.dropInventory(world, position, inventory);
    }

    public static void dropInventory(World world, BlockPos position, IItemHandler inventory) {
        InventoryUtils.dropItems(world, position, InventoryUtils.extractItemsFromInventory(inventory, true));
    }

    public static void dropInventory(World world, BlockPos position, IInventory inventory) {
        InventoryHelper.func_180175_a((World)world, (BlockPos)position, (IInventory)inventory);
    }

    public static void dropItems(World world, BlockPos position, List<ItemStack> items) {
        for (ItemStack itemstack : items) {
            if (itemstack.func_190926_b()) continue;
            InventoryHelper.func_180173_a((World)world, (double)position.func_177958_n(), (double)position.func_177956_o(), (double)position.func_177952_p(), (ItemStack)itemstack);
        }
    }

    public static void returnInventoryToPlayer(EntityPlayer player, World world, IItemHandler inventory) {
        InventoryUtils.returnItemsToPlayer(player, world, InventoryUtils.extractItemsFromInventory(inventory, false));
    }

    public static void returnInventoryToPlayer(EntityPlayer player, World world, IInventory inventory) {
        InventoryUtils.returnItemsToPlayer(player, world, InventoryUtils.extractItemsFromInventory(inventory, false));
    }

    public static void returnItemsToPlayer(EntityPlayer player, World world, List<ItemStack> items) {
        boolean dropItems = !player.func_70089_S() || player instanceof EntityPlayerMP && ((EntityPlayerMP)player).func_193105_t();
        for (ItemStack itemstack : items) {
            if (itemstack.func_190926_b()) continue;
            if (dropItems) {
                player.func_71019_a(itemstack, false);
                continue;
            }
            player.field_71071_by.func_191975_a(world, itemstack);
        }
    }

    public static ItemStack findFirstItemStackInInventory(IItemHandler inventory, Item itemToFind) {
        return InventoryUtils.findFirstItemStack(InventoryUtils.extractItemsFromInventory(inventory, true), itemToFind);
    }

    public static ItemStack findFirstItemStackInInventory(IInventory inventory, Item itemToFind) {
        return InventoryUtils.findFirstItemStack(InventoryUtils.extractItemsFromInventory(inventory, true), itemToFind);
    }

    public static ItemStack findFirstItemStack(List<ItemStack> items, Item itemToFind) {
        for (ItemStack itemstack : items) {
            if (!itemstack.func_77973_b().equals(itemToFind)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }
}

