/*
 * Decompiled with CFR 0.152.
 */
package de.impelon.disenchanter.proxy;

import de.impelon.disenchanter.DisenchantingProperties;
import de.impelon.disenchanter.block.TableVariant;
import de.impelon.disenchanter.proxy.CommonProxy;
import de.impelon.disenchanter.tileentity.TileEntityDisenchantmentTable;
import de.impelon.disenchanter.tileentity.TileEntityDisenchantmentTableRenderer;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class CombinedClientProxy
extends CommonProxy {
    @Override
    public void preInit(FMLPreInitializationEvent ev) {
        super.preInit(ev);
    }

    public String buildVariantString(IBlockState state) {
        StringBuilder variantBuilder = new StringBuilder();
        DisenchantingProperties properties = DisenchantingProperties.getPropertiesFromState(state);
        for (TableVariant variant : TableVariant.values()) {
            variantBuilder.append((Object)variant);
            variantBuilder.append("=");
            variantBuilder.append(properties.is(variant));
            variantBuilder.append(',');
        }
        return variantBuilder.substring(0, variantBuilder.length() - 1);
    }

    @Override
    public void registerBlocks(RegistryEvent.Register<Block> ev) {
        super.registerBlocks(ev);
        ModelLoader.setCustomStateMapper((Block)disenchantmentTable, (IStateMapper)new DefaultStateMapper(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return new ModelResourceLocation(CommonProxy.disenchantmentTable.getRegistryName(), CombinedClientProxy.this.buildVariantString(state));
            }
        });
    }

    @Override
    public void registerItems(RegistryEvent.Register<Item> ev) {
        super.registerItems(ev);
        ModelLoader.setCustomModelResourceLocation((Item)itemExperienceJar, (int)0, (ModelResourceLocation)new ModelResourceLocation(itemExperienceJar.getRegistryName().toString()));
        for (int meta = 0; meta < 10; meta = (int)((byte)(meta + 1))) {
            IBlockState state = disenchantmentTable.func_176203_a(meta);
            ModelLoader.setCustomModelResourceLocation((Item)itemDisenchantmentTable, (int)meta, (ModelResourceLocation)new ModelResourceLocation(disenchantmentTable.getRegistryName(), this.buildVariantString(state)));
        }
    }

    @Override
    public void load(FMLInitializationEvent ev) {
        super.load(ev);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityDisenchantmentTable.class, (TileEntitySpecialRenderer)new TileEntityDisenchantmentTableRenderer());
    }
}

