/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.client.CustomTextureCreator;
import slimeknights.tconstruct.library.client.model.BakedMaterialModel;
import slimeknights.tconstruct.library.client.model.BakedSimpleItem;
import slimeknights.tconstruct.library.client.model.IPatternOffset;
import slimeknights.tconstruct.library.client.model.ModelHelper;
import slimeknights.tconstruct.library.materials.Material;

public class MaterialModel
implements IPatternOffset,
IModel {
    protected final int offsetX;
    protected final int offsetY;
    private final ImmutableList<ResourceLocation> textures;

    public MaterialModel(ImmutableList<ResourceLocation> textures) {
        this(textures, 0, 0);
    }

    public MaterialModel(ImmutableList<ResourceLocation> textures, int offsetX, int offsetY) {
        this.textures = textures;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        return this.bakeIt(state, format, bakedTextureGetter);
    }

    public BakedMaterialModel bakeIt(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        if (this.offsetX != 0 || this.offsetY != 0) {
            state = new ModelStateComposition(state, (IModelState)TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f((float)this.offsetX / 16.0f, (float)(-this.offsetY) / 16.0f, 0.0f), null, null, null)));
        }
        ImmutableMap map = PerspectiveMapWrapper.getTransforms((IModelState)state);
        IBakedModel base = new ItemLayerModel(this.textures).bake(state, format, bakedTextureGetter);
        BakedMaterialModel bakedMaterialModel = new BakedMaterialModel(base, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)map);
        String baseTexture = base.func_177554_e().func_94215_i();
        Map<String, TextureAtlasSprite> sprites = CustomTextureCreator.sprites.get(baseTexture);
        if (sprites != null) {
            for (Map.Entry<String, TextureAtlasSprite> entry : sprites.entrySet()) {
                Material material = TinkerRegistry.getMaterial(entry.getKey());
                ItemLayerModel model2 = ItemLayerModel.INSTANCE.retexture(ImmutableMap.of((Object)"layer0", (Object)entry.getValue().func_94215_i()));
                IBakedModel bakedModel2 = model2.bake(state, format, bakedTextureGetter);
                if (material.renderInfo.useVertexColoring() && !CustomTextureCreator.exists(baseTexture + "_" + material.identifier)) {
                    int color = material.renderInfo.getVertexColor();
                    ImmutableList.Builder quads = ImmutableList.builder();
                    for (BakedQuad quad : bakedModel2.func_188616_a(null, null, 0L)) {
                        quads.add((Object)ModelHelper.colorQuad((int)color, (BakedQuad)quad));
                    }
                    bakedModel2 = new BakedSimpleItem((ImmutableList<BakedQuad>)quads.build(), (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)map, bakedModel2);
                }
                bakedMaterialModel.addMaterialModel(material, bakedModel2);
            }
        }
        return bakedMaterialModel;
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.of();
    }

    public Collection<ResourceLocation> getTextures() {
        return this.textures;
    }

    public IModelState getDefaultState() {
        return ModelHelper.DEFAULT_ITEM_STATE;
    }

    @Override
    public int getXOffset() {
        return this.offsetX;
    }

    @Override
    public int getYOffset() {
        return this.offsetY;
    }
}

