/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.settings;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import greymerk.roguelike.dungeon.LevelGenerator;
import greymerk.roguelike.dungeon.base.DungeonFactory;
import greymerk.roguelike.dungeon.base.SecretFactory;
import greymerk.roguelike.dungeon.segment.SegmentGenerator;
import greymerk.roguelike.dungeon.settings.ISettings;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.dungeon.settings.SettingIdentifier;
import greymerk.roguelike.dungeon.settings.SettingsType;
import greymerk.roguelike.dungeon.settings.SpawnContext;
import greymerk.roguelike.dungeon.settings.SpawnCriteria;
import greymerk.roguelike.dungeon.settings.TowerSettings;
import greymerk.roguelike.dungeon.towers.Tower;
import greymerk.roguelike.theme.ITheme;
import greymerk.roguelike.theme.Theme;
import greymerk.roguelike.treasure.TreasureManager;
import greymerk.roguelike.treasure.loot.LootRuleManager;
import greymerk.roguelike.treasure.loot.LootTableRule;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IWorldEditor;
import greymerk.roguelike.worldgen.filter.Filter;
import greymerk.roguelike.worldgen.spawners.SpawnerSettings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class DungeonSettings
implements ISettings {
    public static final int MAX_NUM_LEVELS = 5;
    protected SettingIdentifier id;
    protected List<SettingIdentifier> inherit = new ArrayList<SettingIdentifier>();
    protected boolean exclusive = false;
    protected TowerSettings towerSettings;
    protected Map<Integer, LevelSettings> levels = new HashMap<Integer, LevelSettings>();
    protected SpawnCriteria criteria;
    protected LootRuleManager lootRules = new LootRuleManager();
    protected List<LootTableRule> lootTables = new ArrayList<LootTableRule>();
    protected Set<SettingsType> overrides = new HashSet<SettingsType>();

    public DungeonSettings() {
    }

    public DungeonSettings(JsonObject root) throws Exception {
        this();
        List<Integer> lvls;
        LevelSettings setting;
        JsonElement e2;
        if (!root.has("name")) {
            throw new Exception("Setting missing name");
        }
        if (root.has("namespace")) {
            String name = root.get("name").getAsString();
            String namespace = root.get("namespace").getAsString();
            this.id = new SettingIdentifier(namespace, name);
        } else {
            this.id = new SettingIdentifier(root.get("name").getAsString());
        }
        if (root.has("exclusive")) {
            this.exclusive = root.get("exclusive").getAsBoolean();
        }
        if (root.has("criteria")) {
            this.criteria = new SpawnCriteria(root.get("criteria").getAsJsonObject());
        }
        if (root.has("tower")) {
            this.towerSettings = new TowerSettings(root.get("tower"));
        }
        if (root.has("loot_rules")) {
            this.lootRules = new LootRuleManager(root.get("loot_rules"));
        }
        if (root.has("overrides")) {
            JsonArray overrides = root.get("overrides").getAsJsonArray();
            for (JsonElement e2 : overrides) {
                String type = e2.getAsString();
                this.overrides.add(SettingsType.valueOf(type));
            }
        }
        if (root.has("inherit")) {
            JsonArray inherit = root.get("inherit").getAsJsonArray();
            for (JsonElement e2 : inherit) {
                this.inherit.add(new SettingIdentifier(e2.getAsString()));
            }
        }
        for (int i = 0; i < 5; ++i) {
            LevelSettings setting2 = new LevelSettings();
            this.levels.put(i, setting2);
        }
        if (root.has("loot_tables")) {
            JsonArray arr = root.get("loot_tables").getAsJsonArray();
            for (JsonElement e2 : arr) {
                this.lootTables.add(new LootTableRule(e2.getAsJsonObject()));
            }
        }
        if (root.has("num_rooms")) {
            JsonArray arr = root.get("num_rooms").getAsJsonArray();
            for (int i = 0; i < arr.size(); ++i) {
                e2 = arr.get(i);
                setting = this.levels.get(i);
                setting.setNumRooms(e2.getAsInt());
            }
        }
        if (root.has("scatter")) {
            JsonArray arr = root.get("scatter").getAsJsonArray();
            for (int i = 0; i < arr.size(); ++i) {
                e2 = arr.get(i);
                setting = this.levels.get(i);
                setting.setScatter(e2.getAsInt());
            }
        }
        if (root.has("layouts")) {
            JsonArray layouts = root.get("layouts").getAsJsonArray();
            for (JsonElement e2 : layouts) {
                JsonObject layout = e2.getAsJsonObject();
                if (!layout.has("level")) continue;
                List<Integer> levels = this.parseLevels(layout.get("level"));
                for (Integer n : levels) {
                    if (!this.levels.containsKey(n)) continue;
                    LevelSettings setting3 = this.levels.get(n);
                    setting3.setGenerator(LevelGenerator.valueOf(layout.get("type").getAsString().toUpperCase()));
                }
            }
        }
        if (root.has("rooms")) {
            JsonArray roomArray = root.get("rooms").getAsJsonArray();
            for (int i : this.levels.keySet()) {
                LevelSettings level = this.levels.get(i);
                DungeonFactory rooms = new DungeonFactory();
                SecretFactory secrets = new SecretFactory();
                for (JsonElement e3 : roomArray) {
                    List<Integer> levels;
                    JsonObject room = e3.getAsJsonObject();
                    if (!room.has("level") || !(levels = this.parseLevels(room.get("level"))).contains(i)) continue;
                    if (room.has("type") && room.get("type").getAsString().equals("secret")) {
                        secrets.add(room);
                        continue;
                    }
                    rooms.add(room);
                }
                level.setRooms(rooms);
                level.setSecrets(secrets);
            }
        }
        if (root.has("themes")) {
            JsonArray arr = root.get("themes").getAsJsonArray();
            for (JsonElement e4 : arr) {
                JsonObject entry = e4.getAsJsonObject();
                if (!entry.has("level")) continue;
                lvls = this.parseLevels(entry.get("level"));
                for (int n : lvls) {
                    if (!this.levels.keySet().contains(n)) continue;
                    LevelSettings settings = this.levels.get(n);
                    ITheme theme = Theme.create(entry);
                    settings.setTheme(theme);
                }
            }
        }
        if (root.has("segments")) {
            JsonArray arr = root.get("segments").getAsJsonArray();
            for (int lvl : this.levels.keySet()) {
                boolean hasEntry = false;
                SegmentGenerator segments = new SegmentGenerator();
                for (JsonElement jsonElement : arr) {
                    JsonObject entry = jsonElement.getAsJsonObject();
                    List<Integer> lvls2 = this.parseLevels(entry.get("level"));
                    if (!lvls2.contains(lvl)) continue;
                    hasEntry = true;
                    segments.add(entry);
                }
                if (!hasEntry) continue;
                this.levels.get(lvl).setSegments(segments);
            }
        }
        if (root.has("spawners")) {
            JsonArray arr = root.get("spawners").getAsJsonArray();
            for (JsonElement e6 : arr) {
                JsonObject entry = e6.getAsJsonObject();
                lvls = this.parseLevels(entry.get("level"));
                for (int n : lvls) {
                    if (!this.levels.containsKey(n)) continue;
                    LevelSettings level = this.levels.get(n);
                    SpawnerSettings spawners = level.getSpawners();
                    spawners.add(entry);
                }
            }
        }
        if (root.has("filters")) {
            JsonArray arr = root.get("filters").getAsJsonArray();
            for (JsonElement e7 : arr) {
                JsonObject entry = e7.getAsJsonObject();
                lvls = this.parseLevels(entry.get("level"));
                for (int n : lvls) {
                    if (!this.levels.containsKey(n)) continue;
                    String name = entry.get("name").getAsString();
                    Filter type = Filter.valueOf(name.toUpperCase());
                    LevelSettings level = this.levels.get(n);
                    level.addFilter(type);
                }
            }
        }
    }

    public DungeonSettings(DungeonSettings base, DungeonSettings other) {
        this();
        if (other.overrides != null) {
            this.overrides.addAll(other.overrides);
        }
        this.lootRules = new LootRuleManager();
        if (!this.overrides.contains((Object)SettingsType.LOOTRULES)) {
            this.lootRules.add(base.lootRules);
        }
        this.lootRules.add(other.lootRules);
        this.lootTables.addAll(base.lootTables);
        this.lootTables.addAll(other.lootTables);
        for (SettingIdentifier i : other.inherit) {
            this.inherit.add(i);
        }
        this.exclusive = other.exclusive;
        if (this.overrides.contains((Object)SettingsType.TOWER) && other.towerSettings != null) {
            this.towerSettings = new TowerSettings(other.towerSettings);
        } else if (base.towerSettings != null || other.towerSettings != null) {
            this.towerSettings = new TowerSettings(base.towerSettings, other.towerSettings);
        }
        for (int i = 0; i < 5; ++i) {
            this.levels.put(i, new LevelSettings(base.levels.get(i), other.levels.get(i), this.overrides));
        }
    }

    public DungeonSettings(DungeonSettings toCopy) {
        this();
        this.towerSettings = toCopy.towerSettings != null ? new TowerSettings(toCopy.towerSettings) : null;
        this.lootRules = toCopy.lootRules;
        this.lootTables.addAll(toCopy.lootTables);
        for (SettingIdentifier i : toCopy.inherit) {
            this.inherit.add(i);
        }
        this.exclusive = toCopy.exclusive;
        for (int i = 0; i < 5; ++i) {
            LevelSettings level = toCopy.levels.get(i);
            if (level == null) {
                this.levels.put(i, new LevelSettings());
                continue;
            }
            this.levels.put(i, new LevelSettings(level));
        }
        if (toCopy.overrides != null) {
            this.overrides.addAll(toCopy.overrides);
        }
    }

    private List<Integer> parseLevels(JsonElement e) {
        ArrayList<Integer> levels = new ArrayList<Integer>();
        if (e.isJsonArray()) {
            JsonArray arr = e.getAsJsonArray();
            for (JsonElement i : arr) {
                levels.add(i.getAsInt());
            }
            return levels;
        }
        levels.add(e.getAsInt());
        return levels;
    }

    @Override
    public List<SettingIdentifier> getInherits() {
        return this.inherit != null ? this.inherit : new ArrayList<SettingIdentifier>();
    }

    public String getNameSpace() {
        return this.id.getNamespace();
    }

    public String getName() {
        return this.id.getName();
    }

    public void setCriteria(SpawnCriteria criteria) {
        this.criteria = criteria;
    }

    @Override
    public boolean isValid(IWorldEditor editor, Coord pos) {
        if (this.criteria == null) {
            this.criteria = new SpawnCriteria();
        }
        SpawnContext context = new SpawnContext(editor.getInfo(pos));
        return this.criteria.isValid(context);
    }

    @Override
    public LevelSettings getLevelSettings(int level) {
        return this.levels.get(level);
    }

    @Override
    public TowerSettings getTower() {
        if (this.towerSettings == null) {
            return new TowerSettings(Tower.ROGUE, Theme.getTheme(Theme.STONE));
        }
        return this.towerSettings;
    }

    @Override
    public int getNumLevels() {
        return 5;
    }

    @Override
    public Set<SettingsType> getOverrides() {
        return this.overrides;
    }

    @Override
    public boolean isExclusive() {
        return this.exclusive;
    }

    @Override
    public void processLoot(Random rand, TreasureManager treasure) {
        this.lootRules.process(rand, treasure);
        if (!this.lootTables.isEmpty()) {
            for (LootTableRule table : this.lootTables) {
                table.process(treasure);
            }
        }
    }

    public LootRuleManager getLootRules() {
        return this.lootRules;
    }
}

